/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.toolwindow;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.tencent.code.intel.action.base.BaseAnAction;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.context.MainThreadContext;
import com.tencent.code.intel.apibridge.extension.mainthread.context.contextexpression.ContextExpression;
import com.tencent.code.intel.apibridge.extension.mainthread.toolwindow.CustomPopupAction;
import com.tencent.code.intel.apibridge.extension.mainthread.toolwindow.ToolwindowMenuContext;
import com.tencent.code.intel.apibridge.toolwindow.ToolWindowHelper;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.apibridge.util.FusionTextUtils;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.JsonRpcUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MainThreadToolWindow
extends MainThreadBaseProxy {
    private static final String REGISTER_TOOL_WINDOW = "$registerToolWindow";
    private static List<ToolwindowMenuContext> toolWindowList;
    private static final Map<Project, List<AnAction>> projectActionsMap;

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        if (name.equals(REGISTER_TOOL_WINDOW)) {
            this.registerToolWindow(project, args, complete);
        }
        super.handleReq(project, name, args, complete);
    }

    public void updateToolWindow(Project project) {
        try {
            ThreadManager.getInstance().runUiThread(() -> {
                ArrayList<AnAction> actionList = new ArrayList<AnAction>();
                HashMap<String, List> groupedActions = new HashMap<String, List>();
                ToolWindow toolwindow = ToolWindowHelper.getToolwindow(project);
                for (ToolwindowMenuContext toolwindowItem : toolWindowList) {
                    AnAction action = this.createMenuAction(project, toolwindowItem.getCommand(), toolwindowItem.getTitle(), toolwindowItem.getRealRule(), toolwindowItem.getIcon());
                    String group = toolwindowItem.getGroup();
                    if (group != null) {
                        if (group.startsWith("basic@")) {
                            groupedActions.computeIfAbsent("basic", k -> new ArrayList()).add(action);
                            continue;
                        }
                        if (group.startsWith("group@")) {
                            groupedActions.computeIfAbsent("group", k -> new ArrayList()).add(action);
                            continue;
                        }
                        if (actionList.contains(action)) continue;
                        actionList.add(action);
                        continue;
                    }
                    if (actionList.contains(action)) continue;
                    actionList.add(action);
                }
                ArrayList<AnAction> menuActions = new ArrayList<AnAction>();
                if (groupedActions.containsKey("basic")) {
                    menuActions.addAll((Collection)groupedActions.get("basic"));
                }
                if (groupedActions.containsKey("basic") && groupedActions.containsKey("group")) {
                    menuActions.add((AnAction)new Separator());
                }
                if (groupedActions.containsKey("group")) {
                    menuActions.addAll((Collection)groupedActions.get("group"));
                }
                if (!menuActions.isEmpty()) {
                    actionList.add(new CustomPopupAction(menuActions));
                }
                if (toolwindow != null) {
                    toolwindow.setTitleActions(actionList);
                    projectActionsMap.put(project, actionList);
                }
            });
        }
        catch (Exception e) {
            LogManager.error(MainThreadToolWindow.class, "initToolWindow: init tool window failed " + e.getMessage());
        }
    }

    private void registerToolWindow(Project project, List<Object> menus, Consumer<Object> complete) {
        try {
            if (menus == null || menus.isEmpty()) {
                complete.accept(false);
                return;
            }
            toolWindowList = menus.stream().filter(keybinding -> keybinding instanceof List).flatMap(items -> ((List)items).stream()).map(menu -> {
                ToolwindowMenuContext menuContext = JsonRpcUtils.toJavaObject(menu, ToolwindowMenuContext.class);
                menuContext.setProject(project);
                return menuContext;
            }).collect(Collectors.toList());
            complete.accept(true);
            this.updateToolWindow(project);
        }
        catch (Exception e) {
            LogManager.error(MainThreadToolWindow.class, "registerToolWindow: register tool window failed " + e.getMessage());
            complete.accept(e);
        }
    }

    private AnAction createMenuAction(final Project project, final String command, String title, final ContextExpression rule, String icon) {
        Icon iconObj = null;
        if (icon != null) {
            try {
                Field field = SdkIcons.class.getField(icon);
                iconObj = (Icon)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LogManager.warn(MainThreadToolWindow.class, "Failed to get icon: " + icon);
            }
        }
        BaseAnAction action = new BaseAnAction(title, "", iconObj){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean shouldShow = rule.evaluate();
                boolean isEnabled = true;
                MainThreadContext mainThreadContext = MainThreadContext.getInstance(project);
                if (mainThreadContext != null) {
                    HashMap<String, String> context = mainThreadContext.getContext();
                    String isInConversationKey = FusionTextUtils.withPluginNamePrefix("InConversation", null);
                    List<String> enableCommands = List.of(FusionActionUtils.getInternalCommandId("codingcopilot.chatHistory"), FusionActionUtils.getInternalCommandId("codingcopilot.codebuddy.settings.show"));
                    if (context != null && context.containsKey(isInConversationKey) && enableCommands.contains(command)) {
                        isEnabled = !"true".equals(context.get(isInConversationKey));
                    }
                }
                e.getPresentation().setVisible(shouldShow);
                e.getPresentation().setEnabled(shouldShow && isEnabled);
            }

            @Override
            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project2;
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((project2 = e.getProject()) == null || project2.isDisposed()) {
                    return;
                }
                ExtHostCommands.executeCommand(project2, command, null, jsonObject -> {});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/tencent/code/intel/apibridge/extension/mainthread/toolwindow/MainThreadToolWindow$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/toolwindow/MainThreadToolWindow$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        return action;
    }

    public static void refreshToolWindowActions(Project project) {
        ThreadManager.getInstance().runUiThread(() -> {
            List<AnAction> actions = projectActionsMap.get(project);
            ToolWindow toolWindow = ToolWindowHelper.getToolwindow(project);
            if (actions != null && !actions.isEmpty() && toolWindow != null) {
                toolWindow.setTitleActions(actions);
            }
        });
    }

    static {
        projectActionsMap = new HashMap<Project, List<AnAction>>();
    }
}

