/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.webview;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.UriComponents;
import com.tencent.code.intel.apibridge.extension.extension.theming.ExtHostTheming;
import com.tencent.code.intel.apibridge.extension.extension.webview.ExtHostWebviews;
import com.tencent.code.intel.apibridge.extension.mainthread.context.MainThreadContext;
import com.tencent.code.intel.apibridge.extension.mainthread.webview.ui.TextBackgroundPanel;
import com.tencent.code.intel.apibridge.report.FusionTelemetryMeterEvent;
import com.tencent.code.intel.apibridge.report.FusionTelemetryMeterService;
import com.tencent.code.intel.apibridge.report.model.Event;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.apibridge.toolwindow.ToolWindowHelper;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.apibridge.util.UriComponentConverter;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.sidebar.conversation.webview.ChatConstant;
import com.tencent.code.intel.util.PluginUtils;
import com.tencent.code.intel.util.URLUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.http.util.TextUtils;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefDragData;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.Nullable;

public class WebviewBrowser {
    JBCefBrowser browser;
    public String viewType = "";
    private JBCefJSQuery postMessageQuery;
    private Project project;
    private RPCProtocol rpcChannel;
    private boolean hasResolve = false;
    private volatile boolean isBrowserOpen = false;
    private final AtomicInteger dragOperationCounter = new AtomicInteger(0);
    private final ConcurrentHashMap<Integer, List<UriComponents>> dragOperations = new ConcurrentHashMap();
    private long lastResolveTime = 0L;

    public WebviewBrowser(Project project, RPCProtocol rpcChannel) {
        this.project = project;
        this.rpcChannel = rpcChannel;
        this.monitorTheme();
    }

    public void updateViewType(String viewType) {
        this.viewType = viewType;
        MainThreadContext.getInstance(this.project).getContext().put("view", viewType);
    }

    public void createWebview(String viewType, String htmlContent) throws IOException {
        if (!viewType.equals(this.viewType)) {
            LogManager.warn(WebviewBrowser.class, "create viewType:" + viewType + "is not " + this.viewType);
            return;
        }
        this.reportSetHtml();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.configureJcefForLegacyVersions();
            JBCefClient client = JBCefApp.getInstance().createClient();
            client.setProperty("JBCefClient.JSQuery.poolSize", (Object)10);
            JBCefBrowserBuilder builder = new JBCefBrowserBuilder();
            builder.setClient(client);
            builder.setCreateImmediately(true);
            builder.setOffScreenRendering(this.getOSRenderingByPlatform());
            builder.setEnableOpenDevToolsMenuItem(PluginUtils.isDebug());
            this.browser = builder.build();
            this.browser.setZoomLevel(0.0);
            this.browser.getJBCefClient().addDragHandler(new CefDragHandler(){

                public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
                    LogManager.info(WebviewBrowser.class, "onDragEnter called, isFile: " + dragData.isFile());
                    if (dragData.isFile()) {
                        String fragmentText = dragData.getFragmentText();
                        LogManager.info(WebviewBrowser.class, "Dragged files fragmentText: " + fragmentText);
                        ArrayList<UriComponents> uriComponentsList = new ArrayList<UriComponents>();
                        if (!TextUtils.isEmpty((CharSequence)fragmentText)) {
                            String[] fileUrls;
                            for (String fileUrl : fileUrls = fragmentText.split("\\r?\\n")) {
                                if (!(fileUrl = fileUrl.trim()).startsWith("file:")) continue;
                                String normalizedUrl = WebviewBrowser.this.normalizeFileUrl(fileUrl);
                                LogManager.info(WebviewBrowser.class, "  - Original URL: " + fileUrl);
                                LogManager.info(WebviewBrowser.class, "  - Normalized URL: " + normalizedUrl);
                                VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(normalizedUrl);
                                if (vFile != null) {
                                    UriComponents uriComponents = UriComponentConverter.getUriComponents(vFile);
                                    uriComponentsList.add(uriComponents);
                                    LogManager.info(WebviewBrowser.class, "  - Resolved file: " + vFile.getPath());
                                    continue;
                                }
                                LogManager.warn(WebviewBrowser.class, "  - Cannot find VirtualFile for: " + normalizedUrl);
                            }
                        }
                        if (!uriComponentsList.isEmpty()) {
                            int operationId = WebviewBrowser.this.dragOperationCounter.incrementAndGet();
                            WebviewBrowser.this.dragOperations.put(operationId, uriComponentsList);
                            LogManager.info(WebviewBrowser.class, "Drag operation created: " + operationId + ", files: " + uriComponentsList.size());
                        } else {
                            LogManager.warn(WebviewBrowser.class, "No valid files resolved from drag data");
                        }
                        return false;
                    }
                    return true;
                }
            }, this.browser.getCefBrowser());
            this.browser.getJBCefClient().addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(){

                public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                    String url = URLDecoder.decode(request.getURL(), StandardCharsets.UTF_8);
                    if (!WebviewBrowser.this.dragOperations.isEmpty() && url.startsWith("file://")) {
                        LogManager.info(WebviewBrowser.class, "process drag file in onBeforeBrowse, url: " + url);
                        return true;
                    }
                    WebviewBrowser.this.isBrowserOpen = false;
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        if (url.startsWith("http")) {
                            WebviewBrowser.this.isBrowserOpen = true;
                            URLUtils.browse(url);
                            return true;
                        }
                        if (url.startsWith("command")) {
                            ExtHostCommands.executeUriCommand(WebviewBrowser.this.rpcChannel.project, url, null);
                            return true;
                        }
                    }
                    return super.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect);
                }
            }, this.browser.getCefBrowser());
            this.browser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

                public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                    super.onLoadStart(browser, frame, transitionType);
                    LogManager.info(WebviewBrowser.class, "onLoadStart");
                    WebviewBrowser.this.reportWebviewLoadBegin();
                }

                public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                    super.onLoadEnd(browser, frame, httpStatusCode);
                    WebviewBrowser.this.initLoadBaseScripts();
                    LogManager.info(WebviewBrowser.class, "onLoadEnd:" + httpStatusCode);
                    if (httpStatusCode == 0 || httpStatusCode == 200) {
                        WebviewBrowser.this.reportWebviewLoadEnd(0, null);
                        return;
                    }
                    WebviewBrowser.this.reportWebviewLoadEnd(httpStatusCode, null);
                }

                public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    boolean needAddDragFile;
                    if (WebviewBrowser.this.isBrowserOpen) {
                        LogManager.info(WebviewBrowser.class, "return when open browser" + failedUrl);
                        return;
                    }
                    boolean bl = needAddDragFile = !WebviewBrowser.this.dragOperations.isEmpty() && failedUrl.startsWith("file://");
                    if (needAddDragFile) {
                        LogManager.info(WebviewBrowser.class, "process drag and drop file, fileUrl:" + failedUrl);
                        return;
                    }
                    super.onLoadError(browser, frame, errorCode, errorText, failedUrl);
                    LogManager.warn(WebviewBrowser.class, "onLoadError:" + String.valueOf(errorCode) + ":" + errorText + ":" + failedUrl);
                    WebviewBrowser.this.reportWebviewLoadEnd(errorCode.getCode(), errorText);
                }
            }, this.browser.getCefBrowser());
            this.postMessageQuery = this.createOpenLinkQuery((JBCefBrowserBase)this.browser);
            this.postMessageQuery.addHandler(message -> {
                this.sendOnDidReceiveMessage((String)message);
                return null;
            });
            String newHtmlContent = this.injectQueryInfo(this.postMessageQuery, this.ensureDarkBackground(htmlContent));
            this.browser.loadHTML(newHtmlContent);
            this.browser.getCefBrowser().setZoomLevel(0.0);
            final JPanel cardPanel = new JPanel(new CardLayout());
            JPanel placeholder = new JPanel(new BorderLayout());
            Color themeBg = this.getIdeBackgroundColor();
            placeholder.setOpaque(true);
            if (themeBg != null) {
                placeholder.setBackground(themeBg);
            }
            cardPanel.add((Component)placeholder, "placeholder");
            final JComponent browserComponent = this.browser.getComponent();
            try {
                browserComponent.setOpaque(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JPanel browserWrapper = new JPanel(new BorderLayout());
            browserWrapper.setOpaque(true);
            if (themeBg != null) {
                browserWrapper.setBackground(themeBg);
            }
            browserWrapper.add((Component)browserComponent, "Center");
            cardPanel.add((Component)browserWrapper, "webview");
            TextBackgroundPanel errorPanel = new TextBackgroundPanel(LocaleManager.get("ui.webview.tips"));
            errorPanel.setOpaque(true);
            if (themeBg != null) {
                errorPanel.setBackground(themeBg);
            }
            cardPanel.add((Component)((Object)errorPanel), "error");
            this.browser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

                public void onLoadEnd(CefBrowser b, CefFrame frame, int httpStatusCode) {
                    ThreadManager.getInstance().runUiThread(() -> {
                        CardLayout cl = (CardLayout)cardPanel.getLayout();
                        cl.show(cardPanel, "webview");
                        WebviewBrowser.this.browser.getCefBrowser().setZoomLevel(0.0);
                        browserComponent.revalidate();
                        browserComponent.repaint();
                    });
                }

                public void onLoadError(CefBrowser b, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    boolean needAddDragFile;
                    if (WebviewBrowser.this.isBrowserOpen) {
                        WebviewBrowser.this.isBrowserOpen = false;
                        LogManager.info(WebviewBrowser.class, "return when open browser" + failedUrl);
                        return;
                    }
                    boolean bl = needAddDragFile = !WebviewBrowser.this.dragOperations.isEmpty() && failedUrl.startsWith("file://");
                    if (needAddDragFile) {
                        List<UriComponents> files;
                        Integer latestOperationId = WebviewBrowser.this.dragOperations.keySet().stream().max(Integer::compareTo).orElse(null);
                        if (latestOperationId != null && (files = WebviewBrowser.this.dragOperations.remove(latestOperationId)) != null && !files.isEmpty()) {
                            LogManager.info(WebviewBrowser.class, "Processing drag operation: " + latestOperationId + ", files: " + files.size());
                            ThreadManager.getInstance().runUiThread(() -> {
                                String addToChatCommand = FusionActionUtils.getInternalCommandId("codingcopilot.addToChat");
                                ExtHostCommands.executeCommand(WebviewBrowser.this.project, addToChatCommand, List.of(new ArrayList(), files), JSONObject2 -> LogManager.info(WebviewBrowser.class, "Drag operation completed: " + latestOperationId));
                            });
                        }
                    } else {
                        ThreadManager.getInstance().runUiThread(() -> {
                            CardLayout cl = (CardLayout)cardPanel.getLayout();
                            cl.show(cardPanel, "error");
                        });
                    }
                }
            }, this.browser.getCefBrowser());
            ContentFactory contentFactory = ContentFactory.getInstance();
            Content content = contentFactory.createContent((JComponent)cardPanel, null, false);
            content.setCloseable(false);
            ToolWindow toolWindow = ToolWindowHelper.getToolwindow(this.project);
            if (toolWindow != null) {
                toolWindow.getContentManager().addContent(content);
                ThreadManager.getInstance().executeDelay(100, () -> {
                    if (toolWindow.isVisible()) {
                        this.triggerWebviewRender();
                    }
                    return null;
                });
            }
        }, ModalityState.NON_MODAL);
    }

    private void configureJcefForLegacyVersions() {
        boolean isOldIdeVersion;
        String ideVersion = ApplicationInfo.getInstance().getMajorVersion() + "." + ApplicationInfo.getInstance().getMinorVersion();
        boolean bl = isOldIdeVersion = ideVersion.compareTo("2025.2") < 0;
        if (isOldIdeVersion) {
            try {
                String key = "ide.browser.jcef.out-of-process.enabled";
                LogManager.info(WebviewBrowser.class, "ide.browser.jcef.out-of-process.enabled is:" + Registry.is((String)key));
                if (Registry.is((String)key)) {
                    Registry.get((String)key).setValue(false);
                }
                System.setProperty("ide.browser.jcef.out-of-process.enabled", "false");
                LogManager.info(WebviewBrowser.class, "Disabled out-of-process for IDE version: " + ideVersion);
            }
            catch (Exception e) {
                LogManager.warn(WebviewBrowser.class, "set out-of-process fail:" + String.valueOf(e));
            }
        } else {
            LogManager.info(WebviewBrowser.class, "Skipping out-of-process config override for IDE version: " + ideVersion);
        }
        try {
            System.setProperty("ide.browser.jcef.gpu.enabled", "false");
            LogManager.info(WebviewBrowser.class, "GPU disabled for all versions");
        }
        catch (Exception e) {
            LogManager.warn(WebviewBrowser.class, "set gpu.enabled fail:" + String.valueOf(e));
        }
    }

    private void clearAllDragOperations() {
        int count = this.dragOperations.size();
        this.dragOperations.clear();
        if (count > 0) {
            LogManager.info(WebviewBrowser.class, "Cleared " + count + " pending drag operations");
        }
    }

    private void triggerWebviewRender() {
        if (this.browser == null) {
            return;
        }
        try {
            this.browser.getCefBrowser().setFocus(false);
            this.browser.getCefBrowser().setFocus(true);
        }
        catch (Exception e) {
            LogManager.warn(WebviewBrowser.class, "Error triggering webview render: " + e.getMessage());
        }
    }

    public void resetWebview() {
        ThreadManager.getInstance().runUiThreadSave(() -> {
            WebviewBrowser webviewBrowser = this;
            synchronized (webviewBrowser) {
                ToolWindow toolWindow = ToolWindowHelper.getToolwindow(this.project);
                if (toolWindow != null) {
                    toolWindow.getContentManager().removeAllContents(true);
                }
                this.hasResolve = false;
                this.lastResolveTime = 0L;
                if (this.postMessageQuery != null) {
                    this.postMessageQuery.dispose();
                    this.postMessageQuery = null;
                }
                if (this.browser != null) {
                    this.browser.dispose();
                    this.browser = null;
                }
                this.clearAllDragOperations();
                LogManager.info(WebviewBrowser.class, "Webview reset completed, viewType preserved: " + this.viewType);
            }
        });
    }

    public void postMessage(String message) {
        ThreadManager.getInstance().runUiThreadSave(() -> {
            String script = String.format("window.postMessage(%s, '*');", message);
            if (this.browser == null) {
                LogManager.info(WebviewBrowser.class, "current browser is null, self:" + String.valueOf(this));
                return;
            }
            this.browser.getCefBrowser().executeJavaScript(script, this.browser.getCefBrowser().getURL(), 0);
        });
    }

    private JBCefJSQuery createOpenLinkQuery(JBCefBrowserBase browser) {
        return JBCefJSQuery.create((JBCefBrowserBase)browser);
    }

    private String injectQueryInfo(JBCefJSQuery query, String htmlContent) {
        String queryHost = ChatConstant.SCRIPT_HOST_API.replace("[jsonStr]", query.inject("jsonStr"));
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add(queryHost);
        return this.injectScript(htmlContent, scripts);
    }

    private String injectScript(String content, List<String> injectScripts) {
        for (String script : injectScripts) {
            String[] parts = script.split("=", 2);
            if (parts.length != 2) continue;
            String key = parts[0];
            String newValue = parts[1];
            String scriptTagPattern = "<script>" + key + "=";
            if (content.contains(scriptTagPattern)) {
                String regex = "<script>" + key + "=[^<]*?</script>";
                String replacement = "<script>" + key + "=" + newValue + "</script>";
                content = content.replaceAll(regex, replacement);
                continue;
            }
            String scriptTag = "\n<script>" + script + "</script>";
            content = content.replace("<head>", "<head>" + scriptTag);
        }
        return content;
    }

    private void sendOnDidReceiveMessage(String message) {
        ExtHostWebviews.postMessage(this.viewType, message, this.rpcChannel);
    }

    private void reportWillCreateWebview() {
        Event event = new Event();
        FusionTelemetryMeterService meterService = FusionTelemetryMeterService.getInstance(this.rpcChannel.project);
        if (meterService != null) {
            meterService.report(FusionTelemetryMeterEvent.WEB_EVENT_WILL_CREATE_WEBVIEW, event);
        }
    }

    private void reportSetHtml() {
        Event event = new Event();
        FusionTelemetryMeterService meterService = FusionTelemetryMeterService.getInstance(this.rpcChannel.project);
        if (meterService != null) {
            meterService.report(FusionTelemetryMeterEvent.WEB_EVENT_SET_HTML, event);
        }
    }

    private void reportWebviewLoadBegin() {
        Event event = new Event();
        FusionTelemetryMeterService meterService = FusionTelemetryMeterService.getInstance(this.rpcChannel.project);
        if (meterService != null) {
            meterService.report(FusionTelemetryMeterEvent.WEB_EVENT_LOAD_BEGIN, event);
        }
    }

    private void reportWebviewLoadEnd(int errorCode, @Nullable String errorText) {
        FusionTelemetryMeterService meterService;
        Event event = new Event();
        if (errorCode != 0) {
            event.getExtraFields().put("error_code", String.valueOf(errorCode));
            event.getExtraFields().put("error_text", errorText == null ? "" : errorText);
        }
        if ((meterService = FusionTelemetryMeterService.getInstance(this.rpcChannel.project)) != null) {
            meterService.report(FusionTelemetryMeterEvent.WEB_EVENT_LOAD_END, event);
        }
    }

    private void monitorTheme() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, scheme -> {
            String themeType = "dark";
            if (!PluginUtils.isDarkTheme()) {
                themeType = "light";
            }
            this.resetThemeScript();
            ExtHostTheming.onColorThemeChange(themeType, this.rpcChannel);
        });
    }

    private void resetThemeScript() {
        if (this.browser == null) {
            return;
        }
        if (PluginUtils.isDarkTheme()) {
            this.browser.getCefBrowser().executeJavaScript(ChatConstant.SCRIPT_DARK_THEME, "", 0);
        } else {
            this.browser.getCefBrowser().executeJavaScript(ChatConstant.SCRIPT_LIGHT_THEME, "", 0);
        }
    }

    private void initLoadBaseScripts() {
        this.browser.getCefBrowser().executeJavaScript(ChatConstant.SCRIPT_PLATFORM, "", 0);
        this.browser.getCefBrowser().executeJavaScript(ChatConstant.SCRIPT_STYLE_FILE, "", 0);
        this.browser.getCefBrowser().executeJavaScript(ChatConstant.SCRIPT_META_UTF8, "", 0);
        this.resetThemeScript();
        this.injectCssFromFile();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readCssFile() {
        String cssPath = "webview-static/jetbrains.css";
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(cssPath);){
            if (inputStream == null) {
                throw new RuntimeException("CSS file not found: " + cssPath);
            }
            Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());
            try {
                String string = scanner.useDelimiter("\\A").next().replace("`", "\\`").replace("$", "\\$");
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("read css file failed", e);
        }
    }

    public void injectCssFromFile() {
        try {
            String cssContent = this.readCssFile();
            String script = String.format("(function() {\n    var style = document.createElement('style');\n    style.type = 'text/css';\n    style.innerHTML = `%s`;\n    style.setAttribute('data-jetbrains', 'true');\n    style.setAttribute('nonce', window.__webpack_nonce__);\n    document.head.appendChild(style);\n})();", cssContent);
            this.browser.getCefBrowser().executeJavaScript(script, "", 0);
        }
        catch (Exception e) {
            System.err.println("CSS \u6ce8\u5165\u5931\u8d25: " + e.getMessage());
        }
    }

    private String ensureDarkBackground(String htmlContent) {
        String style = "<meta name=\"color-scheme\" content=\"dark\"><style>html,body{height:100%;background:#2B2D30;color:#DDD;margin:0;padding:0;}</style>";
        if (htmlContent == null) {
            return "<head>" + style + "</head>";
        }
        if (htmlContent.toLowerCase().contains("<head")) {
            return htmlContent.replaceFirst("(?i)</head>", style + "</head>");
        }
        return "<head>" + style + "</head>" + htmlContent;
    }

    private Color getIdeBackgroundColor() {
        try {
            Color c = UIManager.getColor("EditorPane.background");
            if (c == null) {
                c = UIManager.getColor("Panel.background");
            }
            return c;
        }
        catch (Exception exception) {
            return new Color(43, 45, 48);
        }
    }

    private boolean getOSRenderingByPlatform() {
        if (SystemInfo.isMac || SystemInfo.isWindows) {
            return false;
        }
        String ideVersion = ApplicationInfo.getInstance().getMajorVersion();
        return ideVersion.compareTo("2023") >= 0;
    }

    private String normalizeFileUrl(String fileUrl) {
        if (fileUrl == null || !fileUrl.startsWith("file:")) {
            return fileUrl;
        }
        String path = fileUrl.substring(5);
        while (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        if (SystemInfo.isWindows && (path = path.replace("\\", "/")).length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            return "file:///" + path;
        }
        return "file:///" + path;
    }
}

