/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.webview;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.toolwindow.ToolWindowHelper;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.function.Consumer;

public class WebviewService
extends MainThreadBaseProxy {
    private final String SET_HTML = "$setHtml";
    private final String POST_MSG = "$postMessage";
    private final String FOCUS = "$focus";
    private final String SET_OPTIONS = "$setOptions";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$setHtml": {
                this.setHtml(project, args);
                complete.accept(null);
                break;
            }
            case "$postMessage": {
                this.postMessage(project, args, complete);
                break;
            }
            case "$focus": {
                ToolWindowHelper.openWindow(project, true);
                complete.accept(null);
                break;
            }
            case "$setOptions": {
                this.setOptions(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void setHtml(Project project, List<Object> args) {
        if (!ToolWindowHelper.isWebviewEnable()) {
            LogManager.warn(WebviewService.class, "IDE version is less than 2022.1.1");
            return;
        }
        if (args.size() < 2) {
            return;
        }
        String viewType = args.get(0).toString();
        String htmlPayload = args.get(1).toString();
        String html = new String(Base64.getDecoder().decode(htmlPayload), StandardCharsets.UTF_8);
        ThreadManager.getInstance().runUiThreadSave(() -> {
            try {
                NodeRunner.getInstance(project).getWebviewBrowser().createWebview(viewType, html);
            }
            catch (IOException e) {
                LogManager.info(WebviewService.class, "set html error" + e.getMessage());
            }
        });
    }

    private void postMessage(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 2) {
            complete.accept(false);
            return;
        }
        String message = args.get(1).toString();
        NodeRunner.getInstance(project).getWebviewBrowser().postMessage(message);
        complete.accept(true);
    }

    private void setOptions(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 2) {
            complete.accept(false);
            return;
        }
        complete.accept(null);
    }
}

