/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.webview.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.border.Border;

public class ButtonBuilder {
    private static JButton DEFAULT_BUTTON = new JButton();

    public static JButton createRadCustomColorButton(Color fgColor, int radius, Color bgColor, Color bgColorGradient1, Color bgColorGradient2, Color bgPressColor) {
        RoundButton button = new RoundButton(radius, bgColor, bgColorGradient1, bgColorGradient2, bgPressColor);
        button.setForeground(fgColor);
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    private static class RoundBorder
    implements Border {
        private Color color;
        private int radius;

        public RoundBorder(Color color, int radius) {
            this.color = color;
            this.radius = radius;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return DEFAULT_BUTTON.getBorder().getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.color);
            g2.drawRoundRect(0, 0, c.getWidth() - 1, c.getHeight() - 1, this.radius, this.radius);
            g2.dispose();
        }
    }

    private static class RoundButton
    extends JButton {
        private int radius;
        private Color bgColor;
        private Color bgColorGradient1;
        private Color bgColorGradient2;
        private Color bgPressColor;
        private boolean isPressed = false;

        public RoundButton(int radius, Color bgColor, Color bgColorGradient1, Color bgColorGradient2, Color bgPressColor) {
            this.radius = radius;
            this.bgColor = bgColor;
            this.bgColorGradient1 = bgColorGradient1;
            this.bgColorGradient2 = bgColorGradient2;
            this.bgPressColor = bgPressColor;
            this.setBorder(this.createRoundBorder(bgColor, radius));
            super.setContentAreaFilled(false);
            if (bgPressColor == null) {
                bgPressColor = new Color(0xF0F7FF);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    isPressed = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    isPressed = false;
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bgColor != null) {
                if (this.isPressed) {
                    g2.setColor(this.bgPressColor);
                } else {
                    g2.setColor(this.bgColor);
                }
            } else if (this.bgColorGradient1 != null && this.bgColorGradient2 != null) {
                if (this.isPressed) {
                    g2.setColor(this.bgPressColor);
                } else {
                    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.bgColorGradient1, super.getSize().width, super.getSize().height, this.bgColorGradient2, true);
                    g2.setPaint(gradient);
                }
            } else {
                g2.setColor(this.bgPressColor);
            }
            g2.fillRoundRect(0, 0, super.getSize().width - 1, super.getSize().height - 1, this.radius, this.radius);
            super.paintComponent(g2);
            g2.dispose();
        }

        public Border createRoundBorder(Color color, int radius) {
            return new RoundBorder(color, radius);
        }
    }
}

