/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.webview.ui;

import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.http.util.TextUtils;

public class TextBackgroundPanel
extends SimpleToolWindowPanel {
    private String text;

    public TextBackgroundPanel(String text) {
        super(true, true);
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.text = text;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (TextUtils.isEmpty((CharSequence)this.text)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = UIUtil.getLabelFont();
        g2d.setFont(font);
        g2d.setColor(new Color(210, 68, 22));
        String[] lines = this.text.split("\n");
        FontMetrics fm = g2d.getFontMetrics();
        int lineHeight = fm.getHeight() + 2;
        int startY = this.getHeight() - fm.getDescent() - 5;
        for (int i = lines.length - 1; i >= 0; --i) {
            if (TextUtils.isEmpty((CharSequence)lines[i])) continue;
            Rectangle2D bounds = fm.getStringBounds(lines[i], g2d);
            int x = (this.getWidth() - (int)bounds.getWidth()) / 2;
            int y = startY - (lines.length - 1 - i) * lineHeight;
            g2d.drawString(lines[i], x, y);
        }
    }
}

