/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.window;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.sidebarwebview.chat.bean.ChatUri;
import com.tencent.code.intel.util.URLUtils;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.util.TextUtils;

public class MainThreadWindow
extends MainThreadBaseProxy {
    private final String OPEN_URI = "$openUri";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$openUri": {
                this.openUri(args, complete);
            }
        }
    }

    private void openUri(List<Object> args, Consumer<Object> complete) {
        try {
            if (args == null || args.isEmpty()) {
                complete.accept(false);
                return;
            }
            Object url = "";
            if (args.get(1) != null) {
                url = args.get(1).toString();
            } else {
                ChatUri uri = (ChatUri)JSONObject.from((Object)args.get(0)).toJavaObject(ChatUri.class, new JSONReader.Feature[0]);
                if (uri != null) {
                    String authority = TextUtils.isEmpty((CharSequence)uri.getAuthority()) ? "" : uri.getAuthority();
                    url = uri.getScheme() + "://" + authority + uri.getPath();
                    String query = uri.getQuery();
                    Object object = url = query != null ? (String)url + "?" + query : url;
                }
            }
            if (((String)url).length() <= 0) {
                complete.accept(false);
                return;
            }
            String finalUrl = url;
            ThreadManager.getInstance().runUiThread(() -> {
                URLUtils.browse(finalUrl);
                complete.accept(true);
            });
        }
        catch (Exception e) {
            complete.accept(false);
            LogManager.warn(MainThreadWindow.class, "open uri error" + e.getMessage());
        }
    }
}

