/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.workspace;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.workspace.SearchOption;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.sidebarwebview.chat.bean.ChatUri;
import com.tencent.code.intel.util.FileUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MainThreadWorkspace
extends MainThreadBaseProxy {
    private final String FILE_SEARCH = "$startFileSearch";
    private final String TEXT_SEARCH = "$startTextSearch";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$startFileSearch": {
                ThreadManager.getInstance().runThread(() -> {
                    try {
                        String excludePattern;
                        if (args == null || args.size() < 2 && args.get(1) == null) {
                            complete.accept(Collections.emptyList());
                            return;
                        }
                        SearchOption option = (SearchOption)JSONObject.from(args.get(1)).toJavaObject(SearchOption.class, new JSONReader.Feature[0]);
                        if (option == null) {
                            complete.accept(Collections.emptyList());
                            return;
                        }
                        String includePattern = option.getIncludePattern() == null ? "" : option.getIncludePattern();
                        List<Object> excludePatterns = option.getExcludePattern() == null ? new ArrayList() : option.getExcludePattern();
                        String actualExcludePattern = excludePattern = excludePatterns.isEmpty() ? "" : option.getExcludePattern().get(0);
                        if (excludePattern.startsWith("{") && excludePattern.contains("\"pattern\":")) {
                            try {
                                JSONObject excludeJson = JSONObject.parseObject((String)excludePattern);
                                if (excludeJson.containsKey("pattern")) {
                                    actualExcludePattern = excludeJson.getString("pattern");
                                }
                            }
                            catch (Exception e) {
                                LogManager.error(MainThreadWorkspace.class, "Failed to parse exclude pattern JSON: " + excludePattern);
                            }
                        }
                        List<VirtualFile> files = FileUtils.findFilesByWildcard(project, includePattern, actualExcludePattern, null);
                        complete.accept(files.stream().map(file -> new ChatUri(file.getPath(), "file", FileUtil.toSystemDependentName((String)file.getPath()))).collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        complete.accept(Collections.emptyList());
                    }
                });
                break;
            }
        }
    }
}

