/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.listener;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.tencent.code.intel.apibridge.extension.extension.diagnostics.ExtHostDiagnostics;
import com.tencent.code.intel.manager.LogManager;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagnosticsAsyncFileListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        Set<VirtualFile> relevantFiles;
        if (events == null) {
            DiagnosticsAsyncFileListener.$$$reportNull$$$0(0);
        }
        if ((relevantFiles = events.stream().filter(this::isRelevantEvent).map(VFileEvent::getFile).filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty()) {
            return null;
        }
        return new DiagnosticsChangeApplier(relevantFiles);
    }

    private boolean isRelevantEvent(VFileEvent event) {
        return event instanceof VFileContentChangeEvent || event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/tencent/code/intel/apibridge/listener/DiagnosticsAsyncFileListener", "prepareChange"));
    }

    private static class DiagnosticsChangeApplier
    implements AsyncFileListener.ChangeApplier {
        private final Set<VirtualFile> filesToProcess;

        public DiagnosticsChangeApplier(Set<VirtualFile> filesToProcess) {
            this.filesToProcess = filesToProcess;
        }

        public void afterVfsChange() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.processFilesAsync();
                }
                catch (Exception e) {
                    LogManager.warn(DiagnosticsAsyncFileListener.class, "Async diagnostic processing failed: " + e.getMessage());
                }
            });
        }

        private void processFilesAsync() {
            Project[] openProjects;
            for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                if (project.isDisposed()) continue;
                for (VirtualFile file : this.filesToProcess) {
                    try {
                        if (!this.isFileInProject(project, file)) continue;
                        this.processFileDiagnostics(project, file);
                    }
                    catch (Exception e) {
                        LogManager.warn(DiagnosticsAsyncFileListener.class, String.format("Failed to process file diagnostics: project=%s, file=%s, error=%s", project.getName(), file.getPath(), e.getMessage()));
                    }
                }
            }
        }

        private boolean isFileInProject(Project project, VirtualFile file) {
            try {
                return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
                    try {
                        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
            }
            catch (Exception e) {
                return false;
            }
        }

        private void processFileDiagnostics(Project project, VirtualFile file) {
            ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    ExtHostDiagnostics.acceptMarkersChange(project, file);
                }
                catch (Exception e) {
                    LogManager.warn(DiagnosticsAsyncFileListener.class, String.format("Failed to execute diagnostic processing: file=%s, error=%s", file.getPath(), e.getMessage()));
                }
            });
        }
    }
}

