/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.nodeprocess;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.report.FusionTelemetryMeterEvent;
import com.tencent.code.intel.apibridge.report.FusionTelemetryMeterService;
import com.tencent.code.intel.apibridge.report.FusionTelemetrySpanService;
import com.tencent.code.intel.apibridge.report.model.Event;
import com.tencent.code.intel.apibridge.toolwindow.ToolWindowHelper;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class NodeProjectService
implements Disposable,
DumbAware {
    private final Project project;
    private NodeRunner nodeRunner;
    private final String projectId;

    public NodeProjectService(final Project project) {
        this.project = project;
        this.projectId = project.getLocationHash();
        if (this.nodeRunner != null) {
            this.nodeRunner.release();
            this.nodeRunner = null;
        }
        this.nodeRunner = new NodeRunner(project);
        this.nodeRunner.runNode();
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                ThreadManager.getInstance().runUiThread(() -> {
                    ToolWindow toolWindow = ToolWindowHelper.getToolwindow(project);
                    if (toolWindow != null && toolWindow.isVisible() && NodeProjectService.this.nodeRunner != null) {
                        NodeProjectService.this.nodeRunner.ensureWebviewCreated();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/tencent/code/intel/apibridge/nodeprocess/NodeProjectService$1", "stateChanged"));
            }
        });
        this.reportNodeStart();
    }

    public void dispose() {
        if (this.nodeRunner != null) {
            this.nodeRunner.setAllowAutoRestart(false);
            LogManager.info(NodeProjectService.class, "Disposing NodeProjectService, releasing runner with id: " + String.valueOf(this.nodeRunner.getRunnerId()));
            this.nodeRunner.release();
            this.nodeRunner = null;
        }
    }

    private void reportNodeStart() {
        FusionTelemetrySpanService spanService;
        Event event = new Event();
        FusionTelemetryMeterService meterService = FusionTelemetryMeterService.getInstance(this.project);
        if (meterService != null) {
            meterService.report(FusionTelemetryMeterEvent.NODE_EVENT_LOAD_START, event);
        }
        if ((spanService = FusionTelemetrySpanService.getInstance(this.project)) != null) {
            spanService.reportLog("Node start report trace:" + meterService.getTraceId());
        }
    }

    public synchronized void reset() {
        if (this.nodeRunner != null) {
            NodeRunner newRunner;
            this.nodeRunner.setAllowAutoRestart(false);
            UUID oldRunnerId = this.nodeRunner.getRunnerId();
            String currentViewType = this.nodeRunner.getWebviewBrowser().viewType;
            this.nodeRunner.getWebviewBrowser().resetWebview();
            this.nodeRunner.release();
            NodeRunner oldRunner = this.nodeRunner;
            this.nodeRunner = null;
            this.nodeRunner = newRunner = new NodeRunner(this.project);
            if (!currentViewType.isEmpty()) {
                this.nodeRunner.getWebviewBrowser().updateViewType(currentViewType);
            }
            ThreadManager.getInstance().runUiThread(() -> {
                LogManager.info(NodeProjectService.class, String.format("Reset: old runner (id=%s) released, new runner (id=%s) created", oldRunnerId, newRunner.getRunnerId()));
                this.nodeRunner.runNode();
                this.nodeRunner.addRpcReadyCallback(() -> ThreadManager.getInstance().runUiThread(() -> {
                    ToolWindow toolWindow = ToolWindowHelper.getToolwindow(this.project);
                    if (toolWindow != null && toolWindow.isVisible()) {
                        LogManager.info(NodeProjectService.class, "Reset: ensuring webview recreation after RPC ready");
                        this.nodeRunner.ensureWebviewCreated();
                    }
                }));
            });
        } else {
            this.nodeRunner = new NodeRunner(this.project);
            ThreadManager.getInstance().runUiThread(() -> this.nodeRunner.runNode());
        }
    }

    public boolean isNodeRunnerLive() {
        if (this.nodeRunner == null) {
            return false;
        }
        return this.nodeRunner.isNodeProcessAlive();
    }

    public NodeRunner getNodeRunner() {
        return this.nodeRunner;
    }
}

