/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.nodeprocess;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.tencent.code.intel.apibridge.extension.extension.comments.ExtHostComments;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.ExtHostDocuments;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.ExtHostDocumentsAndEditors;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.ExtHostEditorTabs;
import com.tencent.code.intel.apibridge.extension.extension.filesystem.ExtHostFileSystemEventService;
import com.tencent.code.intel.apibridge.extension.extension.healthy.ExtHostHealth;
import com.tencent.code.intel.apibridge.extension.extension.progress.ExtHostProgress;
import com.tencent.code.intel.apibridge.extension.extension.quickopen.ExtHostQuickOpen;
import com.tencent.code.intel.apibridge.extension.extension.textEditors.ExtHostEditors;
import com.tencent.code.intel.apibridge.extension.extension.webview.ExtHostWebviewViews;
import com.tencent.code.intel.apibridge.extension.extension.window.ExtHostWindow;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.TerminalManager;
import com.tencent.code.intel.apibridge.extension.mainthread.webview.WebviewBrowser;
import com.tencent.code.intel.apibridge.listener.DiagnosticsAsyncFileListener;
import com.tencent.code.intel.apibridge.nodeprocess.NodeProjectService;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.apibridge.toolwindow.ToolWindowHelper;
import com.tencent.code.intel.apibridge.util.FusionEnvUtils;
import com.tencent.code.intel.apibridge.util.FusionProductUtils;
import com.tencent.code.intel.bean.BaseBean;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.JsonRpcUtils;
import com.tencent.code.intel.util.PluginUtils;
import com.tencent.code.intel.util.ProcessUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRunner {
    private static final Logger log = LoggerFactory.getLogger(NodeRunner.class);
    private final Project project;
    private int nodeRestartCount = 0;
    private int MAX_RESTART_COUNT = 3;
    private TerminalManager terminalManager;
    private final Queue<Runnable> rpcReadyCallbacks = new ConcurrentLinkedQueue<Runnable>();
    private final Object rpcReadyLock = new Object();
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private volatile boolean stopping = false;
    private volatile boolean allowAutoRestart = true;
    private final UUID runnerId = UUID.randomUUID();
    KillableProcessHandler processHandler;
    private Process nodeProcess;
    private Thread nodeDemon;
    private RPCProtocol rpcChannel;
    private ExtHostDocumentsAndEditors documentsAndEditors;
    private ExtHostDocuments documents;
    private ExtHostEditorTabs editorTabs;
    private ExtHostQuickOpen quickOpen;
    private ExtHostFileSystemEventService fileSystemEventService;
    private WebviewBrowser webviewBrowser;
    public ExtHostComments comments;
    public ExtHostEditors editors;
    public ExtHostHealth health;
    public ExtHostProgress progress;
    private ExtHostWindow window;
    private final StringBuilder buffer = new StringBuilder();

    public static NodeRunner getInstance(Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        NodeProjectService service = (NodeProjectService)project.getService(NodeProjectService.class);
        if (service == null) {
            return null;
        }
        return service.getNodeRunner();
    }

    public NodeRunner(Project project) {
        this.project = project;
        this.rpcChannel = new RPCProtocol(project);
        this.webviewBrowser = new WebviewBrowser(project, this.rpcChannel);
        this.documentsAndEditors = new ExtHostDocumentsAndEditors(this.rpcChannel);
        this.documents = new ExtHostDocuments(this.rpcChannel);
        this.editorTabs = new ExtHostEditorTabs(this.rpcChannel);
        this.quickOpen = new ExtHostQuickOpen(this.rpcChannel);
        this.comments = new ExtHostComments(this.rpcChannel);
        this.fileSystemEventService = new ExtHostFileSystemEventService(this.rpcChannel);
        this.editors = new ExtHostEditors(this.rpcChannel);
        this.health = new ExtHostHealth(this.rpcChannel);
        this.progress = new ExtHostProgress(this.rpcChannel);
        this.window = new ExtHostWindow(this.rpcChannel);
        this.terminalManager = new TerminalManager(project, this);
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new DiagnosticsAsyncFileListener(), (Disposable)project.getMessageBus());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogManager.info(this.getClass(), "NodeRunner release");
            this.release();
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rpcChannelReady() {
        this.rpcChannel.setRpcReady(true);
        LogManager.info(NodeRunner.class, "RPC channel ready, runnerId: " + String.valueOf(this.runnerId));
        this.ensureWebviewCreated();
        Object object = this.rpcReadyLock;
        synchronized (object) {
            while (true) {
                if (this.rpcReadyCallbacks.isEmpty()) {
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 5] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                    ThreadManager.getInstance().runUiThread(() -> {
                        VirtualFile[] selectedFiles;
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
                        for (VirtualFile currentFile : selectedFiles = fileEditorManager.getSelectedFiles()) {
                            FileEditor currentEditor = fileEditorManager.getSelectedEditor(currentFile);
                            Document currentDocument = FileDocumentManager.getInstance().getDocument(currentFile);
                            this.documentsAndEditors.forceUpdateEditorAndDocument(this.project, currentEditor, currentDocument, currentFile);
                        }
                        this.editorTabs.initializeEditorTabs(this.project);
                        this.terminalManager.initialize();
                    });
                    return;
                }
                Runnable callback = this.rpcReadyCallbacks.poll();
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (Exception e) {
                    LogManager.warn(NodeRunner.class, "Error executing RPC ready callback: " + e.getMessage());
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRpcReadyCallback(Runnable callback) {
        Object object = this.rpcReadyLock;
        synchronized (object) {
            if (this.isReady()) {
                callback.run();
            } else {
                this.rpcReadyCallbacks.offer(callback);
            }
        }
    }

    public boolean isReady() {
        return this.rpcChannel.isRpcReady();
    }

    public void ensureWebviewCreated() {
        if (!this.rpcChannel.isRpcReady()) {
            return;
        }
        ThreadManager.getInstance().runUiThread(() -> {
            ToolWindow toolWindow = ToolWindowHelper.getToolwindow(this.project);
            if (toolWindow != null && toolWindow.getContentManager().getContentCount() == 0) {
                if (!this.webviewBrowser.viewType.isEmpty()) {
                    LogManager.info(NodeRunner.class, "Creating webview for viewType: " + this.webviewBrowser.viewType);
                    ExtHostWebviewViews.onCreateWebview(this.webviewBrowser.viewType, this.rpcChannel);
                } else {
                    LogManager.warn(NodeRunner.class, "Cannot create webview: viewType is empty");
                }
            }
        });
    }

    public void sendMessage(String method, Object message, String id) {
        JSONObject jsonObject = JSONObject.from((Object)message);
        String jsonRequest = String.format("{\"jsonrpc\":\"2.0\", \"id\":\"%s\", \"method\":\"%s\", \"payload\":\"%s\"}\n", id, method, Base64.getEncoder().encodeToString(jsonObject.toString().getBytes(StandardCharsets.UTF_8)));
        ThreadManager.getInstance().executeLspWrite(() -> {
            try {
                ProcessUtils.write(this.nodeProcess, jsonRequest.getBytes());
            }
            catch (IOException e) {
                LogManager.warn(NodeRunner.class, "send failed");
            }
        });
    }

    public static String getLocale() {
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals("zh") || locale.getCountry().equals("CN")) {
            return "zh-cn";
        }
        if (locale.getLanguage().equals("TW")) {
            return "zh-tw";
        }
        return "en";
    }

    private String getFusionExePath() {
        String os = SystemInfo.OS_NAME.toLowerCase(Locale.ROOT);
        String arch = SystemInfo.OS_ARCH.toLowerCase(Locale.ROOT);
        LogManager.info(this.getClass(), "check system os and arch: " + os + "/" + arch);
        String fusionExePath = null;
        if (os.contains("windows") && arch.contains("64")) {
            fusionExePath = "bin/fusion-win-x64.exe";
        } else if (os.contains("linux") && arch.contains("aarch64")) {
            fusionExePath = "bin/fusion-linux-arm64";
        } else if (os.contains("linux") && arch.contains("64")) {
            fusionExePath = "bin/fusion-linux-x64";
        } else if (os.contains("mac") && arch.contains("x86_64")) {
            fusionExePath = "bin/fusion-macos-x64";
        } else if (os.contains("mac") && arch.contains("aarch64")) {
            fusionExePath = "bin/fusion-macos-arm64";
        }
        return fusionExePath;
    }

    private String getVsixAppRoot() {
        String os = SystemInfo.OS_NAME.toLowerCase(Locale.ROOT);
        String arch = SystemInfo.OS_ARCH.toLowerCase(Locale.ROOT);
        String vsixAppRoot = "";
        if (os.contains("windows")) {
            vsixAppRoot = "devtools/win/x64";
        } else if (os.contains("linux") && arch.contains("aarch64")) {
            vsixAppRoot = "devtools/linux/arm64";
        } else if (os.contains("linux") && arch.contains("64")) {
            vsixAppRoot = "devtools/linux/x64";
        } else if (os.contains("mac") && arch.contains("x86_64")) {
            vsixAppRoot = "devtools/macos/x64";
        } else if (os.contains("mac") && arch.contains("aarch64")) {
            vsixAppRoot = "devtools/macos/arm64";
        }
        return vsixAppRoot;
    }

    private void addExecutablePermission(String path) {
        String os = SystemInfo.OS_NAME.toLowerCase(Locale.ROOT);
        if (!os.contains("windows")) {
            try {
                ProcessUtils.execute("/", 5000L, "chmod", "+x", path);
            }
            catch (Exception e) {
                LogManager.warn(NodeRunner.class, "fail to chmod executable path: " + String.valueOf(e));
                ProcessUtils.executeChmod(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNode() {
        if (this.stopping) {
            LogManager.info(NodeRunner.class, "Node runner is stopping, skip runNode() with runnerId: " + String.valueOf(this.runnerId));
            return;
        }
        if (!this.starting.compareAndSet(false, true)) {
            LogManager.info(NodeRunner.class, "Node runner is already starting, skip runNode() with runnerId: " + String.valueOf(this.runnerId));
            return;
        }
        try {
            GeneralCommandLine commandLine;
            String jsPath;
            this.allowAutoRestart = false;
            if (this.nodeProcess != null && this.nodeProcess.isAlive()) {
                LogManager.info(NodeRunner.class, "Node process is already running with runnerId: " + String.valueOf(this.runnerId));
                return;
            }
            this.release();
            this.stopping = false;
            if (this.nodeRestartCount >= this.MAX_RESTART_COUNT) {
                LogManager.warn(NodeRunner.class, "Reached max restart count: " + this.MAX_RESTART_COUNT);
                return;
            }
            Path pluginPath = PluginUtils.path();
            if (pluginPath == null) {
                LogManager.warn(this.getClass(), "fail to get plugin install path");
                return;
            }
            ArrayList<String> cmdList = new ArrayList<String>();
            if (PluginUtils.isDebug()) {
                cmdList.add("node");
                cmdList.add("--inspect-brk=9227");
                jsPath = Path.of(pluginPath.toString(), "/../../../../../fusion/dist/rpc-bridge/extHostProcess.js").toString();
                cmdList.add(jsPath);
                commandLine = new GeneralCommandLine(cmdList);
            } else {
                String fusionExePath = this.getFusionExePath();
                if (fusionExePath == null) {
                    LogManager.warn(this.getClass(), "fail to get fusion executable path");
                    return;
                }
                String fullExePath = pluginPath.toAbsolutePath().resolve(fusionExePath).toString();
                this.addExecutablePermission(fullExePath);
                commandLine = new GeneralCommandLine(new String[]{fullExePath});
                jsPath = pluginPath.toAbsolutePath().resolve("vsix/extension/server.js").toString();
            }
            Map<String, String> params = this.getParams(pluginPath, jsPath);
            params.forEach((k, v) -> commandLine.getParametersList().add(k, v));
            Map<String, String> envs = this.getEnvs();
            envs.forEach((k, v) -> commandLine.getEnvironment().put(k, v));
            LogManager.info(NodeRunner.class, String.format("start Node Process, project %s, hash: %s", this.project.getBasePath(), this.project.getLocationHash()));
            Process process = null;
            try {
                process = commandLine.createProcess();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            this.processHandler = new KillableProcessHandler(process, commandLine.getCommandLineString(), StandardCharsets.UTF_8){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    return new AgentOutputReaderOptions();
                }
            };
            this.nodeProcess = this.processHandler.getProcess();
            if (this.processHandler == null) {
                LogManager.warn(NodeRunner.class, "processHandler is null");
            }
            Integer x = this.processHandler.getExitCode();
            final RPCProtocol rpcChannel = this.rpcChannel;
            this.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.processWillTerminate(event, willBeDestroyed);
                    LogManager.warn(NodeRunner.class, "fusion server exit with code: " + event.getExitCode() + " text:" + event.getText() + " detail:" + event.toString());
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    boolean abnormalExit;
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    super.processTerminated(event);
                    LogManager.warn(NodeRunner.class, "fusion server exit with code: " + event.getExitCode() + " text:" + event.getText() + " detail:" + event.toString() + ", runnerId: " + String.valueOf(NodeRunner.this.runnerId));
                    int code = event.getExitCode();
                    boolean bl = abnormalExit = code != 0 && code != 143;
                    if (abnormalExit) {
                        if (NodeRunner.this.allowAutoRestart && !NodeRunner.this.stopping) {
                            LogManager.info(NodeRunner.class, "Abnormal exit. Scheduling auto-restart in 5 seconds, runnerId: " + String.valueOf(NodeRunner.this.runnerId));
                            ThreadManager.getInstance().executeDelay(5000, () -> {
                                if (NodeRunner.this.allowAutoRestart && !NodeRunner.this.stopping) {
                                    LogManager.info(NodeRunner.class, "Auto-restarting node process, runnerId: " + String.valueOf(NodeRunner.this.runnerId));
                                    NodeRunner.this.runNode();
                                } else {
                                    LogManager.info(NodeRunner.class, "Auto-restart cancelled (allowAutoRestart=" + NodeRunner.this.allowAutoRestart + ", stopping=" + NodeRunner.this.stopping + "), runnerId: " + String.valueOf(NodeRunner.this.runnerId));
                                }
                                return null;
                            });
                        } else {
                            LogManager.info(NodeRunner.class, "Auto-restart disabled (allowAutoRestart=" + NodeRunner.this.allowAutoRestart + ", stopping=" + NodeRunner.this.stopping + "), runnerId: " + String.valueOf(NodeRunner.this.runnerId));
                        }
                    } else {
                        LogManager.info(NodeRunner.class, "Normal/expected exit (code=" + code + "). Skip auto-restart, runnerId: " + String.valueOf(NodeRunner.this.runnerId));
                    }
                }

                private void handleJsonLine(String line) {
                    try {
                        if (!line.startsWith("{")) {
                            NodeRunner.this.handleLogLine(line);
                            return;
                        }
                        Buffer msg = JsonRpcUtils.parseObject(line, Buffer.class);
                        switch (msg.method) {
                            case "rpc-protocol": {
                                rpcChannel.handleMessage(msg.getDecodedPayload());
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    super.onTextAvailable(event, outputType);
                    ThreadManager.getInstance().dispatchOnRPCExecutor(() -> {
                        int newlineIndex;
                        String text = event.getText();
                        NodeRunner.this.buffer.append(text);
                        while ((newlineIndex = NodeRunner.this.buffer.indexOf("\n")) != -1) {
                            String line = NodeRunner.this.buffer.substring(0, newlineIndex).trim();
                            if (newlineIndex + 1 <= NodeRunner.this.buffer.length()) {
                                NodeRunner.this.buffer.delete(0, newlineIndex + 1);
                            } else {
                                NodeRunner.this.buffer.setLength(0);
                            }
                            if (line.isEmpty()) continue;
                            this.handleJsonLine(line);
                        }
                    });
                }

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    super.startNotified(event);
                    LogManager.warn(NodeRunner.class, "start fusion server message consumer thread");
                    ThreadManager.getInstance().executeDelay(1000, () -> {
                        NodeRunner.this.runNodeDemon(NodeRunner.this.nodeProcess);
                        return null;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/tencent/code/intel/apibridge/nodeprocess/NodeRunner$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ThreadManager.getInstance().executeDelay(1000, () -> {
                try {
                    if (!this.processHandler.isStartNotified()) {
                        this.processHandler.startNotify();
                    }
                }
                catch (Exception e) {
                    LogManager.info(NodeRunner.class, "processHandler.startNotify called already, failed: " + String.valueOf(e));
                }
                return null;
            });
            ThreadManager.getInstance().executeDelay(2000, () -> {
                if (this.processHandler.isProcessTerminated()) {
                    Integer exitCode = this.processHandler.getExitCode();
                    String exitInfo = "\u8fdb\u7a0b\u5df2\u9000\u51fa\uff0c\u4ee3\u7801: " + exitCode;
                    if (exitCode != null && exitCode == 0) {
                        LogManager.info(NodeRunner.class, exitInfo);
                    } else {
                        LogManager.error(NodeRunner.class, exitInfo);
                    }
                }
                try {
                    if (!this.processHandler.isStartNotified()) {
                        LogManager.info(NodeRunner.class, "processHandler.startNotify called already, failed: ");
                    }
                }
                catch (Exception e) {
                    LogManager.info(NodeRunner.class, "processHandler.startNotify called already, failed: " + String.valueOf(e));
                }
                return null;
            });
            ++this.nodeRestartCount;
        }
        finally {
            this.starting.set(false);
        }
    }

    private Map<String, String> getParams(Path pluginPath, String jsPath) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("--logPath", PathManager.getLogPath());
        params.put("--logName", this.project.getLocationHash());
        params.put("--logLevel", "2");
        params.put("--locale", NodeRunner.getLocale());
        if (!PluginUtils.isDebug()) {
            params.put("--file", jsPath);
        }
        String appRoot = pluginPath.toAbsolutePath().resolve(this.getVsixAppRoot()).toString();
        params.put("--appRoot", appRoot);
        return params;
    }

    private Map<String, String> getEnvs() {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("NODE_SKIP_PLATFORM_CHECK", "1");
        if (PluginUtils.isDebug()) {
            envs.put("NODE_PATH", PluginUtils.path().resolve("../../../../../fusion/dist/").toString());
        }
        envs.put("ACC_PRODUCT_CONFIG", FusionEnvUtils.PRODUCT_ENV_JSON);
        envs.put("CLIENT_INFO_PLATFORM", FusionProductUtils.PRODUCT_NAMES.getOrDefault(ApplicationInfo.getInstance().getVersionName(), "UnknownJetBrainsProduct"));
        envs.put("CLIENT_INFO_PLATFORM_VERSION", ApplicationInfo.getInstance().getApiVersion());
        envs.put("CLIENT_INFO_PLUGIN_VERSION", PluginUtils.getPluginVersion());
        return envs;
    }

    private void handleLogLine(String line) {
        String level;
        List<String> logLines = List.of(line.split(" "));
        if (logLines.size() <= 2) {
            return;
        }
        switch (level = logLines.get(2).toLowerCase()) {
            case "[debug]": {
                break;
            }
            case "[info]": {
                LogManager.debug(NodeRunner.class, line);
                break;
            }
            case "[warn]": {
                LogManager.warn(NodeRunner.class, line);
                break;
            }
            case "[error]": 
            case "[critical]": 
            case "[fatal]": {
                LogManager.error(NodeRunner.class, line);
            }
        }
    }

    public void release() {
        try {
            this.stopping = true;
            if (this.nodeDemon != null) {
                this.nodeDemon.interrupt();
                this.nodeDemon = null;
            }
            if (this.nodeProcess != null && this.nodeProcess.isAlive()) {
                LogManager.info(NodeRunner.class, "Destroying node process with runnerId: " + String.valueOf(this.runnerId));
                this.nodeProcess.destroy();
                if (!this.nodeProcess.waitFor(2L, TimeUnit.SECONDS)) {
                    LogManager.warn(NodeRunner.class, "Node process did not terminate, forcing termination...");
                    this.nodeProcess.destroyForcibly();
                }
                this.nodeProcess = null;
            }
            if (this.processHandler != null) {
                this.processHandler.destroyProcess();
                this.processHandler = null;
            }
        }
        catch (Exception e) {
            LogManager.error(NodeRunner.class, "release failed: " + String.valueOf(e));
        }
    }

    public void updateFocusEditorAndDocument(FileEditor fileEditor, Document document, VirtualFile file, Project project, VirtualFile oldFile) {
        FileEditor[] oldEditors;
        FileEditor oldEditor = null;
        Document oldDocument = null;
        if (oldFile != null && (oldEditor = (FileEditor)Arrays.stream(oldEditors = FileEditorManager.getInstance((Project)project).getEditors(oldFile)).filter(editor -> editor instanceof TextEditor).findFirst().orElse(null)) != null) {
            oldDocument = FileDocumentManager.getInstance().getDocument(oldFile);
        }
        this.documentsAndEditors.updateFocusedDocument(document, project, oldDocument);
        this.documentsAndEditors.updateEditor(fileEditor, file, project, oldEditor, oldFile);
    }

    private void runNodeDemon(Process nodeProcess) {
        if (this.nodeDemon != null) {
            this.nodeDemon.interrupt();
            this.nodeDemon = null;
        }
        this.nodeDemon = new Thread(() -> {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    boolean inGrace;
                    long startTs;
                    Thread.sleep(10000L);
                    if (!this.allowAutoRestart || this.stopping) {
                        LogManager.info(NodeRunner.class, "Node demon stopping due to flags (allowAutoRestart=" + this.allowAutoRestart + ", stopping=" + this.stopping + "), runnerId: " + String.valueOf(this.runnerId));
                        break;
                    }
                    if (this.sendHeartbeat()) continue;
                    long now = System.currentTimeMillis();
                    try {
                        startTs = Long.parseLong(Thread.currentThread().getName());
                    }
                    catch (Exception ignore) {
                        startTs = 0L;
                    }
                    boolean bl = inGrace = startTs > 0L && now - startTs < 30000L;
                    if (!this.validNodeProcess(nodeProcess)) {
                        if (inGrace) {
                            LogManager.info(NodeRunner.class, "Process not alive but in grace period, skip restart. runnerId: " + String.valueOf(this.runnerId));
                            continue;
                        }
                        LogManager.warn(NodeRunner.class, "nodeProcess is dead and heartbeat failed, restarting... runnerId: " + String.valueOf(this.runnerId));
                        if (this.allowAutoRestart && !this.stopping) {
                            this.runNode();
                        } else {
                            LogManager.info(NodeRunner.class, "Auto-restart cancelled in demon (allowAutoRestart=" + this.allowAutoRestart + ", stopping=" + this.stopping + "), runnerId: " + String.valueOf(this.runnerId));
                        }
                        break;
                    }
                    LogManager.info(NodeRunner.class, "Process alive but heartbeat failed; will retry later. runnerId: " + String.valueOf(this.runnerId));
                }
            }
            catch (InterruptedException e) {
                LogManager.info(NodeRunner.class, "Monitoring thread interrupted and stopped.");
            }
            finally {
                if (this.nodeDemon == Thread.currentThread()) {
                    this.nodeDemon = null;
                }
            }
        });
        this.nodeDemon.setDaemon(true);
        this.nodeDemon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendHeartbeat() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(() -> {
            try {
                this.health.checkHealth();
                return true;
            }
            catch (Exception e) {
                LogManager.info(NodeRunner.class, "Error during health check:" + String.valueOf(e));
                return false;
            }
        });
        try {
            Boolean result = future.get(3L, TimeUnit.SECONDS);
            if (Boolean.TRUE.equals(result)) {
                boolean bl = true;
                return bl;
            }
            LogManager.info(NodeRunner.class, "RPC heartbeat failed: service unhealthy");
            boolean bl = false;
            return bl;
        }
        catch (TimeoutException e) {
            LogManager.info(NodeRunner.class, "RPC heartbeat timeout: " + String.valueOf(e));
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LogManager.info(NodeRunner.class, "Unexpected error during heartbeat: " + String.valueOf(e));
            boolean bl = false;
            return bl;
        }
        finally {
            future.cancel(true);
            executor.shutdownNow();
        }
    }

    private boolean validNodeProcess(Process nodeProcess) {
        return nodeProcess != null && nodeProcess.isAlive();
    }

    public boolean isNodeProcessAlive() {
        return this.nodeProcess != null && this.nodeProcess.isAlive();
    }

    public boolean isAllowAutoRestart() {
        return this.allowAutoRestart;
    }

    public void setAllowAutoRestart(boolean allowAutoRestart) {
        this.allowAutoRestart = allowAutoRestart;
    }

    public UUID getRunnerId() {
        return this.runnerId;
    }

    public RPCProtocol getRpcChannel() {
        return this.rpcChannel;
    }

    public ExtHostDocumentsAndEditors getDocumentsAndEditors() {
        return this.documentsAndEditors;
    }

    public ExtHostDocuments getDocuments() {
        return this.documents;
    }

    public ExtHostEditorTabs getEditorTabs() {
        return this.editorTabs;
    }

    public ExtHostQuickOpen getQuickOpen() {
        return this.quickOpen;
    }

    public ExtHostFileSystemEventService getFileSystemEventService() {
        return this.fileSystemEventService;
    }

    public WebviewBrowser getWebviewBrowser() {
        return this.webviewBrowser;
    }

    public ExtHostComments getComments() {
        return this.comments;
    }

    public ExtHostEditors getEditors() {
        return this.editors;
    }

    public ExtHostHealth getHealth() {
        return this.health;
    }

    public ExtHostProgress getProgress() {
        return this.progress;
    }

    public ExtHostWindow getWindow() {
        return this.window;
    }

    public static class AgentOutputReaderOptions
    extends BaseOutputReader.Options {
        public BaseDataReader.SleepingPolicy policy() {
            return BaseDataReader.SleepingPolicy.BLOCKING;
        }

        public boolean splitToLines() {
            return false;
        }
    }

    public static class Buffer
    extends BaseBean {
        private String id;
        private String method;
        private String payload = "";

        public String getDecodedPayload() {
            return new String(Base64.getDecoder().decode(this.payload), StandardCharsets.UTF_8);
        }

        public String getId() {
            return this.id;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPayload() {
            return this.payload;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public String toString() {
            return "NodeRunner.Buffer(id=" + this.getId() + ", method=" + this.getMethod() + ", payload=" + this.getPayload() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Buffer)) {
                return false;
            }
            Buffer other = (Buffer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$payload = this.getPayload();
            String other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Buffer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }
    }
}

