/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.report;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.report.FusionTelemetrySpanService;
import com.tencent.code.intel.apibridge.report.model.Event;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.PluginUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FusionTelemetryMeterService {
    private final Project project;
    private final String reportUrl;
    private final String traceId;
    private final String extVersion;
    private final String ideVersion;
    private final String ideName;
    private final String osName;
    private final List<Event> eventList = Collections.synchronizedList(new ArrayList());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static FusionTelemetryMeterService getInstance(Project project) {
        return (FusionTelemetryMeterService)project.getService(FusionTelemetryMeterService.class);
    }

    public FusionTelemetryMeterService(Project project) {
        this.project = project;
        if (project.getBasePath() == null) {
            LogManager.warn(FusionTelemetryMeterService.class, "project.getBasePath() is null");
            this.traceId = UUID.randomUUID().toString();
        } else {
            this.traceId = String.format("%s_%s", project.getBasePath().hashCode(), UUID.randomUUID());
        }
        this.reportUrl = "https://copilot.tencent.com/v2/report";
        this.scheduler.scheduleAtFixedRate(this::flushBatch, 2L, 2L, TimeUnit.SECONDS);
        this.extVersion = PluginUtils.version();
        this.ideVersion = ApplicationInfo.getInstance().getFullVersion();
        this.ideName = ApplicationInfo.getInstance().getVersionName();
        this.osName = System.getProperty("os.name");
    }

    public void report(String eventName, Event event) {
        this.report(eventName, event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String eventName, Event event, boolean batch) {
        if (this.reportUrl == null || this.reportUrl.isEmpty()) {
            LogManager.warn(FusionTelemetryMeterService.class, "reportUrl is null");
            return;
        }
        event.setTimestamp(System.currentTimeMillis());
        event.setTraceId(this.traceId);
        event.setIdeName(this.ideName);
        event.setIdeVersion(this.ideVersion);
        event.setExtVersion(this.extVersion);
        event.setOsName(this.osName);
        event.setEventCode(eventName);
        this.reportMeterLog(event);
        List<Event> list = this.eventList;
        synchronized (list) {
            this.eventList.add(event);
        }
        if (!batch) {
            this.flushBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBatch() {
        ArrayList<Event> sendList;
        List<Event> list = this.eventList;
        synchronized (list) {
            if (this.eventList.isEmpty()) {
                return;
            }
            sendList = new ArrayList<Event>(this.eventList);
            this.eventList.clear();
        }
        this.send(sendList);
    }

    private void send(List<Event> events) {
        if (this.reportUrl == null || this.reportUrl.isEmpty()) {
            LogManager.warn(FusionTelemetryMeterService.class, "reportUrl is null");
            return;
        }
        String json = JSONObject.toJSONString(events, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        try {
            URL url = new URL(this.reportUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setDoOutput(true);
            connection.getOutputStream().write(json.getBytes(StandardCharsets.UTF_8));
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
            int code = connection.getResponseCode();
            InputStream is = code >= 200 && code < 400 ? connection.getInputStream() : connection.getErrorStream();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line.trim());
                }
                LogManager.info(FusionTelemetryMeterService.class, "report send response:" + String.valueOf(response));
            }
            connection.disconnect();
        }
        catch (Exception e) {
            LogManager.warn(FusionTelemetryMeterService.class, "send report event fail:" + String.valueOf(e));
        }
    }

    private void reportMeterLog(Event event) {
        String message = event.toString();
        FusionTelemetrySpanService spanService = FusionTelemetrySpanService.getInstance(this.project);
        if (spanService != null) {
            spanService.reportLog("report meter event: " + message);
        }
    }

    public String getTraceId() {
        return this.traceId;
    }
}

