/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.report;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.tencent.code.intel.bean.product.Telemetry;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.telemetry.CustomTracer;
import com.tencent.code.intel.util.PluginUtils;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class FusionTelemetrySpanService {
    private CustomTracer tracer;
    private Project project;
    private Span rootSpan;

    public static FusionTelemetrySpanService getInstance(Project project) {
        return (FusionTelemetrySpanService)project.getService(FusionTelemetrySpanService.class);
    }

    public FusionTelemetrySpanService(Project project) {
        this.project = project;
        this.initClient();
    }

    public void initClient() {
        try {
            Telemetry traceTelemetryConfig = new Telemetry();
            traceTelemetryConfig.setType("trace-open-telemetry");
            traceTelemetryConfig.setName("codebuddy-client-" + PluginUtils.getPluginVersion());
            traceTelemetryConfig.setUrl("https://copilot.tencent.com/v1/traces");
            this.tracer = CustomTracer.create(this.createTelemetryTracer(traceTelemetryConfig));
            this.rootSpan = this.createRootSpan("Project Root Span");
            ProjectManager.getInstance().addProjectManagerListener(this.project, new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.projectClosing(project);
                    FusionTelemetrySpanService.this.close();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/tencent/code/intel/apibridge/report/FusionTelemetrySpanService$1", "projectClosing"));
                }
            });
        }
        catch (Exception e) {
            LogManager.warn(FusionTelemetrySpanService.class, "init telemetry client failed, " + String.valueOf(e));
        }
    }

    private void close() {
        this.endSpan(this.rootSpan);
        this.rootSpan = null;
    }

    private Tracer createTelemetryTracer(Telemetry config) {
        try {
            OtlpHttpSpanExporterBuilder otlpHttpSpanExporterBuilder = OtlpHttpSpanExporter.builder();
            String traceUrl = config.getUrl();
            if (TextUtils.isEmpty((CharSequence)traceUrl)) {
                return null;
            }
            OtlpHttpSpanExporter exporter = otlpHttpSpanExporterBuilder.setEndpoint(traceUrl).build();
            AttributesBuilder builder = Attributes.builder();
            builder.put("service.name", config.getName());
            builder.put("service.version", "1.0.0");
            String trackerName = null;
            if (config.getAttributes() != null) {
                if (!TextUtils.isBlank((CharSequence)config.getAttributes().getTpsTenantId())) {
                    builder.put("tps.tenant.id", config.getAttributes().getTpsTenantId());
                }
                trackerName = config.getAttributes().getTracerName();
            }
            SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)exporter)).setResource(Resource.create((Attributes)builder.build())).build();
            OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).buildAndRegisterGlobal();
            if (TextUtils.isBlank((CharSequence)trackerName)) {
                trackerName = FusionTelemetrySpanService.class.getName();
            }
            return openTelemetrySdk.getTracer(trackerName);
        }
        catch (Exception e) {
            LogManager.warn(FusionTelemetrySpanService.class, "create trace telemetry client failed, " + String.valueOf(e));
            return null;
        }
    }

    public void reportLog(String message) {
        try {
            Span span = this.createSpan(message, this.rootSpan);
            this.endSpan(span);
            LogManager.info(FusionTelemetrySpanService.class, "report span message: " + message);
        }
        catch (Exception e) {
            LogManager.warn(FusionTelemetrySpanService.class, "report telemetry log failed, e: " + String.valueOf(e));
        }
    }

    public Span createSpan(String spanName, Span pSpan) {
        Span span = null;
        try {
            if (this.tracer == null) {
                return null;
            }
            span = this.tracer.spanBuilder(spanName, pSpan).startSpan();
        }
        catch (Exception e) {
            LogManager.warn(FusionTelemetrySpanService.class, "create span " + spanName + " failed, e: " + String.valueOf(e));
        }
        return span;
    }

    public Span createRootSpan(String name) {
        Span span = null;
        try {
            if (this.tracer == null) {
                return null;
            }
            if (this.rootSpan != null) {
                span = this.tracer.spanBuilder(name, this.rootSpan).startSpan();
                LogManager.info(FusionTelemetrySpanService.class, "create root span with project root:" + this.rootSpan.getSpanContext().getTraceId());
            } else {
                span = this.tracer.spanBuilder(name).startSpan();
            }
            LogManager.info(FusionTelemetrySpanService.class, "start root span , trace id : " + span.getSpanContext().getTraceId());
            return span;
        }
        catch (Exception e) {
            LogManager.warn(FusionTelemetrySpanService.class, "create telemetry " + name + " failed, e: " + String.valueOf(e));
            return span;
        }
    }

    public void endSpan(Span span) {
        try {
            if (span != null) {
                span.end();
            }
        }
        catch (Exception e) {
            LogManager.warn(FusionTelemetrySpanService.class, "end span failed, e: " + String.valueOf(e));
        }
    }
}

