/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.rpcprotocol;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.clipboard.MainThreadClipboard;
import com.tencent.code.intel.apibridge.extension.mainthread.command.MainThreadCommandImplementService;
import com.tencent.code.intel.apibridge.extension.mainthread.command.MainThreadCommands;
import com.tencent.code.intel.apibridge.extension.mainthread.comments.MainThreadComments;
import com.tencent.code.intel.apibridge.extension.mainthread.configuration.MainThreadConfiguration;
import com.tencent.code.intel.apibridge.extension.mainthread.context.MainThreadContext;
import com.tencent.code.intel.apibridge.extension.mainthread.dialogs.MainThreadDialogs;
import com.tencent.code.intel.apibridge.extension.mainthread.documents.MainThreadDocumentsService;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.MainThreadBulkEditsService;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.MainThreadEditorsService;
import com.tencent.code.intel.apibridge.extension.mainthread.editortabs.MainThreadEditorTabsService;
import com.tencent.code.intel.apibridge.extension.mainthread.explorer.MainThreadExplorerMenusService;
import com.tencent.code.intel.apibridge.extension.mainthread.extensions.MainThreadVscodeGitService;
import com.tencent.code.intel.apibridge.extension.mainthread.filesystem.MainThreadFileSystem;
import com.tencent.code.intel.apibridge.extension.mainthread.keybinding.KeyBindingService;
import com.tencent.code.intel.apibridge.extension.mainthread.languagefeature.MainThreadLanguageFeaturesService;
import com.tencent.code.intel.apibridge.extension.mainthread.lifecycle.MainThreadLifeCycle;
import com.tencent.code.intel.apibridge.extension.mainthread.log.MainThreadLogService;
import com.tencent.code.intel.apibridge.extension.mainthread.message.MainThreadMessageService;
import com.tencent.code.intel.apibridge.extension.mainthread.progress.MainThreadProgress;
import com.tencent.code.intel.apibridge.extension.mainthread.quickopen.MainThreadQuickOpen;
import com.tencent.code.intel.apibridge.extension.mainthread.scm.MainThreadSCM;
import com.tencent.code.intel.apibridge.extension.mainthread.secretstate.MainThreadSecretState;
import com.tencent.code.intel.apibridge.extension.mainthread.statusbar.MainThreadStatusBar;
import com.tencent.code.intel.apibridge.extension.mainthread.storage.MainThreadStorageService;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.MainThreadTerminalService;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.MainThreadTerminalShellIntegration;
import com.tencent.code.intel.apibridge.extension.mainthread.toolwindow.MainThreadToolWindow;
import com.tencent.code.intel.apibridge.extension.mainthread.webview.MainThreadWebviewsViewsService;
import com.tencent.code.intel.apibridge.extension.mainthread.webview.WebviewService;
import com.tencent.code.intel.apibridge.extension.mainthread.window.MainThreadWindow;
import com.tencent.code.intel.apibridge.extension.mainthread.workspace.MainThreadWorkspace;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocolData;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocolReq;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocolRsp;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.JsonRpcUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class RPCProtocol {
    public static final String method = "rpc-protocol";
    private final Hashtable<String, Consumer<JSONObject>> pendingReqMap = new Hashtable();
    private final HashMap<Integer, String> localRpcServices = new HashMap();
    private final HashMap<String, Integer> remoteRpcServices = new HashMap();
    private final MainThreadBaseProxy[] handlers;
    public Project project;
    private boolean rpcReady = false;
    private int reqId = 0;

    int reqIdGenerator() {
        return this.reqId++;
    }

    public RPCProtocol(Project project) {
        this.project = project;
        this.handlers = new MainThreadBaseProxy[]{new MainThreadContext(), new MainThreadSecretState(), new MainThreadWindow(), new WebviewService(), new MainThreadDocumentsService(), new MainThreadEditorsService(), new MainThreadBulkEditsService(), new MainThreadWorkspace(), new KeyBindingService(), new MainThreadFileSystem(), new MainThreadTerminalService(), new MainThreadTerminalShellIntegration(), new MainThreadLifeCycle(), new MainThreadConfiguration(), new MainThreadStorageService(), new MainThreadMessageService(), new MainThreadStatusBar(), new MainThreadLanguageFeaturesService(), new MainThreadWebviewsViewsService(), new MainThreadQuickOpen(), new MainThreadEditorTabsService(), new MainThreadCommandImplementService(), new MainThreadVscodeGitService(), new MainThreadCommands(), new MainThreadComments(), new MainThreadClipboard(), new MainThreadExplorerMenusService(), new MainThreadLogService(), new MainThreadSCM(), new MainThreadToolWindow(), new MainThreadDialogs(), new MainThreadProgress()};
    }

    public void configRPCMap(Object main, Object ext) {
        JSONObject mainContext = JSONObject.from((Object)main);
        JSONObject extContext = JSONObject.from((Object)ext);
        mainContext.values().forEach(obj -> {
            if (obj instanceof JSONObject) {
                JSONObject jsonObj = JSONObject.from((Object)obj);
                this.localRpcServices.put(jsonObj.getInteger("nid"), jsonObj.getString("sid"));
            }
        });
        extContext.values().forEach(obj -> {
            if (obj instanceof JSONObject) {
                JSONObject jsonObj = JSONObject.from((Object)obj);
                this.remoteRpcServices.put(jsonObj.getString("sid"), jsonObj.getInteger("nid"));
            }
        });
    }

    public void handleMessage(String message) {
        try {
            RPCProtocolData data = JsonRpcUtils.parseObject(message, RPCProtocolData.class);
            switch (data.getType()) {
                case 1: {
                    this.handleRequest(data);
                    break;
                }
                case 2: {
                    this.handleResponse(data);
                }
            }
        }
        catch (Exception e) {
            LogManager.warn(RPCProtocol.class, "handle message error " + e.toString());
        }
    }

    private void handleRequest(RPCProtocolData data) {
        if (!(data instanceof RPCProtocolReq)) {
            return;
        }
        RPCProtocolReq req = (RPCProtocolReq)data;
        if (req.getName().equals("$onRPCReady")) {
            Arrays.stream(this.handlers).filter(handler -> handler instanceof MainThreadLifeCycle).findFirst().ifPresent(handler -> handler.handleReq(this.project, req.getName(), req.getArgs(), object -> this.sendRsp(req.getRpcId(), req.getCallId(), object)));
            return;
        }
        String rpcService = this.localRpcServices.get(req.getRpcId());
        if (rpcService == null) {
            LogManager.warn(RPCProtocol.class, "rpc service not found");
            return;
        }
        Arrays.stream(this.handlers).filter(handler -> handler.getMethod().equals(rpcService)).findFirst().ifPresent(handler -> {
            try {
                handler.handleReq(this.project, req.getName(), req.getArgs(), object -> this.sendRsp(req.getRpcId(), req.getCallId(), object));
            }
            catch (Exception e) {
                LogManager.warn(RPCProtocol.class, e.toString());
                this.sendRsp(req.getRpcId(), req.getCallId(), null);
            }
        });
    }

    private void handleResponse(RPCProtocolData data) {
        RPCProtocolRsp rsp = (RPCProtocolRsp)data;
        Consumer<JSONObject> consumer = this.pendingReqMap.get(String.format("%d", rsp.getCallId()));
        if (consumer != null) {
            this.pendingReqMap.remove(String.format("%d", rsp.getCallId()));
            consumer.accept(rsp.getResult() == null ? null : JSONObject.from((Object)rsp.getResult()));
        }
    }

    public void sendReq(String remoteService, String name, List<Object> args, Consumer<JSONObject> consumer) {
        Integer rpcId = this.remoteRpcServices.get(remoteService);
        if (rpcId == null) {
            return;
        }
        RPCProtocolReq req = new RPCProtocolReq();
        req.setRpcId(rpcId);
        req.setName(name);
        req.setCallId(this.reqIdGenerator());
        req.setArgs(args);
        req.setType(1);
        if (NodeRunner.getInstance(this.project) == null) {
            return;
        }
        NodeRunner.getInstance(this.project).sendMessage(method, req, "genie");
        if (consumer != null) {
            this.pendingReqMap.put(String.format("%d", req.getCallId()), consumer);
        }
    }

    public void sendRsp(Integer rpcId, Integer callId, Object result) {
        RPCProtocolRsp rsp = new RPCProtocolRsp();
        rsp.setRpcId(rpcId);
        rsp.setCallId(callId);
        rsp.setResult(result);
        rsp.setType(2);
        NodeRunner.getInstance(this.project).sendMessage(method, rsp, "genie");
    }

    @Nullable
    public MainThreadBaseProxy getService(String serviceName) {
        return Arrays.stream(this.handlers).filter(handler -> handler.getClass().getSimpleName().equals(serviceName)).findFirst().orElse(null);
    }

    public void setRpcReady(boolean rpcReady) {
        this.rpcReady = rpcReady;
    }

    public boolean isRpcReady() {
        return this.rpcReady;
    }
}

