/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.toolwindow;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.tencent.code.intel.apibridge.extension.mainthread.webview.ui.ButtonBuilder;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.PluginUtils;
import com.tencent.code.intel.util.URLUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;

public class ToolWindowHelper
implements ToolWindowFactory,
DumbAware {
    public static final String TOOL_WINDOW_ID = "com.tencent.code.intel.extension.WebviewBrowser";

    public static void openWindow(Project project, boolean showWindow) {
        ToolWindow toolwindow = ToolWindowHelper.getToolwindow(project);
        try {
            ThreadManager.getInstance().runUiThreadSave(() -> {
                if (toolwindow == null) {
                    return;
                }
                if (!toolwindow.isVisible() && showWindow) {
                    toolwindow.show();
                }
            });
        }
        catch (Exception e) {
            LogManager.warn(NodeRunner.class, "openWindowAndHandle:" + String.valueOf(e));
        }
    }

    private JBPanel<?> createFeedbackPanel() {
        JBPanel mainPanel = new JBPanel().withBackground(ColorUtils.getBackgroundColor());
        mainPanel.setLayout((LayoutManager)new BoxLayout((Container)mainPanel, 3));
        mainPanel.setBorder(JBUI.Borders.empty((int)20));
        JBLabel titleLabel = new JBLabel("Missing JCEF Runtime");
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1, 18.0f));
        titleLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, titleLabel.getPreferredSize().height));
        titleLabel.setAlignmentX(0.5f);
        String[] descriptions = new String[]{"CodeBuddy relies on JCEF (Java Chromium Embedded Framework) to function.", "Please switch to a runtime that includes JCEF."};
        JBPanel descPanel = new JBPanel();
        descPanel.setLayout((LayoutManager)new BoxLayout((Container)descPanel, 3));
        descPanel.setBackground(ColorUtils.getBackgroundColor());
        for (String description : descriptions) {
            JBLabel descriptionLabel = new JBLabel(description);
            descriptionLabel.setHorizontalAlignment(0);
            descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(14.0f));
            descriptionLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, descriptionLabel.getPreferredSize().height));
            descriptionLabel.setAlignmentX(0.5f);
            descriptionLabel.setLayout((LayoutManager)new FlowLayout());
            descPanel.add((Component)descriptionLabel);
            descPanel.add(Box.createVerticalStrut(16));
        }
        JBPanel buttonPanel = new JBPanel((LayoutManager)new FlowLayout(1, 10, 10));
        buttonPanel.setBackground(ColorUtils.getBackgroundColor());
        Color switchButtonColor = new Color(4880886);
        JButton switchRuntimeButton = ButtonBuilder.createRadCustomColorButton(Color.white, 8, switchButtonColor, null, null, switchButtonColor);
        switchRuntimeButton.setText("Switch Runtime");
        switchRuntimeButton.setPreferredSize(new Dimension(148, 48));
        switchRuntimeButton.setMinimumSize(new Dimension(148, 48));
        switchRuntimeButton.addActionListener(e -> {
            String bootRuntimeActionId = "ChooseRuntime";
            AnAction action = ActionManager.getInstance().getAction(bootRuntimeActionId);
            ActionCallback callback = ActionManager.getInstance().tryToExecute(action, ActionCommand.getInputEvent((String)bootRuntimeActionId), null, "unknown", true);
            callback.doWhenDone(() -> {
                String restartIde = "RestartIde";
                AnAction restartAction = ActionManager.getInstance().getAction(restartIde);
                ActionManager.getInstance().tryToExecute(restartAction, ActionCommand.getInputEvent((String)restartIde), null, "unknown", true);
            });
        });
        Color revertButtonColor = new Color(4408650);
        JButton revertButton = ButtonBuilder.createRadCustomColorButton(Color.WHITE, 8, revertButtonColor, null, null, revertButtonColor);
        revertButton.setText("Install Legacy Version");
        revertButton.setPreferredSize(new Dimension(148, 48));
        revertButton.setMinimumSize(new Dimension(148, 48));
        revertButton.addActionListener(e -> {
            String versionLink = "https://plugins.jetbrains.com/plugin/24379-tencent-cloud-codebuddy/versions";
            URLUtils.browse(versionLink);
        });
        buttonPanel.add((Component)switchRuntimeButton);
        buttonPanel.add((Component)revertButton);
        buttonPanel.setAlignmentX(0.5f);
        mainPanel.add((Component)titleLabel);
        mainPanel.add(Box.createVerticalStrut(16));
        mainPanel.add((Component)descPanel);
        mainPanel.add(Box.createVerticalStrut(16));
        mainPanel.add((Component)buttonPanel);
        JBPanel container = new JBPanel((LayoutManager)new GridBagLayout());
        container.setBackground(ColorUtils.getBackgroundColor());
        container.add((Component)mainPanel);
        return container;
    }

    public static ToolWindow getToolwindow(Project project) {
        try {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
            if (toolWindow == null) {
                LogManager.warn(NodeRunner.class, "getToolwindow: toolWindow is null");
            }
            return toolWindow;
        }
        catch (Exception e) {
            LogManager.warn(NodeRunner.class, "getToolwindow: " + String.valueOf(e));
            return null;
        }
    }

    public static boolean isWebviewEnable() {
        boolean flag;
        boolean bl = flag = PluginUtils.getBuildVersion() >= 221 && PluginUtils.isJCEEEnable();
        if (!flag) {
            LogManager.warn(NodeRunner.class, "Use Webview has some error>>>" + PluginUtils.getBuildVersion() + "JCEF Enabled: " + (PluginUtils.isJCEEEnable() ? "true" : "false"));
        }
        return flag;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            ToolWindowHelper.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            ToolWindowHelper.$$$reportNull$$$0(1);
        }
        if (!ToolWindowHelper.isWebviewEnable()) {
            toolWindow.getComponent().add((Component)this.createFeedbackPanel());
        }
    }

    public void init(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ToolWindowHelper.$$$reportNull$$$0(2);
        }
        toolWindow.setStripeTitle(LocaleManager.get("gf_copilot"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/apibridge/toolwindow/ToolWindowHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

