/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import org.jetbrains.annotations.NotNull;

public class EditorUtils {
    public static String getFilePath(Editor editor) {
        VirtualFile virtualFile = EditorUtils.getVirtualFile(editor);
        return EditorUtils.getFilePath(virtualFile);
    }

    public static VirtualFile getVirtualFile(Editor editor) {
        PsiFile psiFile = EditorUtils.getPsiFile(editor);
        if (psiFile != null) {
            return psiFile.getVirtualFile();
        }
        return null;
    }

    public static String getFilePath(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        return VirtualFileUriBean.from(virtualFile).getUri();
    }

    public static PsiFile getPsiFile(Editor editor) {
        if (editor != null && !editor.isDisposed()) {
            Project project = editor.getProject();
            Document document = editor.getDocument();
            if (project != null && !project.isDisposed()) {
                return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            }
        }
        return null;
    }

    public static Position position(@NotNull Document document, int offset) {
        int maxOffset;
        if (document == null) {
            EditorUtils.$$$reportNull$$$0(0);
        }
        if (offset > (maxOffset = document.getTextLength())) {
            offset = maxOffset;
        }
        int line = document.getLineNumber(offset);
        int lineStart = document.getLineStartOffset(line);
        int column = offset - lineStart;
        return new Position(line, column);
    }

    public static Integer getTabSize(Editor editor) {
        if (editor == null || editor.getProject() == null) {
            return 4;
        }
        EditorSettings settings = editor.getSettings();
        return settings.getTabSize(editor.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/tencent/code/intel/apibridge/util/EditorUtils", "position"));
    }
}

