/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.project.ProjectManager;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.manager.LogManager;
import java.util.List;

public class FusionApplicationListener
implements AppLifecycleListener {
    public void appWillBeClosed(boolean isRestart) {
        LogManager.warn(FusionApplicationListener.class, "appWillBeClosed");
        super.appWillBeClosed(isRestart);
        this.release();
    }

    public void appClosing() {
        LogManager.warn(FusionApplicationListener.class, "appClosing");
        super.appClosing();
        this.release();
    }

    private void release() {
        try {
            List.of(ProjectManager.getInstance().getOpenProjects()).forEach(project -> {
                NodeRunner runner = NodeRunner.getInstance(project);
                if (runner != null) {
                    runner.release();
                }
            });
        }
        catch (Exception e) {
            LogManager.error(this.getClass(), "Error releasing node processes: " + e.getMessage());
        }
    }
}

