/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.apibridge.extension.extension.textEditors.data.TextEditorSelectionChangeKind;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.common.EditorCommandName;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LogManager;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class FusionCaretListener
implements CaretListener {
    public static AtomicLong lastChangeTime = new AtomicLong(System.currentTimeMillis());
    public static final List<String> INLAY_DISMISS_IGNORE_COMMEND = List.of("Typing", "\u8f93\u5165");

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Editor editor;
        Project project;
        if (event == null) {
            FusionCaretListener.$$$reportNull$$$0(0);
        }
        if ((project = (editor = event.getEditor()).getProject()) == null || project.isDisposed()) {
            return;
        }
        FusionCaretListener.onPositionChanged(project, editor);
    }

    public static void onPositionChanged(Project project, Editor editor) {
        try {
            boolean isValidInput;
            lastChangeTime.set(System.currentTimeMillis());
            String commandName = CommandProcessor.getInstance().getCurrentCommandName();
            boolean bl = isValidInput = !EditorCommandName.isIgnored(commandName);
            if (isValidInput && commandName != null && !INLAY_DISMISS_IGNORE_COMMEND.contains(commandName) && LookupManager.getActiveLookup((Editor)editor) == null) {
                InlayService.getInstance().disposeAllInlays();
                InlayService.getInstance().disposeAllInlays(project);
                AWTEvent inputEvent = IdeEventQueue.getInstance().getTrueCurrentEvent();
                boolean isKeyboardTriggered = inputEvent instanceof KeyEvent;
                if (editor != null && !editor.isDisposed() && NodeRunner.getInstance(editor.getProject()) != null) {
                    NodeRunner.getInstance(editor.getProject()).getEditors().selectionModelChanged(editor, isKeyboardTriggered ? TextEditorSelectionChangeKind.KEYBOARD : TextEditorSelectionChangeKind.MOUSE);
                }
            } else if (commandName != null && INLAY_DISMISS_IGNORE_COMMEND.contains(commandName)) {
                ExtHostLanguageFeatures.setCompletionHint(project, false);
            }
        }
        catch (Exception e) {
            LogManager.warn(FusionCaretListener.class, "caretPositionChanged: " + String.valueOf(e));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/tencent/code/intel/apibridge/util/FusionCaretListener", "caretPositionChanged"));
    }
}

