/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.ExtHostDocuments;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import com.tencent.code.intel.manager.LogManager;
import org.jetbrains.annotations.NotNull;

public class FusionDocumentListener
implements BulkAwareDocumentListener {
    private Project project;
    private FileEditor editor;

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            FusionDocumentListener.$$$reportNull$$$0(0);
        }
        if (NodeRunner.getInstance(this.project) == null) {
            return;
        }
        NodeRunner.getInstance(this.project).getDocuments().documentChanged(event);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            FusionDocumentListener.$$$reportNull$$$0(1);
        }
        if (NodeRunner.getInstance(this.project) == null) {
            return;
        }
        try {
            String commandName = CommandProcessor.getInstance().getCurrentCommandName();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (virtualFile == null) {
                LogManager.warn(ExtHostDocuments.class, "VirtualFile is null");
                return;
            }
            String uri = VirtualFileUriBean.from(virtualFile).getUri();
            NodeRunner.getInstance(this.project).getDocuments().acceptModelSave(uri);
            ExtHostLanguageFeatures.onDocumentChanged(this.project, this.editor, uri, commandName);
        }
        catch (Exception e) {
            LogManager.warn(FusionDocumentListener.class, "documentChanged: " + String.valueOf(e));
        }
    }

    public FusionDocumentListener(Project project, FileEditor editor) {
        this.project = project;
        this.editor = editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/tencent/code/intel/apibridge/util/FusionDocumentListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeDocumentChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

