/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.apibridge.extension.mainthread.command.MainThreadCommandImplementService;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.util.EditorUtils;
import com.tencent.code.intel.apibridge.util.FusionCaretListener;
import com.tencent.code.intel.apibridge.util.FusionDocumentListener;
import com.tencent.code.intel.impl.GFCopilotService;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class FusionEditorListener
implements FileEditorManagerListener,
FileEditorManagerListener.Before {
    private final Project project;
    private final Map<Document, FusionDocumentListener> documentListenerMap = new ConcurrentHashMap<Document, FusionDocumentListener>();
    private final Map<Editor, FusionCaretListener> caretListenerMap = new ConcurrentHashMap<Editor, FusionCaretListener>();

    public FusionEditorListener(Project project) {
        this.project = project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        VirtualFile sourceFile;
        if (event == null) {
            FusionEditorListener.$$$reportNull$$$0(0);
        }
        VirtualFile focusedFile = event.getNewFile();
        VirtualFile oldFile = event.getOldFile();
        Document document = null;
        FileEditor editor = null;
        if (focusedFile != null) {
            FileEditor[] diffFile;
            VirtualFile file;
            sourceFile = focusedFile instanceof ChainDiffVirtualFile ? ((file = (VirtualFile)(diffFile = (FileEditor[])focusedFile).getUserData(MainThreadCommandImplementService.DIFF_VIRTUAL_FILE_KEY)) != null ? file : focusedFile) : focusedFile;
            for (FileEditor fileEditor : event.getManager().getEditors(focusedFile)) {
                if (fileEditor.getFile() == null || fileEditor.getFile() != focusedFile) continue;
                editor = fileEditor;
                document = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor().getDocument() : FileDocumentManager.getInstance().getDocument(sourceFile);
                break;
            }
        } else {
            sourceFile = focusedFile;
        }
        FileEditor finalEditor = editor;
        Document finalDocument = document;
        this.checkAndHandleNodeRunner(this.project, () -> this.handleSelectionChanged(this.project, finalEditor, finalDocument, sourceFile, focusedFile, oldFile));
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            FusionEditorListener.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FusionEditorListener.$$$reportNull$$$0(2);
        }
        this.checkAndHandleNodeRunner(this.project, () -> this.handleFileOpened(source, file));
    }

    public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            FusionEditorListener.$$$reportNull$$$0(3);
        }
        if (file == null) {
            FusionEditorListener.$$$reportNull$$$0(4);
        }
        this.checkAndHandleNodeRunner(this.project, () -> this.handleBeforeFileClosed(source, file));
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            FusionEditorListener.$$$reportNull$$$0(5);
        }
        if (file == null) {
            FusionEditorListener.$$$reportNull$$$0(6);
        }
        this.checkAndHandleNodeRunner(this.project, () -> this.handleFileClosed(source, file));
    }

    private void handleFileOpened(FileEditorManager source, VirtualFile file) {
        ThreadManager.getInstance().runUiThread(() -> {
            try {
                FileEditor[] editors;
                NodeRunner.getInstance(this.project).getEditorTabs().fileOpen(file, this.project);
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document == null) {
                    return;
                }
                for (FileEditor fileEditor : editors = source.getEditors(file)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    FusionCaretListener caretListener = new FusionCaretListener();
                    editor.getCaretModel().addCaretListener((CaretListener)caretListener);
                    this.caretListenerMap.put(editor, caretListener);
                    FusionDocumentListener documentListener = new FusionDocumentListener(this.project, fileEditor);
                    document.addDocumentListener((DocumentListener)documentListener);
                    this.documentListenerMap.put(document, documentListener);
                    String uri = EditorUtils.getFilePath(file);
                    if (TextUtils.isEmpty((CharSequence)uri) || source.getSelectedFiles().length <= 0 || !file.equals(source.getSelectedFiles()[0])) continue;
                    try {
                        NodeRunner.getInstance(this.project).updateFocusEditorAndDocument(fileEditor, document, file, this.project, null);
                        ExtHostLanguageFeatures.provideCodeLenses(this.project, editor, uri, null);
                        NodeRunner.getInstance(this.project).getEditorTabs().tabSwitched(file, this.project);
                    }
                    catch (Exception e) {
                        LogManager.warn(FusionEditorListener.class, "fileOpened focus-sync error: " + String.valueOf(e));
                    }
                }
                if (source.getEditors(file).length == 0) {
                    ThreadManager.getInstance().runDelayUiThreadSave(200, () -> {
                        block6: {
                            try {
                                FileEditor[] delayedEditors = source.getEditors(file);
                                if (delayedEditors.length <= 0) break block6;
                                for (FileEditor fileEditor : delayedEditors) {
                                    String uri;
                                    if (!(fileEditor instanceof TextEditor)) continue;
                                    Editor editor = ((TextEditor)fileEditor).getEditor();
                                    FusionCaretListener caretListener = new FusionCaretListener();
                                    editor.getCaretModel().addCaretListener((CaretListener)caretListener);
                                    this.caretListenerMap.put(editor, caretListener);
                                    if (source.getSelectedFiles().length > 0 && file.equals(source.getSelectedFiles()[0]) && !TextUtils.isEmpty((CharSequence)(uri = EditorUtils.getFilePath(file)))) {
                                        try {
                                            NodeRunner.getInstance(this.project).updateFocusEditorAndDocument(fileEditor, document, file, this.project, null);
                                            ExtHostLanguageFeatures.provideCodeLenses(this.project, editor, uri, null);
                                            NodeRunner.getInstance(this.project).getEditorTabs().tabSwitched(file, this.project);
                                        }
                                        catch (Exception e) {
                                            LogManager.warn(FusionEditorListener.class, "delayed focus-sync error: " + String.valueOf(e));
                                        }
                                    }
                                    break;
                                }
                            }
                            catch (Exception ex) {
                                LogManager.warn(FusionEditorListener.class, "delayed editor sync error: " + String.valueOf(ex));
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                LogManager.warn(FusionEditorListener.class, "fileOpened error: " + String.valueOf(e));
            }
        });
        ThreadManager.getInstance().runDelayUiThreadSave(500, () -> {
            FileEditor[] editors;
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return;
            }
            for (FileEditor fileEditor : editors = source.getEditors(file)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                String uri = EditorUtils.getFilePath(file);
                ExtHostLanguageFeatures.provideCodeLenses(this.project, editor, uri, null);
            }
        });
    }

    private void handleBeforeFileClosed(FileEditorManager source, VirtualFile file) {
        FileEditor[] fileEditors;
        for (FileEditor fileEditor : fileEditors = source.getEditors(file)) {
            NodeRunner.getInstance(this.project).getDocumentsAndEditors().removeEditor(fileEditor, file, this.project);
        }
        ThreadManager.getInstance().runUiThread(() -> {
            try {
                NodeRunner.getInstance(this.project).getEditorTabs().fileClose(file, this.project);
            }
            catch (Exception e) {
                LogManager.warn(FusionEditorListener.class, "beforeFileClosed error: " + String.valueOf(e));
            }
        });
    }

    private void handleFileClosed(FileEditorManager source, VirtualFile file) {
        ThreadManager.getInstance().runUiThread(() -> {
            try {
                FileEditor[] editors;
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document == null) {
                    return;
                }
                FusionDocumentListener documentListener = this.documentListenerMap.remove(document);
                if (documentListener != null) {
                    document.removeDocumentListener((DocumentListener)documentListener);
                }
                for (FileEditor fileEditor : editors = source.getEditors(file)) {
                    Editor editor;
                    FusionCaretListener caretListener;
                    if (!(fileEditor instanceof TextEditor) || (caretListener = this.caretListenerMap.remove(editor = ((TextEditor)fileEditor).getEditor())) == null) continue;
                    editor.getCaretModel().removeCaretListener((CaretListener)caretListener);
                }
                NodeRunner.getInstance(this.project).getDocumentsAndEditors().removeDocument(document, this.project);
            }
            catch (Exception e) {
                LogManager.warn(FusionEditorListener.class, "fileClosed error: " + String.valueOf(e));
            }
        });
    }

    private void handleSelectionChanged(Project project, FileEditor editor, Document document, VirtualFile sourceFile, VirtualFile focusedFile, VirtualFile oldFile) {
        String uri = EditorUtils.getFilePath(sourceFile);
        ThreadManager.getInstance().runUiThread(() -> {
            if (TextUtils.isEmpty((CharSequence)uri)) {
                return;
            }
            if (!(editor instanceof TextEditor)) {
                return;
            }
            if (oldFile != null && sourceFile != null) {
                String oldPath = EditorUtils.getFilePath(oldFile);
                String newPath = uri;
                if (oldPath != null && !oldPath.equals(newPath)) {
                    try {
                        InlayService.getInstance().disposeAllInlays();
                        NodeRunner.getInstance(project).getEditors().activeTextEditorChanged(oldPath, newPath);
                    }
                    catch (Exception e) {
                        LogManager.warn(FusionEditorListener.class, "activeTextEditorChanged error: " + String.valueOf(e));
                    }
                }
            }
            NodeRunner.getInstance(project).updateFocusEditorAndDocument(editor, document, sourceFile, project, oldFile);
            ExtHostLanguageFeatures.provideCodeLenses(project, ((TextEditor)editor).getEditor(), uri, null);
            Editor textEditor = ((TextEditor)editor).getEditor();
            GFCopilotService.getInstance().editorFocusChange(textEditor, sourceFile);
            try {
                if (focusedFile != null) {
                    NodeRunner.getInstance(project).getEditorTabs().tabSwitched(focusedFile, project);
                }
            }
            catch (Exception e) {
                NodeRunner.getInstance(project).getEditorTabs().updateAllWindows(project);
            }
        });
    }

    private void checkAndHandleNodeRunner(Project project, Runnable callback) {
        NodeRunner nodeRunner = NodeRunner.getInstance(project);
        if (nodeRunner != null) {
            nodeRunner.addRpcReadyCallback(callback);
            return;
        }
        callback.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/apibridge/util/FusionEditorListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileClosed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

