/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.tencent.code.intel.apibridge.extension.extension.window.ExtHostWindow;
import com.tencent.code.intel.apibridge.nodeprocess.NodeProjectService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.PluginUtils;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FusionProjectListener
implements ProjectManagerListener,
ModuleListener {
    private static final Key<Window> KEY_BOUND_WINDOW = Key.create((String)"fusion.bound.window");
    private static final Key<WindowListener> KEY_WINDOW_LISTENER = Key.create((String)"fusion.window.listener");

    public void projectOpened(@NotNull Project project) {
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(0);
        }
        super.projectOpened(project);
        this.registerWindowListener(project);
    }

    public boolean canCloseProject(@NotNull Project project) {
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(1);
        }
        return super.canCloseProject(project);
    }

    public void projectClosed(@NotNull Project project) {
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(2);
        }
        this.unregisterWindowListener(project);
        try {
            if (this.isListenerEnabled()) {
                ((NodeProjectService)project.getService(NodeProjectService.class)).getNodeRunner().release();
            }
        }
        catch (Exception e) {
            LogManager.warn(FusionProjectListener.class, "projectClosed error" + String.valueOf(e));
        }
    }

    public void projectClosing(@NotNull Project project) {
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(3);
        }
        super.projectClosing(project);
        this.unregisterWindowListener(project);
    }

    public void projectClosingBeforeSave(@NotNull Project project) {
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(4);
        }
        super.projectClosingBeforeSave(project);
    }

    private boolean isListenerEnabled() {
        return !PluginUtils.isGatewayHost() && !PluginUtils.isGatewayClient();
    }

    private void registerWindowListener(final @NotNull Project project) {
        Window currentWindow;
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(5);
        }
        if ((currentWindow = this.getCurrentWindow(project)) == null) {
            return;
        }
        Window boundWindow = (Window)project.getUserData(KEY_BOUND_WINDOW);
        WindowListener boundListener = (WindowListener)project.getUserData(KEY_WINDOW_LISTENER);
        if (boundWindow == currentWindow && boundListener != null) {
            return;
        }
        this.unregisterWindowListener(project);
        WindowAdapter listener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                LogManager.info(FusionProjectListener.class, "Window activated for project: " + project.getName());
                ExtHostWindow.onDidChangeWindowFocus(project, true);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                LogManager.info(FusionProjectListener.class, "Window deactivated for project: " + project.getName());
                ExtHostWindow.onDidChangeWindowFocus(project, false);
            }
        };
        currentWindow.addWindowListener(listener);
        project.putUserData(KEY_BOUND_WINDOW, (Object)currentWindow);
        project.putUserData(KEY_WINDOW_LISTENER, (Object)listener);
    }

    private void unregisterWindowListener(@NotNull Project project) {
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(6);
        }
        Window boundWindow = (Window)project.getUserData(KEY_BOUND_WINDOW);
        WindowListener boundListener = (WindowListener)project.getUserData(KEY_WINDOW_LISTENER);
        if (boundWindow != null && boundListener != null) {
            try {
                boundWindow.removeWindowListener(boundListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        project.putUserData(KEY_BOUND_WINDOW, null);
        project.putUserData(KEY_WINDOW_LISTENER, null);
    }

    private Window getCurrentWindow(@NotNull Project project) {
        IdeFrame ideFrame;
        if (project == null) {
            FusionProjectListener.$$$reportNull$$$0(7);
        }
        if ((ideFrame = WindowManager.getInstance().getIdeFrame(project)) == null) {
            return null;
        }
        JComponent comp = ideFrame.getComponent();
        if (comp == null) {
            return null;
        }
        Container parent = comp.getParent();
        return parent instanceof Window ? (Window)parent : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/tencent/code/intel/apibridge/util/FusionProjectListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "projectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canCloseProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosing";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosingBeforeSave";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWindowListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterWindowListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

