/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import groovy.lang.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FusionTextUtils {
    private static final String pluginName = "codingcopilot";
    public static final String ERROR_ICON = FusionTextUtils.toVSCodeIcon(FusionTextUtils.withPluginNamePrefix("error", "-"));
    public static final String ACTIVE_ICON = FusionTextUtils.toVSCodeIcon(FusionTextUtils.withPluginNamePrefix("logo", "-"));
    public static final String LOADING_ICON = FusionTextUtils.toVSCodeIcon("loading~spin");
    public static final String DISABLE_ICON = FusionTextUtils.toVSCodeIcon(FusionTextUtils.withPluginNamePrefix("disable", "-"));
    public static final String WARNING_ICON = FusionTextUtils.toVSCodeIcon(FusionTextUtils.withPluginNamePrefix("warning", "-"));

    public static String withPluginNamePrefix(String text, String connector) {
        if (connector == null) {
            connector = ".";
        }
        return pluginName + connector + text;
    }

    public static String toVSCodeIcon(String iconName) {
        return String.format("$(%s)", iconName);
    }

    public static Tuple2<List<String>, String> traitIconAndText(String text) {
        ArrayList<String> icons = new ArrayList<String>();
        String regex = "\\$\\(([A-Za-z0-9-]+(?:~[A-Za-z0-9-]+)?)\\)";
        Pattern pattern = Pattern.compile(regex, 256);
        Matcher matcher = pattern.matcher(text);
        int lastEnd = 0;
        while (matcher.find()) {
            icons.add(matcher.group(1));
            lastEnd = matcher.end();
        }
        String restText = text.substring(lastEnd).trim();
        return new Tuple2(icons, (Object)restText);
    }
}

