/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.apibridge.util.resolver.GoSymbolResolver;
import com.tencent.code.intel.apibridge.util.resolver.JAVASymbolResolver;
import com.tencent.code.intel.apibridge.util.resolver.JSSymbolResolver;
import com.tencent.code.intel.apibridge.util.resolver.KOTLINSymbolResolver;
import com.tencent.code.intel.apibridge.util.resolver.PythonSymbolResolver;
import com.tencent.code.intel.apibridge.util.resolver.SymbolResolver;
import com.tencent.code.intel.manager.LogManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.util.TextUtils;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;

public class PsiConverter {
    public List<DocumentSymbol> convertPsiToDocumentSymbols(PsiFile file) {
        ArrayList<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        if (file == null) {
            return symbols;
        }
        for (PsiElement element : file.getChildren()) {
            DocumentSymbol symbol = this.convertElement(element);
            if (symbol == null) continue;
            symbols.add(symbol);
        }
        return symbols;
    }

    private DocumentSymbol convertElement(PsiElement element) {
        SymbolKind kind = this.getSymbolKind(element);
        if (kind == null) {
            if (this.shouldProcessChildren(element)) {
                ArrayList<DocumentSymbol> childSymbols = new ArrayList<DocumentSymbol>();
                for (PsiElement child : element.getChildren()) {
                    DocumentSymbol childSymbol = this.convertElement(child);
                    if (childSymbol == null) continue;
                    childSymbols.add(childSymbol);
                }
                return null;
            }
            return null;
        }
        String name = this.getName(element);
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        Range range = this.getRange(element);
        Range selectionRange = this.getSelectionRange(element);
        ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
        for (PsiElement child : element.getChildren()) {
            if (this.shouldProcessChildren(child) && this.getSymbolKind(child) == null) {
                for (PsiElement grandChild : child.getChildren()) {
                    DocumentSymbol grandChildSymbol = this.convertElement(grandChild);
                    if (grandChildSymbol == null) continue;
                    children.add(grandChildSymbol);
                }
                continue;
            }
            DocumentSymbol childSymbol = this.convertElement(child);
            if (childSymbol == null) continue;
            children.add(childSymbol);
        }
        return new DocumentSymbol(name, kind, range, selectionRange, null, children);
    }

    private boolean shouldProcessChildren(PsiElement element) {
        String className = element.getClass().getName();
        return "com.jetbrains.python.psi.impl.PyStatementListImpl".equals(className);
    }

    private SymbolKind getSymbolKind(PsiElement element) {
        SymbolResolver resolver = this.getSymbolResolver(element);
        if (resolver == null) {
            return null;
        }
        return resolver.resolveSymbolKind(element);
    }

    private String getName(PsiElement element) {
        SymbolResolver resolver = this.getSymbolResolver(element);
        if (resolver == null) {
            return "Unnamed";
        }
        return resolver.resolveName(element);
    }

    private Range getRange(PsiElement element) {
        TextRange textRange = element.getTextRange();
        Document doc = FileDocumentManager.getInstance().getDocument(element.getContainingFile().getVirtualFile());
        if (doc == null) {
            return new Range(new Position(0, 0), new Position(0, 0));
        }
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        Position start = this.getPosition(doc, startOffset);
        Position end = this.getPosition(doc, endOffset);
        return new Range(start, end);
    }

    private Range getSelectionRange(PsiElement element) {
        SymbolResolver resolver = this.getSymbolResolver(element);
        if (resolver == null) {
            return this.getRange(element);
        }
        PsiElement nameIdentifier = resolver.resolveNameIdentifier(element);
        return nameIdentifier != null ? this.getRange(nameIdentifier) : this.getRange(element);
    }

    @NotNull
    private Position getPosition(Document doc, int offset) {
        try {
            int line = doc.getLineNumber(offset);
            int lineStart = doc.getLineStartOffset(line);
            int column = offset - lineStart;
            return new Position(line, column);
        }
        catch (Exception e) {
            LogManager.info(PsiConverter.class, e.toString());
            return new Position(0, 0);
        }
    }

    private SymbolResolver getSymbolResolver(PsiElement element) {
        String languageId = element.getLanguage().getID();
        return this.getSymbolResolver(languageId);
    }

    private SymbolResolver getSymbolResolver(String languageId) {
        SymbolResolver resolver;
        switch (languageId) {
            case "JAVA": {
                resolver = new JAVASymbolResolver();
                break;
            }
            case "Python": {
                resolver = new PythonSymbolResolver();
                break;
            }
            case "kotlin": {
                resolver = new KOTLINSymbolResolver();
                break;
            }
            case "JavaScript": {
                resolver = new JSSymbolResolver();
                break;
            }
            case "go": {
                resolver = new GoSymbolResolver();
                break;
            }
            default: {
                return null;
            }
        }
        return resolver;
    }
}

