/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.openapi.util.SystemInfo;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.Terminal;
import com.tencent.code.intel.manager.LogManager;
import org.apache.http.util.TextUtils;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public class TerminalSettingUtils {
    public static String getShellPath() {
        String shellPath;
        try {
            shellPath = TerminalOptionsProvider.getInstance().getShellPath();
            if (!TextUtils.isEmpty((CharSequence)shellPath)) {
                LogManager.info(Terminal.class, "getShellType by terminalOptionsProvider: " + shellPath);
                return shellPath;
            }
        }
        catch (Exception e) {
            LogManager.warn(Terminal.class, "getShellType by terminalOptionsProvider failed: " + e.getMessage());
        }
        shellPath = System.getenv("SHELL");
        if (!TextUtils.isEmpty((CharSequence)shellPath)) {
            LogManager.info(Terminal.class, "getShellType by SHELL env: " + shellPath);
            return shellPath;
        }
        String defaultShell = SystemInfo.isWindows ? "cmd.exe" : "/bin/sh";
        LogManager.info(Terminal.class, "getShellType by default: " + defaultShell);
        return defaultShell;
    }

    public static String getShellCommandParam(String shellPath) {
        String normalizedPath = shellPath.toLowerCase();
        if (!SystemInfo.isWindows) {
            return "-c";
        }
        if (normalizedPath.contains("cmd.exe")) {
            return "/c";
        }
        if (normalizedPath.contains("powershell") || normalizedPath.contains("pwsh")) {
            return "-Command";
        }
        return "-c";
    }
}

