/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import com.tencent.code.intel.callback.ObjectCallback;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class UpdatePluginTask
extends Task.Backgroundable {
    private static AtomicBoolean isDownloading = new AtomicBoolean();
    private static AtomicBoolean isUpdateTask = new AtomicBoolean();
    private String downloadUrl;
    @NotNull
    private final ObjectCallback<Boolean> callback;

    public UpdatePluginTask(String downloadUrl, ObjectCallback<Boolean> callback) {
        super(null, "Updating " + LocaleManager.get("plugin.copilot.name") + "...", false);
        this.downloadUrl = downloadUrl;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UpdatePluginTask.$$$reportNull$$$0(0);
        }
        Boolean taskResult = false;
        isUpdateTask.set(true);
        try {
            if (isDownloading.get()) {
                LogManager.info(UpdatePluginTask.class, "isDownloading");
                return;
            }
            isDownloading.set(true);
            LogManager.info(UpdatePluginTask.class, "start downloading plugin\uff1a " + this.downloadUrl);
            boolean result = UpdatePluginTask.installFromDiskAndInstall(this.downloadUrl);
            if (result) {
                taskResult = true;
                LogManager.info(UpdatePluginTask.class, "copilot plugin update succeeded");
                return;
            }
            LogManager.info(UpdatePluginTask.class, "copilot plugin update failed");
        }
        catch (Exception e) {
            LogManager.warn(UpdatePluginTask.class, "update plugin failed:" + e.toString());
        }
        finally {
            isDownloading.set(false);
            this.callback.onResult(taskResult);
            isUpdateTask.set(false);
        }
    }

    private static boolean installFromDiskAndInstall(String url) {
        LogManager.info(UpdatePluginTask.class, "installFromDiskAndInstall:" + url);
        try {
            File pluginFile;
            String currUrl = VirtualFileUriBean.from((VirtualFileSystem)LocalFileSystem.getInstance(), url).getUri();
            try {
                URI uri = URI.create(currUrl);
                pluginFile = new File(uri);
            }
            catch (IllegalArgumentException e) {
                LogManager.warn(UpdatePluginTask.class, "URI parsing failed, falling back to direct file path: " + e.getMessage());
                pluginFile = UpdatePluginTask.createFileFromUriString(currUrl);
                LogManager.info(UpdatePluginTask.class, "Using direct file path: " + pluginFile.getAbsolutePath());
            }
            LogManager.info(UpdatePluginTask.class, "installFromDiskAndInstall currUrl:" + currUrl);
            if (pluginFile.exists()) {
                Path originalPath = pluginFile.toPath();
                Path backupPath = originalPath.resolveSibling(FileUtil.getNameWithoutExtension((String)pluginFile.getName()) + "-bak." + FileUtilRt.getExtension((String)pluginFile.getName()));
                Files.move(originalPath, backupPath, StandardCopyOption.ATOMIC_MOVE);
                LogManager.info(UpdatePluginTask.class, "installFromDiskAndInstall backupPath:" + String.valueOf(backupPath));
                if (!Files.exists(backupPath, new LinkOption[0])) {
                    LogManager.warn(UpdatePluginTask.class, "move to bak file failed :" + backupPath.toString());
                    backupPath = originalPath;
                }
                LogManager.info(UpdatePluginTask.class, "installFromDiskAndInstall backupPath:" + String.valueOf(backupPath));
                ArrayList<Object> commands = new ArrayList<Object>();
                Path pluginsPath = Paths.get(PathManager.getPluginsPath(), new String[0]);
                commands.add(new StartupActionScriptManager.DeleteCommand(pluginsPath.resolve("coding-copilot")));
                commands.add(new StartupActionScriptManager.DeleteCommand(pluginsPath.resolve(PluginInstaller.rootEntryName((Path)backupPath))));
                commands.add(new StartupActionScriptManager.UnzipCommand(backupPath, pluginsPath));
                commands.add(new StartupActionScriptManager.DeleteCommand(backupPath));
                StartupActionScriptManager.addActionCommands(commands);
                LogManager.info(UpdatePluginTask.class, "AddActionCommands");
                return true;
            }
        }
        catch (Exception e) {
            LogManager.warn(UpdatePluginTask.class, "installFromDiskAndInstall:" + e.toString());
            return false;
        }
        return false;
    }

    private static File createFileFromUriString(String uriString) {
        try {
            String filePath = uriString;
            if (uriString.startsWith("file://")) {
                filePath = uriString.substring(7);
                if (filePath.startsWith("//")) {
                    if (SystemInfo.isWindows) {
                        filePath = filePath.substring(1);
                    }
                } else if (!filePath.startsWith("/") || !SystemInfo.isWindows || filePath.length() <= 1 || filePath.charAt(1) != ':') {
                    // empty if block
                }
            }
            try {
                filePath = URLDecoder.decode(filePath, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LogManager.warn(UpdatePluginTask.class, "URL decoding failed, using original path: " + e.getMessage());
            }
            filePath = UpdatePluginTask.normalizePathForOS(filePath);
            return new File(filePath);
        }
        catch (Exception e) {
            LogManager.warn(UpdatePluginTask.class, "Failed to create file from URI string: " + e.getMessage());
            return new File(uriString);
        }
    }

    private static String normalizePathForOS(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (SystemInfo.isWindows ? !(path = path.replace('/', '\\')).startsWith("\\\\") && path.startsWith("\\") : path.startsWith("/") || !path.startsWith("\\")) {
            // empty if block
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/tencent/code/intel/apibridge/util/UpdatePluginTask", "run"));
    }
}

