/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.UriComponents;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class UriComponentConverter {
    public static UriComponents getUriComponents(VirtualFile file) {
        if (file == null) {
            return null;
        }
        try {
            URI uri = new URI(file.toString());
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            String query = uri.getQuery();
            String fragment = uri.getFragment();
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            String fsPath = FileUtil.toSystemDependentName((String)ioFile.getPath());
            Object path = FileUtil.toSystemIndependentName((String)ioFile.getPath());
            if (((String)path).matches("^[A-Za-z]:.*")) {
                path = "/" + (String)path;
            }
            return new UriComponents(scheme, authority, (String)path, query, fragment, fsPath, true);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

