/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util.resolver;

import com.intellij.psi.PsiElement;
import com.tencent.code.intel.apibridge.util.resolver.SymbolResolver;
import com.tencent.code.intel.util.PsiUtils;
import org.eclipse.lsp4j.SymbolKind;

public class JAVASymbolResolver
implements SymbolResolver {
    private static final String CLASS_NAME_JAVA = "com.intellij.psi.PsiClass";
    private static final String FUNCTION_CLASS_NAME_JAVA = "com.intellij.psi.PsiMethod";
    private static final String FIELD_CLASS_NAME_JAVA = "com.intellij.psi.PsiField";
    private static final String VARIABLE_CLASS_NAME_JAVA = "com.intellij.psi.PsiVariable";
    private static final String NAMED_CLASS_NAME_JAVA = "com.intellij.psi.PsiNamedElement";

    @Override
    public SymbolKind resolveSymbolKind(PsiElement element) {
        if (PsiUtils.instanceOf(element, CLASS_NAME_JAVA)) {
            return SymbolKind.Class;
        }
        if (PsiUtils.instanceOf(element, FUNCTION_CLASS_NAME_JAVA)) {
            return SymbolKind.Method;
        }
        if (PsiUtils.instanceOf(element, FIELD_CLASS_NAME_JAVA)) {
            return SymbolKind.Field;
        }
        if (PsiUtils.instanceOf(element, VARIABLE_CLASS_NAME_JAVA)) {
            return SymbolKind.Variable;
        }
        return null;
    }

    @Override
    public PsiElement resolveNameIdentifier(PsiElement element) {
        if (PsiUtils.instanceOf(element, CLASS_NAME_JAVA)) {
            return PsiUtils.getNameIdentifierFromClass(element);
        }
        if (PsiUtils.instanceOf(element, FUNCTION_CLASS_NAME_JAVA)) {
            return PsiUtils.getNameIdentifierFromClass(element);
        }
        return null;
    }

    @Override
    public String resolveName(PsiElement element) {
        if (PsiUtils.instanceOf(element, NAMED_CLASS_NAME_JAVA)) {
            return PsiUtils.getName(element, NAMED_CLASS_NAME_JAVA);
        }
        return "Unnamed";
    }
}

