/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util.resolver;

import com.intellij.psi.PsiElement;
import com.tencent.code.intel.apibridge.util.resolver.SymbolResolver;
import com.tencent.code.intel.util.PsiUtils;
import org.eclipse.lsp4j.SymbolKind;

public class JSSymbolResolver
implements SymbolResolver {
    private static final String CLASS_NAME_JS = "com.intellij.lang.javascript.psi.JSClass";
    private static final String FUNCTION_CLASS_NAME_JS = "com.intellij.lang.javascript.psi.JSFunction";
    private static final String FIELD_CLASS_NAME_JS = "com.intellij.lang.javascript.psi.JSProperty";
    private static final String VARIABLE_CLASS_NAME_JS = "com.intellij.lang.javascript.psi.JSVariable";
    private static final String CLASS_NAME_TS = "com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassImpl";
    private static final String FUNCTION_CLASS_NAME_TS = "com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionImpl";
    private static final String FIELD_CLASS_NAME_TS = "com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptPropertyImpl";
    private static final String VARIABLE_CLASS_NAME_TS = "com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptVariableImpl";

    @Override
    public SymbolKind resolveSymbolKind(PsiElement element) {
        if (PsiUtils.instanceOf(element, CLASS_NAME_TS, CLASS_NAME_JS)) {
            return SymbolKind.Class;
        }
        if (PsiUtils.instanceOf(element, FUNCTION_CLASS_NAME_TS, FUNCTION_CLASS_NAME_JS)) {
            return SymbolKind.Method;
        }
        if (PsiUtils.instanceOf(element, FIELD_CLASS_NAME_TS, FIELD_CLASS_NAME_JS)) {
            return SymbolKind.Field;
        }
        if (PsiUtils.instanceOf(element, VARIABLE_CLASS_NAME_TS, VARIABLE_CLASS_NAME_JS)) {
            return SymbolKind.Variable;
        }
        return null;
    }

    @Override
    public PsiElement resolveNameIdentifier(PsiElement element) {
        if (PsiUtils.instanceOf(element, CLASS_NAME_TS, CLASS_NAME_JS)) {
            return PsiUtils.getNameIdentifierFromClass(element);
        }
        if (PsiUtils.instanceOf(element, FUNCTION_CLASS_NAME_TS, FUNCTION_CLASS_NAME_JS)) {
            return PsiUtils.getNameIdentifierFromClass(element);
        }
        return null;
    }

    @Override
    public String resolveName(PsiElement element) {
        String[] CLASS_NAMES;
        for (String className : CLASS_NAMES = new String[]{CLASS_NAME_TS, CLASS_NAME_JS, FUNCTION_CLASS_NAME_TS, FUNCTION_CLASS_NAME_JS, FIELD_CLASS_NAME_TS, FIELD_CLASS_NAME_JS, VARIABLE_CLASS_NAME_TS, VARIABLE_CLASS_NAME_JS}) {
            if (!PsiUtils.instanceOf(element, className)) continue;
            return PsiUtils.getName(element, className);
        }
        return "Unnamed";
    }
}

