/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.util.resolver;

import com.intellij.psi.PsiElement;
import com.tencent.code.intel.apibridge.util.resolver.SymbolResolver;
import com.tencent.code.intel.util.PsiUtils;
import org.eclipse.lsp4j.SymbolKind;

public class PythonSymbolResolver
implements SymbolResolver {
    private static final String CLASS_NAME_PYTHON = "com.jetbrains.python.psi.PyClass";
    private static final String FUNCTION_CLASS_NAME_PYTHON = "com.jetbrains.python.psi.PyFunction";
    private static final String FIELD_CLASS_NAME_PYTHON = "com.jetbrains.python.psi.PyTargetExpression";
    private static final String VARIABLE_CLASS_NAME_PYTHON = "com.jetbrains.python.psi.PyTargetExpression";
    private static final String VARIABLE_CLASS_NAME_PYTHON_ASSIGNMENT = "com.jetbrains.python.psi.PyAssignmentStatement";
    private static final String NAMED_CLASS_NAME_PYTHON = "com.jetbrains.python.psi.PyNamedElement";

    @Override
    public SymbolKind resolveSymbolKind(PsiElement element) {
        if (PsiUtils.instanceOf(element, CLASS_NAME_PYTHON)) {
            return SymbolKind.Class;
        }
        if (PsiUtils.instanceOf(element, FUNCTION_CLASS_NAME_PYTHON)) {
            return SymbolKind.Method;
        }
        if (PsiUtils.instanceOf(element, "com.jetbrains.python.psi.PyTargetExpression")) {
            return SymbolKind.Field;
        }
        if (PsiUtils.instanceOf(element, "com.jetbrains.python.psi.PyTargetExpression", VARIABLE_CLASS_NAME_PYTHON_ASSIGNMENT)) {
            return SymbolKind.Variable;
        }
        return null;
    }

    @Override
    public PsiElement resolveNameIdentifier(PsiElement element) {
        if (PsiUtils.instanceOf(element, CLASS_NAME_PYTHON)) {
            return PsiUtils.getNameIdentifierFromClass(element);
        }
        if (PsiUtils.instanceOf(element, FUNCTION_CLASS_NAME_PYTHON)) {
            return PsiUtils.getNameIdentifierFromClass(element);
        }
        return null;
    }

    @Override
    public String resolveName(PsiElement element) {
        if (PsiUtils.instanceOf(element, NAMED_CLASS_NAME_PYTHON)) {
            return PsiUtils.getName(element, NAMED_CLASS_NAME_PYTHON);
        }
        return "Unnamed";
    }
}

