/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.bean.item;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.tencent.code.intel.bean.BaseBean;
import com.tencent.code.intel.manager.LogManager;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;

public class VirtualFileUriBean
extends BaseBean {
    private String uri;

    public static VirtualFileUriBean from(@NotNull VirtualFile file) {
        String uri;
        if (file == null) {
            VirtualFileUriBean.$$$reportNull$$$0(0);
        }
        try {
            String path = file.getPath();
            String prefix = VirtualFileUriBean.isNeedsPathPrefix(file.getFileSystem()) && !path.startsWith("/") ? "/" : "";
            String authority = "";
            String processedPath = VirtualFileUriBean.processPath(file.getPath());
            int firstSlash = processedPath.indexOf(47);
            if (path.startsWith("//")) {
                if (firstSlash == -1) {
                    authority = processedPath;
                    processedPath = "";
                } else {
                    authority = processedPath.substring(0, firstSlash);
                    processedPath = processedPath.substring(firstSlash);
                }
            }
            uri = new URI(file.getFileSystem().getProtocol(), authority, prefix + processedPath, null, null).toString();
        }
        catch (URISyntaxException e) {
            LogManager.info(VirtualFileUriBean.class, "VirtualFileUriBean e:" + e.toString());
            uri = VirtualFileUriBean.asPrefixedUri(file.getUrl());
        }
        return new VirtualFileUriBean(uri);
    }

    @NotNull
    public static VirtualFileUriBean from(@NotNull VirtualFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            VirtualFileUriBean.$$$reportNull$$$0(1);
        }
        if (path == null) {
            VirtualFileUriBean.$$$reportNull$$$0(2);
        }
        String prefix = VirtualFileUriBean.isNeedsPathPrefix(fileSystem) && !path.startsWith("/") ? "/" : "";
        String processedPath = VirtualFileUriBean.processPath(path);
        return new VirtualFileUriBean(VirtualFileManager.constructUrl((String)fileSystem.getProtocol(), (String)(prefix + processedPath)));
    }

    public static String processPath(@NotNull String path) {
        if (path == null) {
            VirtualFileUriBean.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isWindows && path.startsWith("//")) {
            return path.replaceAll("^//", "");
        }
        return path;
    }

    private static boolean isNeedsPathPrefix(@NotNull VirtualFileSystem fileSystem) {
        if (fileSystem == null) {
            VirtualFileUriBean.$$$reportNull$$$0(4);
        }
        return SystemInfo.isWindows && fileSystem instanceof LocalFileSystem && !"temp".equals(fileSystem.getProtocol());
    }

    @NotNull
    static String asPrefixedUri(@NotNull String url) {
        if (url == null) {
            VirtualFileUriBean.$$$reportNull$$$0(5);
        }
        if (SystemInfo.isWindows) {
            if (url.startsWith("file:////")) {
                String string = "file://" + url.substring("file:////".length()).replace("$", "%24");
                if (string == null) {
                    VirtualFileUriBean.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (url.startsWith("file://") && !url.startsWith("file:///")) {
                String string = "file:///" + url.substring("file://".length());
                if (string == null) {
                    VirtualFileUriBean.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        String string = url;
        if (string == null) {
            VirtualFileUriBean.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return "VirtualFileUriBean(uri=" + this.getUri() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualFileUriBean)) {
            return false;
        }
        VirtualFileUriBean other = (VirtualFileUriBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VirtualFileUriBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }

    public VirtualFileUriBean() {
    }

    public VirtualFileUriBean(String uri) {
        this.uri = uri;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/tencent/code/intel/bean/item/VirtualFileUriBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/tencent/code/intel/bean/item/VirtualFileUriBean";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asPrefixedUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNeedsPathPrefix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asPrefixedUri";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

