/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.filter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class GitIgnoreFileFilter {
    private static final String GLOB_PATTERN = "glob:";
    private static final String NEGATIVE_PATTERN = "!";
    private static final String COMMENT = "#";
    private static final String EMPTY = "";
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private final List<Pattern> negativePatterns = new ArrayList<Pattern>();
    private final List<String> INVALID_INDEX_DIR = Arrays.asList(".git", ".idea", ".m2", "node_modules", ".svn", "venv", ".venv", ".virtualenvs");
    private final List<String> INVALID_INDEX_ROOT_DIR = Arrays.asList("target", "build", "dist", "out", "bin", "lib", "libs", "lib_ext");

    public GitIgnoreFileFilter(String content) {
        String[] lines;
        for (String line : lines = content.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith(COMMENT)) continue;
            if (line.startsWith(NEGATIVE_PATTERN)) {
                String pattern = line.substring(1);
                this.negativePatterns.add(this.compilePattern(pattern));
                continue;
            }
            this.patterns.add(this.compilePattern(line));
        }
    }

    public boolean accept(String path) {
        if (this.INVALID_INDEX_DIR.stream().anyMatch(path::contains)) {
            return false;
        }
        if (this.INVALID_INDEX_ROOT_DIR.contains(path)) {
            return false;
        }
        for (Pattern pattern : this.negativePatterns) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(path).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean accept(Project project, VirtualFile file) {
        String path = file.getPath();
        if (this.INVALID_INDEX_DIR.stream().anyMatch(path::contains)) {
            return false;
        }
        if (this.INVALID_INDEX_ROOT_DIR.contains(path)) {
            return false;
        }
        return !this.isIgnoredByGit(project, file);
    }

    private boolean isIgnoredByGit(Project project, VirtualFile file) {
        FileStatusManager statusManager = FileStatusManager.getInstance((Project)project);
        return statusManager.getStatus(file) == FileStatus.IGNORED;
    }

    private Pattern compilePattern(String pattern) {
        pattern = ((String)pattern).replace("/", "\\/");
        if (((String)(pattern = ((String)(pattern = ((String)pattern).replace(".", "\\.").replace("*", ".*").replace("?", "."))).startsWith("\\/") ? "^" + (String)pattern : ".*" + (String)pattern)).endsWith("\\/")) {
            pattern = (String)pattern + ".*";
        }
        return Pattern.compile((String)pattern);
    }
}

