/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.handle;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.tencent.code.intel.apibridge.Decoration.DecorationService;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.CopilotEditorUtils;
import org.jetbrains.annotations.Nullable;

public class CodeEscapeHandler
extends EditorActionHandler {
    public static final String ACTION_ID = "EditorEscape";
    private EditorActionHandler originalEscHandler;

    public CodeEscapeHandler(EditorActionHandler myOriginalHandler) {
        this.originalEscHandler = myOriginalHandler;
    }

    public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        LogManager.info(((Object)((Object)this)).getClass(), "handle--esc");
        InlayService.getInstance().disposeAllInlays();
        ExtHostLanguageFeatures.clear(editor.getProject());
        DecorationService.getInstance(editor.getProject()).disposeAll();
        CopilotEditorUtils.hideInlayHintsSink(editor);
        if (this.originalEscHandler.isEnabled(editor, caret, dataContext)) {
            this.originalEscHandler.execute(editor, caret, dataContext);
        }
    }

    public boolean isEnabledForCaret(Editor editor, Caret caret, DataContext dataContext) {
        if (!CollectionUtils.isEmpty(InlayService.getInstance().getAllInlays()) || !CopilotEditorUtils.isInlayHintsSinkEmpty(editor)) {
            return true;
        }
        return this.originalEscHandler.isEnabled(editor, caret, dataContext);
    }
}

