/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.handle;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.common.EditorCommandName;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeUserInputHandler
extends TypedHandlerDelegate
implements CopyPastePreProcessor {
    private static final Key<Long> USER_INPUT_KEY = Key.create((String)"gf_copilot.user.input");
    private static final Long IGNORE_VALUE = 10001L;

    public static void insertGlobal(Project project, String text) {
        ThreadManager.getInstance().runUiThreadSave(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)EditorCommandName.TRIGGER_COMPLETION.ACCEPT_CHAT.getName(), (String)"", () -> {
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null && !editor.isDisposed()) {
                int offset = editor.getCaretModel().getOffset();
                Document document = editor.getDocument();
                document.insertString(offset, (CharSequence)text);
            }
        }, (PsiFile[])new PsiFile[0]));
    }

    @Deprecated
    public static void insertString(boolean valid, PsiFile file, Document document, int offset, @NonNls @NotNull CharSequence s) {
        if (s == null) {
            CodeUserInputHandler.$$$reportNull$$$0(0);
        }
        if (TextUtils.isEmpty((CharSequence)s)) {
            return;
        }
        LogManager.info(CodeUserInputHandler.class, "\u63d2\u5165\u6570\u636e\uff1a" + String.valueOf(s));
        try {
            if (valid) {
                CodeUserInputHandler.validUserInput(file);
            } else {
                CodeUserInputHandler.setSerInput(file, IGNORE_VALUE);
            }
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CodeUserInputHandler.class, "insertString,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            document.insertString(offset, s);
        }
        catch (Exception e) {
            LogManager.warn(CodeUserInputHandler.class, "insertString-\u63d2\u5165\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Deprecated
    public static void replaceString(boolean isValid, PsiFile file, Document document, int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            CodeUserInputHandler.$$$reportNull$$$0(1);
        }
        LogManager.info(CodeUserInputHandler.class, "\u66ff\u6362\u6570\u636e\uff1a" + String.valueOf(s));
        if (isValid) {
            CodeUserInputHandler.validUserInput(file);
        } else {
            CodeUserInputHandler.setSerInput(file, IGNORE_VALUE);
        }
        document.replaceString(startOffset, endOffset, s);
    }

    @Deprecated
    public static void deleteString(boolean valid, PsiFile file, Document document, int startOffset, int endOffset) {
        LogManager.info(CodeUserInputHandler.class, "\u5220\u9664\u6570\u636e\uff1a" + startOffset + "-" + endOffset);
        if (valid) {
            CodeUserInputHandler.validUserInput(file);
        } else {
            CodeUserInputHandler.setSerInput(file, IGNORE_VALUE);
        }
        document.deleteString(startOffset, endOffset);
    }

    public static boolean isIgnoreChange(PsiFile file) {
        if (file == null) {
            return false;
        }
        Long lastUserInputTime = (Long)USER_INPUT_KEY.get((UserDataHolder)file);
        if (lastUserInputTime == null) {
            return false;
        }
        return lastUserInputTime.equals(IGNORE_VALUE);
    }

    public static boolean isValidInput(PsiFile file, DocumentEvent event) {
        if (file == null) {
            return false;
        }
        Long lastUserInputTime = (Long)USER_INPUT_KEY.get((UserDataHolder)file);
        if (lastUserInputTime == null) {
            if (event != null) {
                boolean isTabOrEnter;
                if (event.getNewLength() > 0 && event.getOldLength() == 0 && !TextUtils.isEmpty((CharSequence)event.getNewFragment().toString()) && (isTabOrEnter = event.getNewFragment().toString().trim().matches("[\t\n]*"))) {
                    return true;
                }
                return event.getNewLength() == 0 && event.getOldLength() > 0;
            }
        } else {
            USER_INPUT_KEY.set((UserDataHolder)file, null);
            if (lastUserInputTime.equals(IGNORE_VALUE)) {
                return false;
            }
            return System.currentTimeMillis() - lastUserInputTime <= 1000L;
        }
        return false;
    }

    public static void validUserInput(PsiFile psiFile) {
        CodeUserInputHandler.setSerInput(psiFile, System.currentTimeMillis());
    }

    public static void setSerInput(PsiFile psiFile, Long currentTimestamp) {
        if (psiFile != null) {
            USER_INPUT_KEY.set((UserDataHolder)psiFile, (Object)currentTimestamp);
        }
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            CodeUserInputHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CodeUserInputHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CodeUserInputHandler.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            CodeUserInputHandler.$$$reportNull$$$0(5);
        }
        CodeUserInputHandler.validUserInput(file);
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            CodeUserInputHandler.$$$reportNull$$$0(6);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            CodeUserInputHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            CodeUserInputHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CodeUserInputHandler.$$$reportNull$$$0(9);
        }
        TypedHandlerDelegate.Result result = super.charTyped(c, project, editor, file);
        if (result == null) {
            CodeUserInputHandler.$$$reportNull$$$0(10);
        }
        return result;
    }

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        CodeUserInputHandler.validUserInput(file);
        return text;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        CodeUserInputHandler.validUserInput(file);
        String string = text;
        if (string == null) {
            CodeUserInputHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/tencent/code/intel/handle/CodeUserInputHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/tencent/code/intel/handle/CodeUserInputHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

