/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.handle;

import com.tencent.code.intel.manager.LogManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class CustomProxySelector
extends ProxySelector {
    private Proxy customProxy;

    public CustomProxySelector(String proxyAddress) {
        try {
            URI proxyUri = new URI(proxyAddress);
            this.customProxy = new Proxy(this.getProxyType(proxyAddress), new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort()));
        }
        catch (Exception e) {
            this.customProxy = null;
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (this.customProxy == null) {
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        return Collections.singletonList(this.customProxy);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        LogManager.warn(CustomProxySelector.class, "Failed to connect to proxy," + ioe.toString() + "uri: " + uri.toString() + "sa: " + sa.toString());
    }

    public Proxy.Type getProxyType(String proxyUrl) {
        if (proxyUrl.startsWith("http://") || proxyUrl.startsWith("https://")) {
            return Proxy.Type.HTTP;
        }
        if (proxyUrl.startsWith("socks4://") || proxyUrl.startsWith("socks5://") || proxyUrl.startsWith("socks5h://")) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.DIRECT;
    }

    public Proxy getCustomProxy() {
        return this.customProxy;
    }
}

