/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.bean.item.CodeReviewComment;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.renderer.CodeReviewCommentGutterIconRenderer;
import com.tencent.code.intel.ui.cr.CommentInLayPanel;
import com.tencent.code.intel.ui.sidebar.conversation.chat.store.AICRCommentsPersistState;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.CopilotEditorUtils;
import java.util.List;
import java.util.Map;

@Service
public final class CodeReviewCommentInLayService
implements Disposable {
    public static CodeReviewCommentInLayService getInstance() {
        return (CodeReviewCommentInLayService)ApplicationManager.getApplication().getService(CodeReviewCommentInLayService.class);
    }

    public void addGutterAndInlayForComments(Map<String, List<CodeReviewComment>> allComments) {
        Editor[] openEditors = EditorFactory.getInstance().getAllEditors();
        for (Map.Entry<String, List<CodeReviewComment>> entry : allComments.entrySet()) {
            for (Editor editor : openEditors) {
                VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
                if (file == null || !file.getUrl().equals(entry.getKey())) continue;
                this.initGutterAndOpenInlay(entry.getValue(), editor, CollectionUtils.isNotEmpty(entry.getValue()) ? entry.getValue().get(0) : null);
            }
        }
    }

    public void initGutterAndOpenInlay(List<CodeReviewComment> comments, Editor editor, CodeReviewComment needOpenComment) {
        for (CodeReviewComment comment : comments) {
            if (comment.getGutterIconRendererHighlighter() != null) continue;
            this.addGutter(comment, editor);
        }
        if (needOpenComment != null) {
            this.toggleCommentInlay(needOpenComment, editor);
            CopilotEditorUtils.jumpToEditorLine(editor, needOpenComment.getResult().getEndLine());
        }
    }

    public void toggleCommentInlay(CodeReviewComment comment, Editor editor) {
        if (comment.getCommentInlay() == null) {
            this.addCommentInlay(comment, editor);
        }
        comment.getCommentInlay().setShowInlay(true);
        comment.getCommentInlay().showInlay();
    }

    public void addCommentInlay(CodeReviewComment comment, Editor editor) {
        if (comment == null) {
            return;
        }
        CommentInLayPanel commentInLay = new CommentInLayPanel(editor, comment);
        if (comment.getCommentInlay() != null) {
            commentInLay.setShowInlay(comment.getCommentInlay().isShowInlay());
        }
        Document document = editor.getDocument();
        int lineCount = document.getLineCount();
        int displayLine = comment.getResult().getStartLine();
        if (displayLine < 0 || displayLine > lineCount) {
            LogManager.warn(CodeReviewCommentInLayService.class, "Invalid line number: " + displayLine);
            return;
        }
        commentInLay.createInlay(document.getLineStartOffset(displayLine));
        editor.getContentComponent().add(commentInLay);
        comment.setCommentInlay(commentInLay);
        comment.setEditor(editor);
    }

    public void addGutter(CodeReviewComment comment, Editor editor) {
        if (comment == null) {
            return;
        }
        int displayLine = comment.getResult().getStartLine();
        CodeReviewCommentGutterIconRenderer commentGutterIconGutter = new CodeReviewCommentGutterIconRenderer(displayLine, () -> {
            if (comment.getCommentInlay() == null) {
                this.addCommentInlay(comment, editor);
            }
            comment.getCommentInlay().toggleVisibility();
        });
        MarkupModel markupModel = editor.getMarkupModel();
        RangeHighlighter highlighter = markupModel.addLineHighlighter(null, displayLine, 0);
        highlighter.setGutterIconRenderer((GutterIconRenderer)commentGutterIconGutter);
        comment.setGutterIconRendererHighlighter(highlighter);
        comment.setEditor(editor);
    }

    public void navigateToNext(CodeReviewComment comment) {
        this.navigateToComment(comment, AICRCommentsPersistState.getInstance().getNextComment(comment.getId()));
    }

    public void navigateToPrevious(CodeReviewComment comment) {
        this.navigateToComment(comment, AICRCommentsPersistState.getInstance().getPreviousComment(comment.getId()));
    }

    private void navigateToComment(CodeReviewComment comment, CodeReviewComment targetComment) {
        VirtualFile file;
        Editor curEditor = comment.getEditor();
        CommentInLayPanel commentInLay = comment.getCommentInlay();
        if (commentInLay == null || curEditor == null) {
            return;
        }
        Editor nextEditor = targetComment.getEditor();
        CommentInLayPanel nextCommentInLay = targetComment.getCommentInlay();
        if (nextEditor == null) {
            return;
        }
        if (nextCommentInLay == null) {
            this.addCommentInlay(targetComment, nextEditor);
            nextCommentInLay = targetComment.getCommentInlay();
        }
        Project project = curEditor.getProject();
        if (curEditor != nextEditor && project != null && (file = FileDocumentManager.getInstance().getFile(nextEditor.getDocument())) != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditor[] openEditors = fileEditorManager.getEditors(file);
            if (openEditors.length > 0) {
                fileEditorManager.openFile(file, true, true);
            } else {
                fileEditorManager.openFile(file, true);
            }
        }
        int targetOffset = nextCommentInLay.getInlay().getOffset();
        if (!nextCommentInLay.isShowInlay()) {
            nextCommentInLay.toggleVisibility();
        }
        nextEditor.getScrollingModel().scrollTo(nextEditor.offsetToLogicalPosition(targetOffset), ScrollType.CENTER);
        nextCommentInLay.requestFocusInWindow();
    }

    public void removeEditorAllCommentInlays(Editor editor) {
        Map<String, List<CodeReviewComment>> filePathMap = AICRCommentsPersistState.getInstance().getAllFilePathMap();
        for (List<CodeReviewComment> comments : filePathMap.values()) {
            for (CodeReviewComment comment : comments) {
                if (!editor.equals(comment.getEditor())) continue;
                this.removeCommentInlay(editor, comment);
            }
        }
    }

    public void removeCommentInlay(Editor editor, CodeReviewComment comment) {
        CommentInLayPanel commentInlay = comment.getCommentInlay();
        if (commentInlay == null) {
            return;
        }
        Inlay<?> inlay = commentInlay.getInlay();
        if (inlay != null) {
            inlay.dispose();
        }
        commentInlay.setInlay(null);
        editor.getContentComponent().remove(commentInlay);
        editor.getComponent().revalidate();
        editor.getComponent().repaint();
        editor.getContentComponent().revalidate();
        editor.getContentComponent().repaint();
    }

    public void removeAllCommentInlays() {
        Map<String, List<CodeReviewComment>> filePathMap = AICRCommentsPersistState.getInstance().getAllFilePathMap();
        for (List<CodeReviewComment> comments : filePathMap.values()) {
            for (CodeReviewComment comment : comments) {
                this.removeCommentInlay(comment.getEditor(), comment);
            }
        }
    }

    public void dispose() {
        this.removeAllCommentInlays();
    }

    public void onEditorCreated(Editor editor) {
        try {
            PsiFile psiFile = CopilotEditorUtils.getPsiFile(editor);
            if (psiFile == null) {
                return;
            }
            if (psiFile.getVirtualFile() == null) {
                return;
            }
            String filePath = psiFile.getVirtualFile().getUrl();
            List<CodeReviewComment> comments = AICRCommentsPersistState.getInstance().getCommentsByFilePath(filePath);
            for (CodeReviewComment comment2 : comments) {
                if (comment2.getCommentInlay() != null) {
                    this.addCommentInlay(comment2, editor);
                    comment2.getCommentInlay().showInlay();
                }
                if (comment2.getGutterIconRendererHighlighter() == null) continue;
                this.addGutter(comment2, editor);
            }
            boolean allGutterIsNoInitial = comments.stream().noneMatch(comment -> comment.getGutterIconRendererHighlighter() != null);
            if (allGutterIsNoInitial) {
                this.initGutterAndOpenInlay(comments, editor, CollectionUtils.isNotEmpty(comments) ? comments.get(0) : null);
            }
        }
        catch (Exception e) {
            LogManager.warn(CodeReviewCommentInLayService.class, "Exception while creating inlays: " + e.getMessage());
        }
    }

    public void onEditorReleased(Editor editor) {
    }

    public void ignoreAllComments() {
        this.removeAllCommentInlays();
        this.removeAllGutter();
    }

    private void removeAllGutter() {
        Map<String, List<CodeReviewComment>> filePathMap = AICRCommentsPersistState.getInstance().getAllFilePathMap();
        for (List<CodeReviewComment> comments : filePathMap.values()) {
            for (CodeReviewComment comment : comments) {
                this.removeGutter(comment.getEditor(), comment);
            }
        }
    }

    public void removeGutter(Editor editor, CodeReviewComment comment) {
        if (comment == null || editor == null) {
            return;
        }
        if (comment.getGutterIconRendererHighlighter() != null) {
            MarkupModel markupModel = editor.getMarkupModel();
            markupModel.removeHighlighter(comment.getGutterIconRendererHighlighter());
            comment.setGutterIconRendererHighlighter(null);
        }
    }
}

