/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.impl;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.tencent.code.intel.api.ICopilotSettingsService;
import com.tencent.code.intel.apibridge.configuration.SettingService;
import com.tencent.code.intel.common.CodeStyle;
import com.tencent.code.intel.common.Language;
import com.tencent.code.intel.common.PluginInfo;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CopilotSettingsServiceImpl", storages={@Storage(value="CopilotSettingsService.xml")})
public class CopilotSettingsService
implements ICopilotSettingsService,
PersistentStateComponent<CopilotSettingsService> {
    private boolean login = false;
    private boolean activate = true;
    private boolean isFirstInstall = true;
    private boolean openGenerateFunction = true;
    private boolean showFullLineNotification = true;
    private boolean isTabOverTimes = false;
    private boolean showInlayTool = true;
    private boolean isInlayTip = true;
    private boolean isInlineChat = true;
    private boolean isInlinePopup = true;
    private boolean deviceOauthEnable = false;
    private boolean isNextEditSuggestionEnable = true;
    private List<String> chatMessages;
    private String updateVersion;
    private long ignoreBeforeUpdateTime;
    private boolean isFuncTips = false;
    private boolean sideBySideEnable = true;
    private boolean preferInlineCompletionEnable = true;
    private boolean c2cEnable = true;
    private boolean smartAdaptiveCompletionSpeed = true;
    private boolean isLoginSSO = false;
    private String codeStyle = DEFAULT_CODE_STYLE;
    private static final String DEFAULT_CODE_STYLE = CodeStyle.MODERATE.getName();
    private static final String GENERATION_PREFERENCE_ONE_LINE_MODE = "oneLineMode";
    private static final String GENERATION_PREFERENCE_INTELLIGENT_MODE = "intelligentMode";
    private String chatModelOutputLanguage = Language.Chinese.getName();
    private String chatModelDocumentLanguage = Language.Chinese.getName();
    private static volatile ICopilotSettingsService singleton;
    @MapAnnotation(keyAttributeName="userId", valueAttributeName="privacyEnable")
    private Map<String, Boolean> userSetPrivacyResult = new HashMap<String, Boolean>();
    @MapAnnotation(keyAttributeName="languageId", valueAttributeName="languageIdEnable")
    private HashMap<String, Boolean> disabledLanguages = new HashMap();
    private List<String> onceLoggedUsers = new ArrayList<String>();
    private String customEndpoint;
    private String commitMessageStyle;
    private String commitMessageLanguage;
    private Boolean commitMessageTAPDEnable;
    private String networkProxyType;
    private String networkProxyAddress;
    private String envEndpoint = "";
    private String envRouteMode = "production";
    private String envRouteCustom = "";
    private boolean enableCodeIndexingForCompletion;
    private List<String> enableCodeIndexingWorkspaceFolder = new ArrayList<String>();
    @Property
    private Map<String, String> updateVersionInfo = new HashMap<String, String>();
    private String selectedCompletionModel = "";
    private boolean enableWorkspaceRules;
    private boolean enableClientProductPriority;
    private boolean autoRun;
    private boolean taskList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICopilotSettingsService getInstance() {
        try {
            if (singleton != null) return singleton;
            Class<ICopilotSettingsService> clazz = ICopilotSettingsService.class;
            synchronized (ICopilotSettingsService.class) {
                if (singleton != null) return singleton;
                singleton = (ICopilotSettingsService)ApplicationManager.getApplication().getService(ICopilotSettingsService.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
        }
        catch (Exception e) {
            LogManager.warn(ICopilotSettingsService.class, e.toString());
        }
        return singleton;
    }

    @Nullable
    public CopilotSettingsService getState() {
        return this;
    }

    public void loadState(@NotNull CopilotSettingsService copilotState) {
        if (copilotState == null) {
            CopilotSettingsService.$$$reportNull$$$0(0);
        }
        LogManager.info(CopilotSettingsService.class, "copilotState");
        XmlSerializerUtil.copyBean((Object)copilotState, (Object)this);
    }

    @Override
    public boolean isLogin() {
        return this.login;
    }

    @Override
    public void setLogin(boolean login) {
        this.login = login;
    }

    @Override
    public boolean isActivate() {
        return this.activate;
    }

    @Override
    public void setActivate(boolean activate) {
        this.activate = activate;
        SettingService.getInstance().updateSetting("enableAutoCompletions");
    }

    @Override
    public boolean isFirstInstall() {
        return this.isFirstInstall;
    }

    @Override
    public void setFirstInstall(boolean firstInstall) {
        this.isFirstInstall = firstInstall;
    }

    @Override
    public boolean isOpenGenerateFunction() {
        return this.openGenerateFunction;
    }

    @Override
    public void setOpenGenerateFunction(boolean openGenerateFunction) {
        this.openGenerateFunction = openGenerateFunction;
    }

    @Override
    public void setChatMessages(List<String> chatMessages) {
        this.chatMessages = chatMessages;
    }

    @Override
    public List<String> getChatMessages() {
        return this.chatMessages;
    }

    @Override
    public String getUpdateVersion() {
        if (!this.updateVersionInfo.isEmpty()) {
            if (PluginInfo.PLUGIN_ID.equals(this.updateVersionInfo.get("pluginId"))) {
                return this.updateVersionInfo.get("version");
            }
            return "";
        }
        return this.updateVersion;
    }

    @Override
    public void setUpdateVersion(String version) {
        this.updateVersionInfo.put("version", version);
        this.updateVersionInfo.put("pluginId", PluginInfo.PLUGIN_ID);
    }

    @Override
    public long getIgnoreBeforeUpdateTime() {
        return this.ignoreBeforeUpdateTime;
    }

    @Override
    public void setIgnoreBeforeUpdateTime(long ignoreBeforeUpdateTime) {
        this.ignoreBeforeUpdateTime = ignoreBeforeUpdateTime;
    }

    @Override
    public Boolean getUserSetPrivacyResult(String userId) {
        return this.userSetPrivacyResult.get(userId);
    }

    @Override
    public void setUserSetPrivacyResult(String userId, boolean privacyEnable) {
        this.userSetPrivacyResult.put(userId, privacyEnable);
    }

    @Override
    public HashMap<String, Boolean> getDisabledLanguages() {
        return this.disabledLanguages;
    }

    @Override
    public void setDisabledLanguages(HashMap<String, Boolean> disabledLanguages) {
        this.disabledLanguages = disabledLanguages;
        SettingService.getInstance().updateSetting("enableCompletionLanguage");
    }

    @Override
    public boolean isOnceLoggedUser(String userId) {
        return this.onceLoggedUsers.contains(userId);
    }

    @Override
    public void setUserLogged(String userId) {
        if (!this.onceLoggedUsers.contains(userId)) {
            this.onceLoggedUsers.add(userId);
        }
    }

    @Override
    public boolean isShowFullLineNotification() {
        return this.showFullLineNotification;
    }

    @Override
    public void setShowFullLineNotification(boolean showFullLineNotification) {
        this.showFullLineNotification = showFullLineNotification;
    }

    @Override
    public boolean isSideBySideEnable() {
        return this.sideBySideEnable;
    }

    @Override
    public boolean isPreferInlineCompletionEnable() {
        return this.preferInlineCompletionEnable;
    }

    @Override
    public void setPreferInlineCompletionEnable(boolean preferInlineCompletionEnable) {
        this.preferInlineCompletionEnable = preferInlineCompletionEnable;
    }

    @Override
    public String getCodeStyle() {
        return this.codeStyle;
    }

    @Override
    public void setCodeStyle(String codeStyle) {
        this.codeStyle = codeStyle;
        SettingService.getInstance().updateSetting("generationPreference");
    }

    @Override
    public boolean isFuncTipsEnable() {
        return this.isFuncTips;
    }

    @Override
    public void setFuncTipsEnable(boolean isFuncTips) {
        this.isFuncTips = isFuncTips;
        SettingService.getInstance().updateSetting("enableCodelens");
    }

    @Override
    public boolean isLoginSSOEnable() {
        return this.isLoginSSO;
    }

    @Override
    public void setLoginSSOEnable(boolean isLoginSSO) {
        this.isLoginSSO = isLoginSSO;
    }

    @Override
    public void setSideBySideEnable(boolean sideBySideEnable) {
        this.sideBySideEnable = sideBySideEnable;
    }

    @Override
    public boolean isInlayTipEnable() {
        return this.isInlayTip;
    }

    @Override
    public void setInlayTipEnable(boolean inlayTipEnable) {
        this.isInlayTip = inlayTipEnable;
        SettingService.getInstance().updateSetting("enableCloseCompletionShortcutTip");
    }

    @Override
    public boolean isInlineChatEnable() {
        return this.isInlineChat;
    }

    @Override
    public void setInlineChatEnable(boolean inlineChatEnable) {
        this.isInlineChat = inlineChatEnable;
        SettingService.getInstance().updateSetting("enableInlineChat");
    }

    @Override
    public boolean isInlinePopupEnable() {
        return this.isInlinePopup;
    }

    @Override
    public void setInlinePopupEnable(boolean isInlinePopup) {
        this.isInlinePopup = isInlinePopup;
    }

    @Override
    public String getCustomEndpoint() {
        return this.customEndpoint;
    }

    @Override
    public void setCustomEndpoint(String customEndpoint) {
        this.customEndpoint = customEndpoint;
    }

    @Override
    public String getCommitMessageStyle() {
        return this.commitMessageStyle;
    }

    @Override
    public void setCommitMessageStyle(String commitMessageStyle) {
        this.commitMessageStyle = commitMessageStyle;
        SettingService.getInstance().updateSetting("commitMessageStyle");
    }

    @Override
    public String getCommitMessageLanguage() {
        return this.commitMessageLanguage;
    }

    @Override
    public void setCommitMessageLanguage(String commitMessageLanguage) {
        this.commitMessageLanguage = commitMessageLanguage;
        SettingService.getInstance().updateSetting("commitMessageLanguage");
    }

    @Override
    public Boolean isCommitMessageTAPDEnable() {
        return this.commitMessageTAPDEnable;
    }

    @Override
    public void setCommitMessageTAPDEnable(Boolean enable) {
        this.commitMessageTAPDEnable = enable;
    }

    @Override
    public String getNetworkProxyType() {
        return this.networkProxyType;
    }

    @Override
    public void setNetworkProxyType(String proxyType) {
        this.networkProxyType = proxyType;
        SettingService.getInstance().updateSetting("httpProxySettings");
    }

    @Override
    public String getNetworkProxyAddress() {
        return this.networkProxyAddress;
    }

    @Override
    public void setNetworkProxyAddress(String proxyAddress) {
        this.networkProxyAddress = proxyAddress;
        SettingService.getInstance().updateSetting("httpProxyURL");
    }

    @Override
    public String getEnvEndpoint() {
        return this.envEndpoint;
    }

    @Override
    public void setEnvEndpoint(String envEndpoint) {
        this.envEndpoint = envEndpoint;
        SettingService.getInstance().updateSetting("endpoint");
    }

    @Override
    public String getEnvRouteMode() {
        return this.envRouteMode;
    }

    @Override
    public void setEnvRouteMode(String envRouteMode) {
        this.envRouteMode = envRouteMode;
        SettingService.getInstance().updateSetting("envRouteMode");
    }

    @Override
    public String getEnvRouteCustom() {
        return this.envRouteCustom;
    }

    @Override
    public void setEnvRouteCustom(String envRouteCustom) {
        this.envRouteCustom = envRouteCustom;
        SettingService.getInstance().updateSetting("envRouteCustom");
    }

    @Override
    public boolean isTabOverTimes() {
        return this.isTabOverTimes;
    }

    @Override
    public void setTabOverTimes(boolean overTimes) {
        this.isTabOverTimes = overTimes;
    }

    @Override
    public boolean isShowInlayTool() {
        return this.showInlayTool;
    }

    @Override
    public void setShowInlayTool(boolean showInlayTool) {
        this.showInlayTool = showInlayTool;
    }

    @Override
    public boolean isEnableCodeIndexingForCompletion() {
        return this.enableCodeIndexingForCompletion;
    }

    @Override
    public void setEnableCodeIndexingForCompletion(boolean enableCodeIndexingForCompletion) {
        this.enableCodeIndexingForCompletion = enableCodeIndexingForCompletion;
    }

    @Override
    public boolean isCodeIndexWorkspaceFolder(String workspaceFolder) {
        return this.enableCodeIndexingWorkspaceFolder.contains(workspaceFolder);
    }

    @Override
    public void setCodeIndexWorkspaceFolder(String workspaceFolder) {
        if (!this.enableCodeIndexingWorkspaceFolder.contains(workspaceFolder)) {
            this.enableCodeIndexingWorkspaceFolder.add(workspaceFolder);
        }
    }

    @Override
    public boolean isC2CEnable() {
        return this.c2cEnable;
    }

    @Override
    public void setC2CEnable(boolean c2cEnable) {
        this.c2cEnable = c2cEnable;
    }

    @Override
    public boolean isSmartAdaptiveCompletionSpeed() {
        return this.smartAdaptiveCompletionSpeed;
    }

    @Override
    public void setSmartAdaptiveCompletionSpeed(boolean smartAdaptiveCompletionSpeed) {
        this.smartAdaptiveCompletionSpeed = smartAdaptiveCompletionSpeed;
    }

    @Override
    public void reset() {
        this.enableCodeIndexingWorkspaceFolder.clear();
    }

    @Override
    public boolean isNextEditSuggestionEnable() {
        return this.isNextEditSuggestionEnable;
    }

    @Override
    public void setNextEditSuggestionEnable(boolean enable) {
        this.isNextEditSuggestionEnable = enable;
        SettingService.getInstance().updateSetting("enableNextEditSuggestions");
    }

    @Override
    public String getChatModelOutputLanguage() {
        return this.chatModelOutputLanguage;
    }

    @Override
    public void setChatModelOutputLanguage(String language) {
        this.chatModelOutputLanguage = language;
    }

    @Override
    public String getChatModelDocumentLanguage() {
        return this.chatModelDocumentLanguage;
    }

    @Override
    public void setChatModelDocumentLanguage(String language) {
        this.chatModelDocumentLanguage = language;
        SettingService.getInstance().updateSetting("modelDocumentLanguage");
    }

    @Override
    public void setSelectedCompletionModel(String selectedCompletionModel) {
        this.selectedCompletionModel = selectedCompletionModel;
        SettingService.getInstance().updateSetting("selectedCompletionModel");
    }

    @Override
    public String getSelectedCompletionModel() {
        return this.selectedCompletionModel;
    }

    @Override
    public boolean isEnableWorkspaceRules() {
        return this.enableWorkspaceRules;
    }

    @Override
    public void setEnableWorkspaceRules(boolean enable) {
        this.enableWorkspaceRules = enable;
        SettingService.getInstance().updateSetting("enableWorkspaceRules");
        ThreadManager.getInstance().runDelayUiThreadSave(3000, () -> VirtualFileManager.getInstance().syncRefresh());
    }

    @Override
    public boolean isEnableClientProductPriority() {
        return this.enableClientProductPriority;
    }

    @Override
    public void setEnableClientProductPriority(boolean enable) {
        this.enableClientProductPriority = enable;
        SettingService.getInstance().updateSetting("enableClientProductPriority");
    }

    @Override
    public boolean getAutoRun() {
        return this.autoRun;
    }

    @Override
    public void setAutoRun(boolean autoRun) {
        this.autoRun = autoRun;
        SettingService.getInstance().updateSetting("autoRun");
    }

    @Override
    public boolean getTaskList() {
        return this.taskList;
    }

    @Override
    public void setTaskList(boolean taskList) {
        this.taskList = taskList;
        SettingService.getInstance().updateSetting("taskList");
    }

    public String toString() {
        return "CopilotSettingsService{activate=" + this.activate + ", isFirstInstall=" + this.isFirstInstall + ", openGenerateFunction=" + this.openGenerateFunction + ", showFullLineNotification=" + this.showFullLineNotification + ", chatMessages=" + String.valueOf(this.chatMessages) + ", updateVersion='" + this.updateVersion + "', ignoreBeforeUpdateTime=" + this.ignoreBeforeUpdateTime + ", isFuncTips=" + this.isFuncTips + ", isLoginSSO=" + this.isLoginSSO + ", sideBySideEnable=" + this.sideBySideEnable + ", userSetPrivacyResult=" + String.valueOf(this.userSetPrivacyResult) + ", onceLoggedUsers=" + String.valueOf(this.onceLoggedUsers) + "}";
    }

    @Override
    public Object getValueForKey(String key) {
        switch (key) {
            case "enableAutoCompletions": {
                return this.activate;
            }
            case "enableNextEditSuggestions": {
                return this.isNextEditSuggestionEnable();
            }
            case "floatShortcut": {
                return null;
            }
            case "enableCompletionLanguage": {
                return JSONObject.from(this.getDisabledLanguages());
            }
            case "enableCloseCompletionShortcutTip": {
                return this.isInlayTipEnable();
            }
            case "generationPreference": {
                String currentCodeStyle = this.getCodeStyle();
                if (currentCodeStyle == null) {
                    currentCodeStyle = DEFAULT_CODE_STYLE;
                }
                if (CodeStyle.LINE.getName().equals(currentCodeStyle)) {
                    return GENERATION_PREFERENCE_ONE_LINE_MODE;
                }
                return GENERATION_PREFERENCE_INTELLIGENT_MODE;
            }
            case "enableInlineChat": {
                return this.isInlineChatEnable();
            }
            case "enableInlineChatAutoFormatCode": {
                return null;
            }
            case "enableCodelens": {
                return this.isFuncTipsEnable();
            }
            case "enableWorkspaceRules": {
                return this.isEnableWorkspaceRules();
            }
            case "modelDocumentLanguage": {
                return this.getChatModelDocumentLanguage() == null ? "zh-CN" : this.getChatModelDocumentLanguage();
            }
            case "commitMessageStyle": {
                String commitMessageStyle;
                switch (commitMessageStyle = this.getCommitMessageStyle() == null ? "default" : this.getCommitMessageStyle()) {
                    case "auto": {
                        return "Auto";
                    }
                    case "default": {
                        return "Default";
                    }
                    case "conventional": {
                        return "ConventionalCommits";
                    }
                }
                return "Default";
            }
            case "commitMessageLanguage": {
                return this.getCommitMessageLanguage() == null ? "zh-CN" : this.getCommitMessageLanguage();
            }
            case "httpProxySettings": {
                return this.getNetworkProxyType();
            }
            case "httpProxyURL": {
                return this.getNetworkProxyAddress() == null ? "" : this.getNetworkProxyAddress();
            }
            case "endpoint": {
                return this.getEnvEndpoint() == null ? "" : this.getEnvEndpoint();
            }
            case "envRouteMode": {
                return this.getEnvRouteMode() == null ? "production" : this.getEnvRouteMode();
            }
            case "envRouteCustom": {
                return this.getEnvRouteCustom() == null ? "" : this.getEnvRouteCustom();
            }
            case "selectedCompletionModel": {
                return this.getSelectedCompletionModel();
            }
            case "enableClientProductPriority": {
                return this.isEnableClientProductPriority();
            }
            case "autoRun": {
                return this.getAutoRun();
            }
            case "taskList": {
                return this.getTaskList();
            }
        }
        return null;
    }

    @Override
    public void updateKey(String key, Object value) {
        List<String> keys = List.of(key.split("\\."));
        block24 : switch (key = keys.isEmpty() ? "" : keys.get(keys.size() - 1)) {
            case "enableAutoCompletions": {
                this.setActivate((Boolean)value);
                break;
            }
            case "enableNextEditSuggestions": {
                this.setNextEditSuggestionEnable((Boolean)value);
                break;
            }
            case "floatShortcut": {
                break;
            }
            case "enableCompletionLanguage": {
                JSONObject json = JSONObject.from((Object)value);
                HashMap<String, Boolean> disabledLanguages = new HashMap<String, Boolean>();
                json.forEach((k, v) -> disabledLanguages.put((String)k, (Boolean)v));
                this.setDisabledLanguages(disabledLanguages);
                break;
            }
            case "enableCloseCompletionShortcutTip": {
                this.setInlayTipEnable((Boolean)value);
                break;
            }
            case "generationPreference": {
                String codeStyleValue = DEFAULT_CODE_STYLE;
                if (GENERATION_PREFERENCE_ONE_LINE_MODE.equals(value)) {
                    codeStyleValue = CodeStyle.LINE.getName();
                }
                this.setCodeStyle(codeStyleValue);
                break;
            }
            case "enableInlineChat": {
                this.setInlineChatEnable((Boolean)value);
                break;
            }
            case "enableInlineChatAutoFormatCode": {
                break;
            }
            case "enableCodelens": {
                this.setFuncTipsEnable((Boolean)value);
                break;
            }
            case "enableWorkspaceRules": {
                this.setEnableWorkspaceRules((Boolean)value);
                break;
            }
            case "modelDocumentLanguage": {
                this.setChatModelDocumentLanguage(value.toString());
                break;
            }
            case "CommitMessageStyle": {
                switch (value.toString()) {
                    case "Auto": {
                        this.setCommitMessageStyle("auto");
                        break block24;
                    }
                    case "Default": {
                        this.setCommitMessageStyle("default");
                        break block24;
                    }
                    case "ConventionalCommits": {
                        this.setCommitMessageStyle("conventional");
                        break block24;
                    }
                }
                this.setCommitMessageStyle("default");
                break;
            }
            case "commitMessageLanguage": {
                this.setCommitMessageLanguage(value.toString());
                break;
            }
            case "httpProxySettings": {
                this.setNetworkProxyType(value.toString());
                break;
            }
            case "httpProxyURL": {
                this.setNetworkProxyAddress(value.toString());
                break;
            }
            case "endpoint": {
                this.setEnvEndpoint(value.toString());
                break;
            }
            case "envRouteMode": {
                this.setEnvRouteMode(value.toString());
                break;
            }
            case "envRouteCustom": {
                this.setEnvRouteCustom(value.toString());
                break;
            }
            case "selectedCompletionModel": {
                this.setSelectedCompletionModel(value.toString());
                break;
            }
            case "enableClientProductPriority": {
                this.setEnableClientProductPriority((Boolean)value);
                break;
            }
            case "autoRun": {
                this.setAutoRun((Boolean)value);
                break;
            }
            case "taskList": {
                this.setTaskList((Boolean)value);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copilotState", "com/tencent/code/intel/impl/CopilotSettingsService", "loadState"));
    }
}

