/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.impl;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.api.IGFCopilotService;
import com.tencent.code.intel.apibridge.extension.mainthread.context.MainThreadContext;
import com.tencent.code.intel.common.EditorCommandName;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.CopilotEditorUtils;
import com.tencent.code.intel.util.PluginUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GFCopilotService
implements IGFCopilotService {
    private final AtomicInteger initialize = new AtomicInteger(0);
    private final AtomicBoolean copilotLoginState = new AtomicBoolean(false);
    private final AtomicBoolean copilotChatPermission = new AtomicBoolean(false);
    private static volatile IGFCopilotService singleton;
    private static final Key<DocumentListener> EDITOR_DOCUMENT_LISTENER;
    private static final Key<CaretListener> EDITOR_CARET_LISTENER;
    private static final Key<SelectionListener> EDITOR_SELECTION_LISTENER;
    private static final Key<Boolean> KEY_EDITOR_SUPPORTED;
    private Editor focusEditor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IGFCopilotService getInstance() {
        try {
            if (singleton != null) return singleton;
            Class<IGFCopilotService> clazz = IGFCopilotService.class;
            synchronized (IGFCopilotService.class) {
                if (singleton != null) return singleton;
                singleton = (IGFCopilotService)ApplicationManager.getApplication().getService(IGFCopilotService.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
        }
        catch (Exception e) {
            LogManager.warn(IGFCopilotService.class, e.toString());
        }
        return singleton;
    }

    @Override
    public Editor getEditorIncludeSplit(Editor editor) {
        VirtualFile focusVirtualFile;
        VirtualFile virtualFile = CopilotEditorUtils.getVirtualFile(editor);
        if (virtualFile == null) {
            return editor;
        }
        int length = FileEditorManager.getInstance((Project)editor.getProject()).getAllEditors(virtualFile).length;
        if (length > 1 && this.focusEditor != null && (focusVirtualFile = CopilotEditorUtils.getVirtualFile(this.focusEditor)) != null && virtualFile.getPath().equals(focusVirtualFile.getPath())) {
            return this.focusEditor;
        }
        return editor;
    }

    @Override
    public boolean isAvailable(Editor editor) {
        if (editor == null) {
            return false;
        }
        Boolean isAvailable = (Boolean)KEY_EDITOR_SUPPORTED.get((UserDataHolder)editor);
        if (isAvailable == null) {
            isAvailable = !(editor instanceof EditorWindow) && !(editor instanceof ImaginaryEditor) && (!(editor instanceof EditorEx) || !((EditorEx)editor).isEmbeddedIntoDialogWrapper()) && !editor.isViewer() && !editor.isOneLineMode() && PluginUtils.isSupportedIDE(editor.getProject());
            KEY_EDITOR_SUPPORTED.set((UserDataHolder)editor, (Object)isAvailable);
        }
        return isAvailable != false && !editor.isDisposed();
    }

    @Override
    public boolean isChatEnable(Editor editor) {
        if (!PluginUtils.isPluginAvailable()) {
            return false;
        }
        if (CopilotEditorUtils.isProjectAlive(editor)) {
            return GFCopilotService.getInstance().getCopilotChatPermission().get() && GFCopilotService.getInstance().getCopilotLoginState().get();
        }
        return false;
    }

    @Override
    public boolean isPartAcceptMode(Project project, int offset) {
        return false;
    }

    @Override
    public void editorCreated(Editor editor) {
    }

    @Override
    public void editorReleased(Editor editor, String url) {
    }

    @Override
    public void editorFocusChange(@NotNull Editor editor, @NotNull VirtualFile file) {
        MainThreadContext context;
        Project project;
        if (editor == null) {
            GFCopilotService.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GFCopilotService.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) != null && (context = MainThreadContext.getInstance(project)) != null) {
            context.handleReq(project, context.SET_CONTEXT, List.of("editorFocus", "true"), result -> {});
        }
        this.focusEditor = editor;
    }

    private void handleFirstLineForBlockCompletionWhenAccept(Project project, Editor editor, PsiFile psiFile, Document document, String remainText) {
        int caretOffset = editor.getCaretModel().getPrimaryCaret().getOffset();
        String textAfterCaret = CopilotEditorUtils.getLineTextAfterCaret(editor, caretOffset);
        boolean isBoundary = textAfterCaret.matches("^[\\s\\[\\]\\(\\)\\{\\};:'\",]*$");
        String[] remainLines = remainText.split("\n");
        if (remainLines.length > 1 && !remainLines[0].contains(textAfterCaret) && isBoundary) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)EditorCommandName.IGNORE_COMPLETION.DELETE_FIRST_LINE_FOR_COMPLETION.getName(), (String)"", () -> {
                int endOffset = CopilotEditorUtils.getLineEndOffset(editor, caretOffset);
                document.deleteString(caretOffset, endOffset);
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    @Override
    public AtomicBoolean getCopilotLoginState() {
        return this.copilotLoginState;
    }

    @Override
    public AtomicBoolean getCopilotChatPermission() {
        return this.copilotChatPermission;
    }

    @Override
    public AtomicInteger getInitialize() {
        return this.initialize;
    }

    static {
        EDITOR_DOCUMENT_LISTENER = Key.create((String)"gf.document.listener");
        EDITOR_CARET_LISTENER = Key.create((String)"gf.caret.listener");
        EDITOR_SELECTION_LISTENER = Key.create((String)"gf.selection.listener");
        KEY_EDITOR_SUPPORTED = Key.create((String)"gf.editorSupported");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/tencent/code/intel/impl/GFCopilotService";
        objectArray[2] = "editorFocusChange";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

