/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.impl;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.api.IInlayService;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.TextSegment;
import com.tencent.code.intel.common.InlayAcceptMode;
import com.tencent.code.intel.common.InlayDisplayMode;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.listener.CopilotLookupManagerListener;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.hintpop.CompletionPreviewInsertionHint;
import com.tencent.code.intel.ui.inlay.CopilotInlayRender;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.CopilotEditorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.http.util.TextUtils;

public class InlayService
implements IInlayService {
    private List<Inlay<?>> inlays = new CopyOnWriteArrayList();
    private static volatile IInlayService singleton;
    private CompletionPreviewInsertionHint completionPreviewInsertionHint;
    private int acceptTipsTime = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IInlayService getInstance() {
        try {
            if (singleton != null) return singleton;
            Class<IInlayService> clazz = IInlayService.class;
            synchronized (IInlayService.class) {
                if (singleton != null) return singleton;
                singleton = (IInlayService)ApplicationManager.getApplication().getService(IInlayService.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
        }
        catch (Exception e) {
            LogManager.warn(InlayService.class, e.toString());
        }
        return singleton;
    }

    @Override
    public void acceptInlay() {
        if (!CopilotSettingsService.getInstance().isTabOverTimes()) {
            ++this.acceptTipsTime;
            if (this.acceptTipsTime >= 3) {
                CopilotSettingsService.getInstance().setTabOverTimes(true);
            }
        }
    }

    @Override
    public int calculateWidth(Editor editor, String source, List<String> solutions) {
        FontMetrics metrics = this.getFontMetrics(editor, this.getFont(editor, String.join((CharSequence)System.lineSeparator(), solutions)));
        OptionalInt max = solutions.stream().mapToInt(metrics::stringWidth).max();
        return max.orElse(editor.getComponent().getWidth());
    }

    @Override
    public Font getFont(Editor editor, String source) {
        Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN).deriveFont(2);
        Font fallbackFont = UIUtil.getFontWithFallbackIfNeeded((Font)font, (String)source);
        return fallbackFont.deriveFont(this.getFontSize(editor));
    }

    @Override
    public FontMetrics getFontMetrics(Editor editor, Font font) {
        FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)editor.getContentComponent());
        FontRenderContext context = new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editorContext.getFractionalMetricsHint());
        return FontInfo.getFontMetrics((Font)font, (FontRenderContext)context);
    }

    @Override
    public float getFontSize(Editor editor) {
        return editor.getColorsScheme().getEditorFontSize();
    }

    @Override
    public List<Inlay<?>> getAllInlays() {
        return this.inlays;
    }

    @Override
    public void disposeAllInlays() {
        ThreadManager.getInstance().runUiThread(() -> this.disposeInlay());
    }

    @Override
    public void disposeAllInlays(Project project) {
        ThreadManager.getInstance().runUiThread(() -> ExtHostLanguageFeatures.setCompletionHint(project, false));
    }

    private void disposeInlay() {
        try {
            if (CollectionUtils.isEmpty(this.inlays)) {
                return;
            }
            for (Inlay<?> inlay : this.inlays) {
                if (inlay == null || !inlay.isValid()) continue;
                inlay.dispose();
            }
            this.inlays.clear();
        }
        catch (Exception e) {
            LogManager.warn(InlayService.class, "disposeInlay\uff1a" + e.toString());
        }
    }

    @Override
    public InlayDisplayMode getInlayDisplayMode(Editor editor, int insertLine, int contentLines) {
        int currentLine = editor.getCaretModel().getPrimaryCaret().getLogicalPosition().line;
        InlayDisplayMode displayMode = currentLine == insertLine ? (contentLines == 1 ? InlayDisplayMode.AfterLine : InlayDisplayMode.AfterLineAndBlock) : InlayDisplayMode.Block;
        return displayMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(Editor editor, String source, int offset, List<String> content, InlayDisplayMode mode, InlayAcceptMode acceptMode, int tabSize, boolean isPrediction) {
        try {
            Color bgColor = null;
            Object fgColor = JBColor.GRAY;
            if (isPrediction) {
                TextAttributesKey INSERTED = TextAttributesKey.createTextAttributesKey((String)"PATCH_INSERTED", (TextAttributesKey)DiffColors.DIFF_INSERTED);
                bgColor = INSERTED.getDefaultAttributes().getBackgroundColor();
                fgColor = ColorUtils.getFontColor();
            }
            if (CollectionUtils.isEmpty(content)) {
                LogManager.warn(InlayService.class, "Inlay ignore because content is empty");
                return;
            }
            if (CopilotEditorUtils.isInjectedFile(editor)) {
                LogManager.warn(InlayService.class, "Inlay ignore because editor is injected");
                return;
            }
            this.disposeInlay();
            boolean hasLookup = CopilotLookupManagerListener.hasLookUp(editor);
            boolean sideEnable = CopilotSettingsService.getInstance().isSideBySideEnable();
            if (!sideEnable && hasLookup) {
                LogManager.warn(InlayService.class, "Inlay ignore because side-by-side is off and lookup is showing");
                return;
            }
            this.disposePreviewInsertionHint(false);
            InlayModel inlayModel = editor.getInlayModel();
            int lineEndOffset = CopilotEditorUtils.getLineEndOffset(editor, offset);
            switch (mode) {
                case AfterLine: {
                    if (CollectionUtils.isEmpty(content) || TextUtils.isEmpty((CharSequence)content.get(0))) break;
                    if (offset == lineEndOffset) {
                        List<String> finalContent = content;
                        List<String> newList = content.stream().map(s -> s.equals(finalContent.get(0)) ? s + this.getInlayTips(true, isPrediction) : s).collect(Collectors.toList());
                        CopilotInlayRender render = CopilotInlayRender.builder().source(source).solutions(newList).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                        this.inlays.add(inlayModel.addInlineElement(offset, true, (EditorCustomElementRenderer)render));
                        break;
                    }
                    CopilotInlayRender render = CopilotInlayRender.builder().source(source).solutions(content).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                    this.inlays.add(inlayModel.addInlineElement(offset, true, (EditorCustomElementRenderer)render));
                    if (TextUtils.isEmpty((CharSequence)this.getInlayTips(true, isPrediction))) break;
                    CopilotInlayRender renderTips = CopilotInlayRender.builder().source(source).solutions(List.of(this.getInlayTips(true, isPrediction))).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                    this.inlays.add(inlayModel.addInlineElement(lineEndOffset, true, (EditorCustomElementRenderer)renderTips));
                    break;
                }
                case AfterLineAndBlock: {
                    CopilotInlayRender render;
                    if (offset == lineEndOffset) {
                        List<CallSite> firstList = List.of(content.get(0) + (content.size() > 1 ? this.getInlayTips(false, isPrediction) : ""));
                        if (!CollectionUtils.isEmpty(content) && !TextUtils.isEmpty((CharSequence)((CharSequence)((Object)firstList.get(0))))) {
                            CopilotInlayRender render2 = CopilotInlayRender.builder().source(source).solutions(firstList).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                            this.inlays.add(inlayModel.addInlineElement(offset, true, (EditorCustomElementRenderer)render2));
                        }
                    } else {
                        if (!CollectionUtils.isEmpty(content) && !TextUtils.isEmpty((CharSequence)content.get(0))) {
                            render = CopilotInlayRender.builder().source(source).solutions(List.of(content.get(0))).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                            this.inlays.add(inlayModel.addInlineElement(offset, true, (EditorCustomElementRenderer)render));
                        }
                        if (!TextUtils.isEmpty((CharSequence)this.getInlayTips(true, isPrediction))) {
                            CopilotInlayRender renderTips = CopilotInlayRender.builder().source(source).solutions(List.of(this.getInlayTips(true, isPrediction))).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                            this.inlays.add(inlayModel.addInlineElement(lineEndOffset, true, (EditorCustomElementRenderer)renderTips));
                        }
                    }
                    if (CollectionUtils.isEmpty(content) || content.size() <= 1) break;
                    render = CopilotInlayRender.builder().source(source).solutions(content.subList(1, content.size())).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                    this.inlays.add(inlayModel.addBlockElement(offset, true, false, Integer.MAX_VALUE, (EditorCustomElementRenderer)render));
                    break;
                }
                case Block: {
                    CopilotInlayRender render;
                    if (CollectionUtils.isEmpty(content)) break;
                    if (!TextUtils.isEmpty((CharSequence)this.getInlayTips(false, isPrediction))) {
                        render = CopilotInlayRender.builder().source(source).solutions(List.of(this.getInlayTips(false, isPrediction))).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                        this.inlays.add(inlayModel.addInlineElement(offset, true, (EditorCustomElementRenderer)render));
                    }
                    render = CopilotInlayRender.builder().source(source).solutions(content).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                    this.inlays.add(inlayModel.addBlockElement(offset, true, false, Integer.MAX_VALUE, (EditorCustomElementRenderer)render));
                    break;
                }
            }
            if (!this.inlays.isEmpty() && CopilotSettingsService.getInstance().isShowInlayTool()) {
                this.completionPreviewInsertionHint = new CompletionPreviewInsertionHint(editor, this.inlays.get(0), offset);
            }
            this.inlays = this.inlays.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            LogManager.warn(InlayService.class, "display:" + e.toString());
        }
    }

    @Override
    public void disposePreviewInsertionHint(boolean hide) {
        if (this.completionPreviewInsertionHint != null) {
            if (hide) {
                this.completionPreviewInsertionHint.hideHint();
            }
            this.completionPreviewInsertionHint.dispose();
        }
    }

    private String getInlayTips(boolean isTab, boolean isPrediction) {
        return "";
    }

    @Override
    public void displayMultiSegment(Editor editor, String source, List<TextSegment> segments, InlayAcceptMode acceptMode, int tabSize, boolean isPrediction) {
        try {
            if (CollectionUtils.isEmpty(segments)) {
                LogManager.warn(InlayService.class, "Multi-segment display: no segments to display");
                return;
            }
            if (CopilotEditorUtils.isInjectedFile(editor)) {
                LogManager.warn(InlayService.class, "Multi-segment display: editor is injected");
                return;
            }
            this.disposeInlay();
            this.disposePreviewInsertionHint(false);
            Color bgColor = null;
            Object fgColor = JBColor.GRAY;
            if (isPrediction) {
                TextAttributesKey INSERTED = TextAttributesKey.createTextAttributesKey((String)"PATCH_INSERTED", (TextAttributesKey)DiffColors.DIFF_INSERTED);
                bgColor = INSERTED.getDefaultAttributes().getBackgroundColor();
                fgColor = ColorUtils.getFontColor();
            }
            InlayModel inlayModel = editor.getInlayModel();
            for (int i = 0; i < segments.size(); ++i) {
                TextSegment segment = segments.get(i);
                Position position = segment.getPosition();
                String text = segment.getText();
                int lineStartOffset = editor.getDocument().getLineStartOffset(position.getLine());
                int offset = lineStartOffset + position.getCharacter() - 1;
                try {
                    int lineEnd = editor.getDocument().getLineEndOffset(position.getLine());
                    if (offset > lineEnd) {
                        offset = lineEnd;
                    }
                }
                catch (Exception adjustEx) {
                    LogManager.warn(InlayService.class, "Failed to adjust multi-segment offset: " + String.valueOf(adjustEx));
                }
                List<String> textLines = text.contains("\n") ? Arrays.asList(text.split("\n", -1)) : List.of(text);
                CopilotInlayRender render = CopilotInlayRender.builder().source(source).solutions(textLines).tabSize(tabSize).bgColor(bgColor).fgColor((Color)fgColor).build();
                Inlay inlay = inlayModel.addInlineElement(offset, true, (EditorCustomElementRenderer)render);
                if (inlay == null) continue;
                this.inlays.add(inlay);
            }
            if (!this.inlays.isEmpty() && CopilotSettingsService.getInstance().isShowInlayTool()) {
                this.completionPreviewInsertionHint = new CompletionPreviewInsertionHint(editor, this.inlays.get(0), segments.get(0).getPosition().getCharacter() - 1);
            }
            this.inlays = this.inlays.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            LogManager.warn(InlayService.class, "displayMultiSegment: " + e.toString());
        }
    }
}

