/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.listener;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.CodeLensInlayManager;
import com.tencent.code.intel.impl.GFCopilotService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.ui.inline.InlineChatGutterIcon;
import com.tencent.code.intel.util.CopilotEditorUtils;
import org.jetbrains.annotations.NotNull;

public class CopilotEditorFactoryListener
implements EditorFactoryListener {
    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Editor editor;
        if (event == null) {
            CopilotEditorFactoryListener.$$$reportNull$$$0(0);
        }
        if (event.getEditor().getEditorKind() == EditorKind.MAIN_EDITOR && CopilotEditorUtils.isProjectAlive(editor = event.getEditor())) {
            VirtualFile virtualFile = CopilotEditorUtils.getVirtualFile(editor);
            if (virtualFile != null && !CopilotEditorUtils.hasEditors(editor.getProject(), virtualFile)) {
                String uri = CopilotEditorUtils.getCopilotFilePath(editor);
                GFCopilotService.getInstance().editorReleased(editor, uri);
                CodeLensInlayManager.clearAllForEditor(editor);
            } else {
                LogManager.warn(this.getClass(), "open multiple editors,editor released ignore");
            }
        }
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Editor editor;
        if (event == null) {
            CopilotEditorFactoryListener.$$$reportNull$$$0(1);
        }
        if (event.getEditor().getEditorKind() == EditorKind.MAIN_EDITOR && CopilotEditorUtils.isProjectAlive(editor = event.getEditor())) {
            VirtualFile virtualFile = CopilotEditorUtils.getVirtualFile(editor);
            if (virtualFile != null && !CopilotEditorUtils.hasEditors(editor.getProject(), virtualFile)) {
                GFCopilotService.getInstance().editorCreated(editor);
            } else {
                LogManager.warn(this.getClass(), "open multiple editors,editor create ignore");
            }
            InlineChatGutterIcon.getInstance().onEditorCreated(editor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/tencent/code/intel/listener/CopilotEditorFactoryListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "editorReleased";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "editorCreated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

