/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.listener;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.Range;
import com.tencent.code.intel.bean.item.SelectedCompletionInfo;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.CopilotEditorUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotLookupManagerListener
implements LookupManagerListener {
    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        PsiFile psiFile;
        if (!CopilotSettingsService.getInstance().isActivate()) {
            return;
        }
        Lookup validLookup = newLookup != null ? newLookup : oldLookup;
        PsiFile psiFile2 = psiFile = validLookup != null ? validLookup.getPsiFile() : null;
        if (oldLookup != null && newLookup == null) {
            PsiFile file = oldLookup.getPsiFile();
            if (file != null) {
                Editor editor = oldLookup.getEditor();
                if (editor.getDocument().isInBulkUpdate()) {
                    return;
                }
                return;
            }
            return;
        }
        if (newLookup != null && oldLookup == null) {
            if (CopilotSettingsService.getInstance().isSideBySideEnable()) {
                return;
            }
            Editor editor2 = newLookup.getEditor();
            if (CopilotEditorUtils.isEditorAvailable(editor2)) {
                // empty if block
            }
        }
    }

    public static boolean hasLookUp(Editor editor) {
        return LookupManager.getActiveLookup((Editor)editor) != null;
    }

    public static class SelectLookupListener
    implements LookupListener {
        private Editor editor;
        public boolean isShow = false;
        private String lastSelect = "";

        public SelectLookupListener(Editor editor) {
            this.editor = editor;
        }

        public void lookupShown(@NotNull LookupEvent event) {
            if (event == null) {
                SelectLookupListener.$$$reportNull$$$0(0);
            }
            this.isShow = true;
        }

        public void itemSelected(@NotNull LookupEvent event) {
            if (event == null) {
                SelectLookupListener.$$$reportNull$$$0(1);
            }
            this.isShow = false;
        }

        public void lookupCanceled(@NotNull LookupEvent event) {
            if (event == null) {
                SelectLookupListener.$$$reportNull$$$0(2);
            }
            this.isShow = false;
        }

        public void currentItemChanged(@NotNull LookupEvent event) {
            if (event == null) {
                SelectLookupListener.$$$reportNull$$$0(3);
            }
            if (!this.canTrigger(event)) {
                return;
            }
            try {
                LookupElement lookupElement;
                if (CollectionUtils.isNotEmpty(event.getLookup().getItems()) && (lookupElement = event.getLookup().getCurrentItem()) != null) {
                    Position startPosition = CopilotEditorUtils.position(this.editor.getDocument(), event.getLookup().getLookupStart());
                    String lookupString = lookupElement.getLookupString();
                    Editor editor = event.getLookup().getEditor();
                    PsiFile psiFile = event.getLookup().getPsiFile();
                    int offset = editor.getCaretModel().getOffset();
                    Position endPosition = CopilotEditorUtils.position(editor.getDocument(), offset);
                    Range range = new Range(startPosition, endPosition);
                    SelectedCompletionInfo selectedCompletionInfo = new SelectedCompletionInfo(range, lookupString);
                }
            }
            catch (Exception e) {
                LogManager.warn(CopilotLookupManagerListener.class, "SelectLookupListener-currentItemChanged-error:" + e.getMessage());
            }
        }

        private boolean canTrigger(@NotNull LookupEvent event) {
            LookupElement lookupElement;
            if (event == null) {
                SelectLookupListener.$$$reportNull$$$0(4);
            }
            if (!this.isShow) {
                return false;
            }
            if (CollectionUtils.isNotEmpty(event.getLookup().getItems()) && (lookupElement = event.getLookup().getCurrentItem()) != null) {
                if (!TextUtils.isEmpty((CharSequence)this.lastSelect)) {
                    return true;
                }
                this.lastSelect = lookupElement.getLookupString();
            }
            return false;
        }

        @Deprecated
        private String getLookupArrangerMatcher(LookupElement lookupElement) {
            if (lookupElement != null) {
                try {
                    String regex;
                    Pattern pattern;
                    Matcher matcher;
                    String input = lookupElement.getUserDataString();
                    if (!TextUtils.isEmpty((CharSequence)input) && (matcher = (pattern = Pattern.compile(regex = "LookupArrangerMatcher=(\\w+)")).matcher(input)).find()) {
                        return matcher.group(1);
                    }
                }
                catch (Exception e) {
                    LogManager.warn(CopilotLookupManagerListener.class, "getLookupArrangerMatcher-error:" + e.getMessage());
                }
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/tencent/code/intel/listener/CopilotLookupManagerListener$SelectLookupListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lookupShown";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lookupCanceled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "currentItemChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canTrigger";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

