/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.listener;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.tencent.code.intel.apibridge.nodeprocess.NodeProjectService;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.CopilotEditorUtils;
import com.tencent.code.intel.util.PluginUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CopilotPluginLoadListener
implements DynamicPluginListener {
    public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        if (pluginDescriptor == null) {
            CopilotPluginLoadListener.$$$reportNull$$$0(0);
        }
        if (PluginUtils.isGFCopilotPlugin((PluginDescriptor)pluginDescriptor)) {
            LogManager.info(CopilotPluginLoadListener.class, "beforePluginUnload\uff1a" + pluginDescriptor.toString() + " isUpdate:" + isUpdate);
            if (!PluginUtils.isPluginAvailable()) {
                return;
            }
            try {
                Editor editor = CopilotEditorUtils.getSelectEditor(null);
                if (editor != null) {
                    InlayService.getInstance().disposeAllInlays();
                }
                this.clearLocalCache();
                this.releaseFusionProcesses();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            CopilotPluginLoadListener.$$$reportNull$$$0(1);
        }
        if (PluginUtils.isGFCopilotPlugin((PluginDescriptor)pluginDescriptor)) {
            LogManager.info(CopilotPluginLoadListener.class, "pluginLoaded\uff1a" + pluginDescriptor.toString());
        }
    }

    public void clearLocalCache() {
        try {
            Method clearLocaleCacheMethod = LocaleManager.class.getDeclaredMethod("clearLocaleCache", new Class[0]);
            clearLocaleCacheMethod.setAccessible(true);
            clearLocaleCacheMethod.invoke((Object)LocaleManager.INSTANCE, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LogManager.warn(CopilotPluginLoadListener.class, "clearLocalCache:" + e.toString());
        }
    }

    private void releaseFusionProcesses() {
        try {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            LogManager.info(CopilotPluginLoadListener.class, "\u91ca\u653e " + openProjects.length + " \u4e2a\u9879\u76ee\u7684fusion\u8fdb\u7a0b");
            Arrays.stream(openProjects).forEach(project -> {
                try {
                    NodeRunner nodeRunner;
                    NodeProjectService nodeProjectService;
                    if (project != null && !project.isDisposed() && (nodeProjectService = (NodeProjectService)project.getService(NodeProjectService.class)) != null && (nodeRunner = nodeProjectService.getNodeRunner()) != null) {
                        LogManager.info(CopilotPluginLoadListener.class, "\u91ca\u653e\u9879\u76ee " + project.getName() + " \u7684fusion\u8fdb\u7a0b");
                        nodeRunner.release();
                    }
                }
                catch (Exception e) {
                    LogManager.warn(CopilotPluginLoadListener.class, "\u91ca\u653e\u9879\u76eefusion\u8fdb\u7a0b\u5931\u8d25: " + e.toString());
                }
            });
        }
        catch (Exception e) {
            LogManager.error(CopilotPluginLoadListener.class, "\u91ca\u653efusion\u8fdb\u7a0b\u65f6\u51fa\u9519: " + e.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "pluginDescriptor";
        objectArray2[1] = "com/tencent/code/intel/listener/CopilotPluginLoadListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePluginUnload";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginLoaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

