/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.manager;

import com.intellij.openapi.diagnostic.Logger;
import com.tencent.code.intel.ui.sidebar.CopilotDebugWindow;
import com.tencent.code.intel.util.PluginUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class LogManager {
    private static boolean isAllConsoleWindow = false;

    public static void console(String message, Level level) {
        CopilotDebugWindow.print(message, level);
    }

    public static void debug(@NotNull Class<?> cl, String message) {
        if (cl == null) {
            LogManager.$$$reportNull$$$0(0);
        }
        LogManager.log(cl, message, (logger, msg) -> logger.debug(msg));
    }

    public static void info(@NotNull Class<?> cl, String message) {
        if (cl == null) {
            LogManager.$$$reportNull$$$0(1);
        }
        LogManager.log(cl, message, (logger, msg) -> logger.info(msg));
    }

    public static void warn(@NotNull Class<?> cl, String message) {
        if (cl == null) {
            LogManager.$$$reportNull$$$0(2);
        }
        LogManager.log(cl, message, (logger, msg) -> logger.warn(msg));
    }

    public static void error(@NotNull Class<?> cl, String message) {
        if (cl == null) {
            LogManager.$$$reportNull$$$0(3);
        }
        LogManager.log(cl, message, (logger, msg) -> logger.warn(msg));
    }

    private static void log(@NotNull Class<?> cl, String message, LogAction action) {
        if (cl == null) {
            LogManager.$$$reportNull$$$0(4);
        }
        try {
            if (isAllConsoleWindow) {
                LogManager.console((String)message, Level.INFO);
            }
            String threadName = Thread.currentThread().getName();
            if (PluginUtils.isDebug()) {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                int activeThreadCount = threadMXBean.getThreadCount();
                message = (String)message + "[" + threadName + "/" + activeThreadCount + "]";
            } else {
                message = (String)message + "[" + threadName + "]";
            }
            action.log(Logger.getInstance(cl), (String)message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "cl";
        objectArray2[1] = "com/tencent/code/intel/manager/LogManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "debug";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "info";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "warn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    private static interface LogAction {
        public void log(Logger var1, String var2);
    }
}

