/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.manager;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.tencent.code.intel.manager.LogManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ThreadManager
implements Disposable {
    private static volatile ThreadManager singleton;
    private final ExecutorService rpcExecutor = Executors.newSingleThreadExecutor();
    private ScheduledExecutorService singleScheduleThread = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<Object> singleScheduleThreadFuture;
    private ExecutorService lspSingleWriteExecutor = Executors.newSingleThreadExecutor();
    private ExecutorService chatProgressSingleExecutor = Executors.newSingleThreadExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadManager getInstance() {
        if (singleton != null) return singleton;
        Class<ThreadManager> clazz = ThreadManager.class;
        synchronized (ThreadManager.class) {
            if (singleton != null) return singleton;
            singleton = new ThreadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void dispatchOnRPCExecutor(Runnable runnable) {
        this.rpcExecutor.execute(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                LogManager.warn(ThreadManager.class, "executing rpc " + e.toString());
            }
        });
    }

    public void executeOnceShortTime(int delayMil, Callable<Object> callable) {
        if (this.singleScheduleThreadFuture != null) {
            this.singleScheduleThreadFuture.cancel(true);
        }
        this.singleScheduleThreadFuture = this.singleScheduleThread.schedule(callable, (long)delayMil, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<Object> executeDelay(int delayMil, Callable<Object> callable) {
        return this.singleScheduleThread.schedule(callable, (long)delayMil, TimeUnit.MILLISECONDS);
    }

    public void executeLspWrite(Runnable runnable) {
        if (this.lspSingleWriteExecutor != null) {
            this.lspSingleWriteExecutor.execute(runnable);
        }
    }

    public void executeChatProgress(Runnable runnable) {
        if (this.chatProgressSingleExecutor != null) {
            this.chatProgressSingleExecutor.execute(runnable);
        }
    }

    public void runUiThread(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    public static <T> void runTaskOnUIThread(Supplier<T> task, Consumer<T> complete) {
        ThreadManager.getInstance().runUiThread(() -> {
            Object result = task.get();
            ThreadManager.getInstance().runThread(() -> complete.accept(result));
        });
    }

    public void runUiThreadSave(Runnable runnable) {
        try {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                runnable.run();
            } else {
                this.runUiThread(runnable);
            }
        }
        catch (Exception e) {
            LogManager.info(ThreadManager.class, "runUiThreadSave:" + String.valueOf(e));
        }
    }

    public void runDelayUiThreadSave(int delayMil, Runnable runnable) {
        this.executeDelay(delayMil, () -> {
            this.runUiThreadSave(runnable);
            return null;
        });
    }

    public void runThread(Runnable runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    public <T> Future<T> runThread(Callable<T> callable) {
        return ApplicationManager.getApplication().executeOnPooledThread(callable);
    }

    public void dispose() {
        if (this.lspSingleWriteExecutor != null) {
            this.lspSingleWriteExecutor.shutdown();
        }
        if (this.singleScheduleThread != null) {
            this.singleScheduleThread.shutdown();
        }
        if (this.chatProgressSingleExecutor != null) {
            this.chatProgressSingleExecutor.shutdown();
        }
    }
}

