/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.manager.code.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.code.completion.LanguageCompletionHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BaseCompletionHandler
implements LanguageCompletionHandler {
    protected PsiElement detectMemberAccess(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent == null || !parent.getText().contains(".")) {
            return null;
        }
        String parentText = parent.getText();
        int dotIndex = parentText.lastIndexOf(46);
        if (dotIndex <= 0) {
            return null;
        }
        String qualifier = parentText.substring(0, dotIndex);
        LogManager.info(this.getClass(), "[" + this.getLanguageId() + "] Qualifier: '" + qualifier + "'");
        for (PsiElement child : parent.getChildren()) {
            PsiElement resolved;
            if (!child.getText().equals(qualifier)) continue;
            PsiReference ref = child.getReference();
            if (ref != null && (resolved = ref.resolve()) != null) {
                LogManager.info(this.getClass(), "[" + this.getLanguageId() + "] Resolved to: " + resolved.getClass().getSimpleName());
                return resolved;
            }
            return child;
        }
        return null;
    }

    protected LookupElement createBasicLookupElement(PsiNamedElement element, String name) {
        return LookupElementBuilder.create((Object)element, (String)name);
    }

    protected String extractPrefix(PsiElement element) {
        String text = element.getText();
        if (text == null || text.trim().isEmpty()) {
            return "";
        }
        int dotIndex = text.lastIndexOf(46);
        if (dotIndex >= 0 && dotIndex < text.length() - 1) {
            return text.substring(dotIndex + 1);
        }
        return text;
    }

    protected boolean shouldIncludeName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.startsWith("_") || name.startsWith("$")) {
            return false;
        }
        return !name.startsWith("__") || !name.endsWith("__");
    }

    protected void collectScopeSymbols(PsiElement element, List<LookupElement> results, int maxCount, String prefix) {
        HashSet<String> addedNames = new HashSet<String>();
        for (PsiElement current = element; current != null && results.size() < maxCount; current = current.getParent()) {
            String currentClass = current.getClass().getName();
            for (PsiElement prevSibling = current.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
                this.collectFromElement(prevSibling, results, addedNames, prefix, maxCount);
                if (results.size() >= maxCount) break;
            }
            this.collectFromElement(current, results, addedNames, prefix, maxCount);
            if (currentClass.contains("PsiMethod") || currentClass.contains("PsiClass") || currentClass.contains("JSFunction") || current instanceof PsiFile) break;
        }
    }

    private void collectFromElement(PsiElement element, List<LookupElement> results, Set<String> addedNames, String prefix, int maxCount) {
        PsiNamedElement named;
        String name;
        boolean isVariable;
        String className = element.getClass().getName();
        if (className.contains("PsiDirectory") || className.contains("PsiFile")) {
            return;
        }
        if (className.contains("PsiClass") || className.contains("PsiMethod") || className.contains("PsiField")) {
            return;
        }
        boolean bl = isVariable = className.contains("Variable") || className.contains("Parameter") || className.contains("LocalVariable");
        if (isVariable && element instanceof PsiNamedElement && (name = (named = (PsiNamedElement)element).getName()) != null && this.shouldMatchPrefix(name, prefix) && this.shouldIncludeName(name) && !addedNames.contains(name)) {
            results.add(this.createBasicLookupElement(named, name));
            addedNames.add(name);
        }
        for (PsiElement child : element.getChildren()) {
            if (results.size() >= maxCount) break;
            this.collectFromElement(child, results, addedNames, prefix, maxCount);
        }
    }

    private boolean shouldMatchPrefix(String name, String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return true;
        }
        return name.toLowerCase().startsWith(prefix.toLowerCase());
    }
}

