/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.manager.code.completion;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.tencent.code.intel.manager.code.completion.JavaCompletionHandler;
import com.tencent.code.intel.manager.code.completion.JavaScriptCompletionHandler;
import com.tencent.code.intel.manager.code.completion.LanguageCompletionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class CompletionItemsProviderV2 {
    private static final int DEFAULT_MAX_COUNT = 100;
    private static final int KIND_TEXT = 0;
    private static final int KIND_METHOD = 1;
    private static final int KIND_FIELD = 4;
    private static final int KIND_VARIABLE = 5;
    private static final int KIND_CLASS = 6;
    private static final int KIND_INTERFACE = 7;
    private static final int KIND_KEYWORD = 13;
    private static final String TYPE_TEXT_FUNCTION = "function";
    private final Project project;
    private final List<LanguageCompletionHandler> handlers;

    public CompletionItemsProviderV2(Project project) {
        this.project = project;
        this.handlers = new ArrayList<LanguageCompletionHandler>();
        this.handlers.add(new JavaCompletionHandler());
        this.handlers.add(new JavaScriptCompletionHandler());
    }

    public void getCompletionItems(String filePath, int line, int character, String triggerCharacter, int maxCount, Consumer<Object> complete) {
        ReadAction.nonBlocking(() -> this.computeCompletionItems(filePath, line, character, maxCount)).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.defaultModalityState(), result -> complete.accept(result)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private Object computeCompletionItems(String filePath, int line, int character, int maxCount) {
        try {
            PsiFile psiFile = this.getPsiFile(filePath);
            if (psiFile == null) {
                return this.createEmptyCompletionList();
            }
            Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile);
            if (document == null) {
                return this.createEmptyCompletionList();
            }
            int offset = this.calculateOffset(document, line, character);
            if (offset < 0) {
                return this.createEmptyCompletionList();
            }
            LanguageCompletionHandler handler = this.selectHandler(psiFile);
            if (handler == null) {
                return this.createEmptyCompletionList();
            }
            List<LookupElement> completionItems = handler.collectCompletionItems(psiFile, document, offset, maxCount);
            return this.convertToVSCodeFormat(completionItems, maxCount);
        }
        catch (Throwable e) {
            return this.createEmptyCompletionList();
        }
    }

    private LanguageCompletionHandler selectHandler(PsiFile file) {
        for (LanguageCompletionHandler handler : this.handlers) {
            if (!handler.supports(file)) continue;
            return handler;
        }
        return null;
    }

    private PsiFile getPsiFile(String filePath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)this.project).findFile(virtualFile);
    }

    private int calculateOffset(Document document, int line, int character) {
        if (line < 0 || line >= document.getLineCount()) {
            return -1;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        int offset = lineStartOffset + character;
        return Math.min(offset, Math.min(lineEndOffset, document.getTextLength()));
    }

    private JSONObject convertToVSCodeFormat(List<LookupElement> lookupElements, int maxCount) {
        JSONArray items = new JSONArray();
        int count = 0;
        for (LookupElement element : lookupElements) {
            if (count >= maxCount) break;
            LookupElementPresentation presentation = new LookupElementPresentation();
            element.renderElement(presentation);
            JSONObject item = new JSONObject();
            item.put((Object)"label", (Object)element.getLookupString());
            item.put((Object)"insertText", (Object)element.getLookupString());
            item.put((Object)"kind", (Object)this.mapCompletionItemKind(presentation));
            StringBuilder detail = new StringBuilder();
            if (presentation.getTailText() != null) {
                detail.append(presentation.getTailText());
            }
            if (presentation.getTypeText() != null) {
                if (detail.length() > 0) {
                    detail.append(" : ");
                }
                detail.append(presentation.getTypeText());
            }
            if (detail.length() > 0) {
                item.put((Object)"detail", (Object)detail.toString());
            }
            item.put((Object)"sortText", (Object)element.getLookupString());
            items.add((Object)item);
            ++count;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"isIncomplete", (Object)(lookupElements.size() > maxCount ? 1 : 0));
        result.put((Object)"items", (Object)items);
        return result;
    }

    private int mapCompletionItemKind(LookupElementPresentation presentation) {
        String icon = presentation.getIcon() != null ? presentation.getIcon().toString() : "";
        String tailText = presentation.getTailText();
        String typeText = presentation.getTypeText();
        if (icon.contains("Method") || tailText != null && tailText.contains("(") || TYPE_TEXT_FUNCTION.equals(typeText)) {
            return 1;
        }
        if (icon.contains("Field") || icon.contains("Property")) {
            return 4;
        }
        if (icon.contains("Class")) {
            return 6;
        }
        if (icon.contains("Interface")) {
            return 7;
        }
        if (icon.contains("Variable") || icon.contains("Parameter")) {
            return 5;
        }
        if (icon.contains("Keyword")) {
            return 13;
        }
        return 0;
    }

    private JSONObject createEmptyCompletionList() {
        JSONObject result = new JSONObject();
        result.put((Object)"isIncomplete", (Object)false);
        result.put((Object)"items", (Object)new JSONArray());
        return result;
    }
}

