/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.manager.code.completion;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FallbackCompletionProvider {
    private static final Set<String> COMMON_OBJECT_METHODS = new HashSet<String>();

    public boolean supports(PsiElement element) {
        return element != null && element.getChildren().length > 0;
    }

    public Collection<PsiNamedElement> collectTypeMembers(PsiElement typeElement, boolean staticOnly) {
        ArrayList<PsiNamedElement> result = new ArrayList<PsiNamedElement>();
        this.collectNamedChildren(typeElement, staticOnly, result);
        return result;
    }

    private void collectNamedChildren(PsiElement element, boolean staticOnly, Collection<PsiNamedElement> result) {
        for (PsiElement child : element.getChildren()) {
            PsiNamedElement namedElement;
            if (!(child instanceof PsiNamedElement) || !this.shouldIncludeElement(namedElement = (PsiNamedElement)child, staticOnly)) continue;
            result.add(namedElement);
        }
    }

    private boolean shouldIncludeElement(PsiNamedElement element, boolean staticOnly) {
        String name = element.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.startsWith("_")) {
            return false;
        }
        if (name.startsWith("#")) {
            return false;
        }
        if (COMMON_OBJECT_METHODS.contains(name)) {
            return false;
        }
        if (name.startsWith("__") && name.endsWith("__")) {
            return false;
        }
        return !staticOnly || this.isLikelyStatic(element);
    }

    private boolean isLikelyStatic(PsiNamedElement element) {
        PsiModifierListOwner modifierOwner;
        PsiModifierList modifierList;
        if (element instanceof PsiModifierListOwner && (modifierList = (modifierOwner = (PsiModifierListOwner)element).getModifierList()) != null) {
            return modifierList.hasModifierProperty("static");
        }
        String text = element.getText();
        if (text != null && text.contains("static")) {
            return true;
        }
        PsiElement prevSibling = element.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment) {
            String commentText;
            if (prevSibling instanceof PsiComment && (commentText = prevSibling.getText()) != null && commentText.contains("static")) {
                return true;
            }
            prevSibling = prevSibling.getPrevSibling();
        }
        return false;
    }

    public String getLanguageId() {
        return "UNIVERSAL";
    }

    static {
        COMMON_OBJECT_METHODS.add("toString");
        COMMON_OBJECT_METHODS.add("equals");
        COMMON_OBJECT_METHODS.add("hashCode");
        COMMON_OBJECT_METHODS.add("clone");
        COMMON_OBJECT_METHODS.add("finalize");
        COMMON_OBJECT_METHODS.add("getClass");
        COMMON_OBJECT_METHODS.add("notify");
        COMMON_OBJECT_METHODS.add("notifyAll");
        COMMON_OBJECT_METHODS.add("wait");
    }
}

