/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.manager.code.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtil;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.code.completion.BaseCompletionHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaCompletionHandler
extends BaseCompletionHandler {
    private static final String EXT_JAVA = ".java";
    private static final String PSI_JAVA_CLASS = "Class";
    private static final String PSI_JAVA_METHOD = "Method";
    private static final String PSI_JAVA_FIELD = "Field";
    private static final String PSI_JAVA_VARIABLE = "Variable";
    private static final String PSI_REFERENCE_EXPRESSION = "PsiReferenceExpression";
    private static final String METHOD_GET_TYPE = "getType";
    private static final String METHOD_GET_PARAMETER_LIST = "getParameterList";
    private static final String METHOD_GET_PARAMETERS = "getParameters";
    private static final String METHOD_GET_MODIFIER_LIST = "getModifierList";
    private static final String METHOD_HAS_MODIFIER_PROPERTY = "hasModifierProperty";
    private static final String METHOD_RESOLVE_CLASS_IN_TYPE = "resolveClassInType";
    private static final String METHOD_GET_QUALIFIER_EXPRESSION = "getQualifierExpression";
    private static final String MODIFIER_STATIC = "static";
    private static final String MODIFIER_PRIVATE = "private";
    private static final String MODIFIER_PROTECTED = "protected";

    @Override
    public boolean supports(PsiFile file) {
        return file.getName().endsWith(EXT_JAVA);
    }

    @Override
    public List<LookupElement> collectCompletionItems(PsiFile file, Document document, int offset, int maxCount) {
        ArrayList<LookupElement> results = new ArrayList<LookupElement>();
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace && offset > 0) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null && offset > 0) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null) {
            return results;
        }
        String prefix = this.extractPrefix(element);
        PsiElement memberTarget = this.detectJavaMemberAccess(element);
        if (memberTarget != null) {
            this.collectMembersFrom(memberTarget, results, maxCount, prefix);
            return results;
        }
        this.collectScopeSymbols(element, results, maxCount, prefix);
        return results;
    }

    private PsiElement detectJavaMemberAccess(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        String parentClassName = parent.getClass().getName();
        String parentText = parent.getText();
        if (!parentClassName.contains(PSI_REFERENCE_EXPRESSION)) {
            return null;
        }
        if (!parentText.contains(".")) {
            return null;
        }
        try {
            Method getQualifierExpression = parent.getClass().getMethod(METHOD_GET_QUALIFIER_EXPRESSION, new Class[0]);
            Object qualifier = getQualifierExpression.invoke((Object)parent, new Object[0]);
            if (qualifier instanceof PsiElement) {
                PsiElement resolved;
                PsiElement qualifierElement = (PsiElement)qualifier;
                PsiReference ref = qualifierElement.getReference();
                if (ref != null && (resolved = ref.resolve()) != null) {
                    return resolved;
                }
                return qualifierElement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getLanguageId() {
        return "Java";
    }

    private void collectMembersFrom(PsiElement element, List<LookupElement> results, int maxCount, String prefix) {
        PsiElement resolved;
        String className = element.getClass().getName();
        if (className.contains("MethodCall") && (resolved = this.resolveMethodCallReturnType(element)) != null && resolved != element) {
            this.collectJavaMembers(resolved, results, maxCount, false, prefix);
            return;
        }
        if (className.contains(PSI_JAVA_VARIABLE) && (resolved = this.resolveJavaVariable(element)) != null && resolved != element) {
            this.collectJavaMembers(resolved, results, maxCount, false, prefix);
            return;
        }
        boolean staticOnly = className.contains(PSI_JAVA_CLASS);
        this.collectJavaMembers(element, results, maxCount, staticOnly, prefix);
    }

    private PsiElement resolveMethodCallReturnType(PsiElement methodCall) {
        if (methodCall instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)methodCall;
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return null;
            }
            try {
                PsiClass resolvedClass = PsiUtil.resolveClassInType((PsiType)returnType);
                if (resolvedClass != null) {
                    return resolvedClass;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private PsiElement resolveJavaVariable(PsiElement variable) {
        PsiVariable psiVariable;
        PsiType type;
        if (variable instanceof PsiVariable && (type = (psiVariable = (PsiVariable)variable).getType()) != null) {
            try {
                PsiClass resolvedClass = PsiUtil.resolveClassInType((PsiType)type);
                if (resolvedClass != null) {
                    return resolvedClass;
                }
            }
            catch (Exception e) {
                LogManager.error(this.getClass(), "[JavaCompletion] Failed to resolve variable type: " + e.getMessage());
            }
        }
        return null;
    }

    private void collectJavaMembers(PsiElement element, List<LookupElement> results, int maxCount, boolean staticOnly, String prefix) {
        for (PsiElement child : element.getChildren()) {
            String name;
            if (results.size() >= maxCount) break;
            String childClassName = child.getClass().getName();
            if (this.isPrivateOrProtected(child) || staticOnly && !this.isStatic(child) || !staticOnly && this.isStatic(child) || !(child instanceof PsiNamedElement) || !this.shouldIncludeName(name = ((PsiNamedElement)child).getName(), prefix)) continue;
            results.add(this.createJavaLookupElement((PsiNamedElement)child, name, childClassName));
        }
    }

    private boolean shouldIncludeName(String name, String prefix) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.startsWith("<")) {
            return false;
        }
        if (name.startsWith("_")) {
            return false;
        }
        return prefix == null || prefix.isEmpty() || name.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private boolean isStatic(PsiElement element) {
        try {
            Method getModifierList = element.getClass().getMethod(METHOD_GET_MODIFIER_LIST, new Class[0]);
            Object modifierList = getModifierList.invoke((Object)element, new Object[0]);
            if (modifierList != null) {
                Method hasModifierProperty = modifierList.getClass().getMethod(METHOD_HAS_MODIFIER_PROPERTY, String.class);
                return (Boolean)hasModifierProperty.invoke(modifierList, MODIFIER_STATIC);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isPrivateOrProtected(PsiElement element) {
        try {
            Method getModifierList = element.getClass().getMethod(METHOD_GET_MODIFIER_LIST, new Class[0]);
            Object modifierList = getModifierList.invoke((Object)element, new Object[0]);
            if (modifierList != null) {
                Method hasModifierProperty = modifierList.getClass().getMethod(METHOD_HAS_MODIFIER_PROPERTY, String.class);
                boolean isPrivate = (Boolean)hasModifierProperty.invoke(modifierList, MODIFIER_PRIVATE);
                boolean isProtected = (Boolean)hasModifierProperty.invoke(modifierList, MODIFIER_PROTECTED);
                return isPrivate || isProtected;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private LookupElement createJavaLookupElement(PsiNamedElement element, String name, String className) {
        String fieldType;
        LookupElementBuilder builder = LookupElementBuilder.create((Object)element, (String)name);
        if (className.contains(PSI_JAVA_METHOD)) {
            String signature = this.extractJavaMethodSignature((PsiElement)element);
            builder = builder.withTailText(signature, true);
            String returnType = this.extractJavaReturnType((PsiElement)element);
            if (returnType != null) {
                builder = builder.withTypeText(returnType);
            }
        } else if (className.contains(PSI_JAVA_FIELD) && (fieldType = this.extractJavaFieldType((PsiElement)element)) != null) {
            builder = builder.withTypeText(fieldType);
        }
        return builder;
    }

    private String extractJavaMethodSignature(PsiElement method) {
        try {
            Method getParameterList = method.getClass().getMethod(METHOD_GET_PARAMETER_LIST, new Class[0]);
            Object paramList = getParameterList.invoke((Object)method, new Object[0]);
            if (paramList != null) {
                Method getParameters = paramList.getClass().getMethod(METHOD_GET_PARAMETERS, new Class[0]);
                Object[] parameters = (Object[])getParameters.invoke(paramList, new Object[0]);
                StringBuilder sig = new StringBuilder("(");
                for (int i = 0; i < parameters.length; ++i) {
                    String paramName;
                    String paramType;
                    if (i > 0) {
                        sig.append(", ");
                    }
                    if ((paramType = this.extractParameterType(parameters[i])) != null) {
                        sig.append(paramType);
                    }
                    if (!(parameters[i] instanceof PsiNamedElement) || (paramName = ((PsiNamedElement)parameters[i]).getName()) == null) continue;
                    if (paramType != null) {
                        sig.append(" ");
                    }
                    sig.append(paramName);
                }
                sig.append(")");
                return sig.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "()";
    }

    private String extractParameterType(Object parameter) {
        block6: {
            try {
                Method getType = parameter.getClass().getMethod(METHOD_GET_TYPE, new Class[0]);
                Object type = getType.invoke(parameter, new Object[0]);
                if (type == null) break block6;
                try {
                    Method getPresentableText = type.getClass().getMethod("getPresentableText", new Class[0]);
                    Object text = getPresentableText.invoke(type, new Object[0]);
                    if (text != null) {
                        return text.toString();
                    }
                }
                catch (Exception e) {
                    String typeStr = type.toString();
                    if (typeStr.startsWith("PsiType:")) {
                        return typeStr.substring("PsiType:".length());
                    }
                    return typeStr;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String extractJavaReturnType(PsiElement method) {
        block6: {
            try {
                Method getReturnType = method.getClass().getMethod("getReturnType", new Class[0]);
                Object returnType = getReturnType.invoke((Object)method, new Object[0]);
                if (returnType == null) break block6;
                try {
                    Method getPresentableText = returnType.getClass().getMethod("getPresentableText", new Class[0]);
                    Object text = getPresentableText.invoke(returnType, new Object[0]);
                    if (text != null) {
                        return text.toString();
                    }
                }
                catch (Exception e) {
                    String typeStr = returnType.toString();
                    if (typeStr.startsWith("PsiType:")) {
                        return typeStr.substring("PsiType:".length());
                    }
                    return typeStr;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String extractJavaFieldType(PsiElement field) {
        block6: {
            try {
                Method getType = field.getClass().getMethod(METHOD_GET_TYPE, new Class[0]);
                Object type = getType.invoke((Object)field, new Object[0]);
                if (type == null) break block6;
                try {
                    Method getPresentableText = type.getClass().getMethod("getPresentableText", new Class[0]);
                    Object text = getPresentableText.invoke(type, new Object[0]);
                    if (text != null) {
                        return text.toString();
                    }
                }
                catch (Exception e) {
                    String typeStr = type.toString();
                    if (typeStr.startsWith("PsiType:")) {
                        return typeStr.substring("PsiType:".length());
                    }
                    return typeStr;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

