/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.manager.code.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.code.completion.BaseCompletionHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaScriptCompletionHandler
extends BaseCompletionHandler {
    private static final String EXT_JS = ".js";
    private static final String EXT_TS = ".ts";
    private static final String EXT_JSX = ".jsx";
    private static final String EXT_TSX = ".tsx";
    private static final String PSI_JS_VARIABLE = "JSVariable";
    private static final String PSI_JS_FUNCTION = "JSFunction";
    private static final String PSI_JS_CLASS = "JSClass";
    private static final String PSI_ES6_CLASS = "ES6Class";
    private static final String PSI_CALL_EXPRESSION = "CallExpression";
    private static final String PSI_ARGUMENT_LIST = "ArgumentList";
    private static final String PSI_LITERAL = "Literal";
    private static final String PSI_BLOCK = "Block";
    private static final String METHOD_GET_INITIALIZER = "getInitializer";
    private static final String METHOD_GET_PARAMETER_LIST = "getParameterList";
    private static final String METHOD_GET_PARAMETERS = "getParameters";
    private static final String TYPE_TEXT_FUNCTION = "function";
    private static final String LOG_PREFIX = "[JS] ";

    @Override
    public boolean supports(PsiFile file) {
        String fileName = file.getName();
        return fileName.endsWith(EXT_JS) || fileName.endsWith(EXT_TS) || fileName.endsWith(EXT_JSX) || fileName.endsWith(EXT_TSX);
    }

    @Override
    public List<LookupElement> collectCompletionItems(PsiFile file, Document document, int offset, int maxCount) {
        ArrayList<LookupElement> results = new ArrayList<LookupElement>();
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace && offset > 0) {
            LogManager.info(this.getClass(), "[JS] Skipping whitespace, trying offset-1");
            element = file.findElementAt(offset - 1);
        }
        if (element == null && offset > 0) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null) {
            LogManager.info(this.getClass(), "[JS] No element at offset");
            return results;
        }
        String prefix = this.extractPrefix(element);
        LogManager.info(this.getClass(), "[JS] Extracted prefix: '" + prefix + "'");
        PsiElement memberTarget = this.detectMemberAccess(element);
        if (memberTarget != null) {
            this.collectMembersFrom(memberTarget, results, maxCount);
            return results;
        }
        LogManager.info(this.getClass(), "[JS] Collecting scope symbols with prefix='" + prefix + "'");
        this.collectScopeSymbols(element, results, maxCount, prefix);
        return results;
    }

    @Override
    public String getLanguageId() {
        return "JavaScript";
    }

    private void collectMembersFrom(PsiElement element, List<LookupElement> results, int maxCount) {
        PsiElement resolved;
        String className = element.getClass().getName();
        if (className.contains(PSI_JS_VARIABLE) && (resolved = this.resolveJSVariable(element)) != null && resolved != element) {
            this.collectMembersFrom(resolved, results, maxCount);
            return;
        }
        if (element instanceof PsiFile) {
            this.collectExportsFromFile((PsiFile)element, results, maxCount);
            return;
        }
        this.collectNamedMembers(element, results, maxCount);
    }

    private PsiElement resolveJSVariable(PsiElement variable) {
        try {
            Method getInitializer = variable.getClass().getMethod(METHOD_GET_INITIALIZER, new Class[0]);
            Object initializer = getInitializer.invoke((Object)variable, new Object[0]);
            if (initializer instanceof PsiElement) {
                PsiElement resolvedFile;
                PsiElement initElement = (PsiElement)initializer;
                String initClassName = initElement.getClass().getName();
                if (initClassName.contains(PSI_CALL_EXPRESSION) && (resolvedFile = this.resolveModuleFile(initElement)) != null) {
                    return resolvedFile;
                }
                return initElement;
            }
        }
        catch (Exception e) {
            LogManager.info(this.getClass(), "[JS] Failed to resolve variable: " + e.getMessage());
        }
        return null;
    }

    private PsiElement resolveModuleFile(PsiElement callExpression) {
        try {
            for (PsiElement child : callExpression.getChildren()) {
                String childClassName = child.getClass().getName();
                if (!childClassName.contains(PSI_ARGUMENT_LIST)) continue;
                for (PsiElement arg : child.getChildren()) {
                    PsiReference[] refs;
                    String argClassName = arg.getClass().getName();
                    if (!argClassName.contains(PSI_LITERAL)) continue;
                    for (PsiReference ref : refs = arg.getReferences()) {
                        PsiElement resolved = ref.resolve();
                        if (!(resolved instanceof PsiFile)) continue;
                        String fileName = ((PsiFile)resolved).getName();
                        LogManager.info(this.getClass(), "[JS] Resolved module: " + fileName);
                        return resolved;
                    }
                }
            }
        }
        catch (Exception e) {
            LogManager.info(this.getClass(), "[JS] Failed to resolve module: " + e.getMessage());
        }
        return null;
    }

    private void collectExportsFromFile(PsiFile file, List<LookupElement> results, int maxCount) {
        for (PsiElement child : file.getChildren()) {
            String name;
            String className = child.getClass().getName();
            if (className.contains(PSI_ES6_CLASS) || className.contains(PSI_JS_CLASS)) {
                this.collectNamedMembers(child, results, maxCount);
                continue;
            }
            if (!(child instanceof PsiNamedElement) || !this.shouldIncludeName(name = ((PsiNamedElement)child).getName())) continue;
            results.add(this.createJSLookupElement((PsiNamedElement)child, name));
        }
    }

    private void collectNamedMembers(PsiElement element, List<LookupElement> results, int maxCount) {
        if (results.size() >= maxCount) {
            return;
        }
        for (PsiElement child : element.getChildren()) {
            String name;
            String childClassName = child.getClass().getName();
            if (child instanceof PsiNamedElement && this.shouldIncludeName(name = ((PsiNamedElement)child).getName())) {
                results.add(this.createJSLookupElement((PsiNamedElement)child, name));
            }
            if (childClassName.contains(PSI_JS_FUNCTION) || childClassName.contains(PSI_BLOCK)) continue;
            this.collectNamedMembers(child, results, maxCount);
        }
    }

    private LookupElement createJSLookupElement(PsiNamedElement element, String name) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)element, (String)name);
        String className = element.getClass().getName();
        if (className.contains(PSI_JS_FUNCTION)) {
            String signature = this.extractJSFunctionSignature((PsiElement)element);
            builder = builder.withTailText(signature, true);
            builder = builder.withTypeText(TYPE_TEXT_FUNCTION);
        }
        return builder;
    }

    private String extractJSFunctionSignature(PsiElement function) {
        try {
            Method getParameterList = function.getClass().getMethod(METHOD_GET_PARAMETER_LIST, new Class[0]);
            Object paramList = getParameterList.invoke((Object)function, new Object[0]);
            if (paramList != null) {
                Method getParameters = paramList.getClass().getMethod(METHOD_GET_PARAMETERS, new Class[0]);
                Object[] parameters = (Object[])getParameters.invoke(paramList, new Object[0]);
                StringBuilder sig = new StringBuilder("(");
                for (int i = 0; i < parameters.length; ++i) {
                    String paramName;
                    if (!(parameters[i] instanceof PsiNamedElement) || (paramName = ((PsiNamedElement)parameters[i]).getName()) == null) continue;
                    if (i > 0) {
                        sig.append(", ");
                    }
                    sig.append(paramName);
                }
                sig.append(")");
                return sig.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "()";
    }
}

