/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.common.Language;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.settings.SettingsForm;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.ShortCutUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.stream.IntStream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ChatSetting
extends JBPanel
implements IConfigurable {
    private boolean funcTipsEnable;
    private boolean inlinePopupEnable;
    private JBCheckBox funcTipsToggle;
    private JBCheckBox inlinePopupToggle;
    private boolean inlineChatEnable;
    private String chatOutputLanguage;
    private String chatDocLanguage;
    private boolean autoRunEnable;
    private JBCheckBox autoRunToggle;
    private boolean taskListEnable;
    private JBCheckBox taskListToggle;
    private JBCheckBox inlineChatToggle;
    private ComboBox<SettingsForm.ComboBoxItem> outputLanguageComboBox;
    private ComboBox<SettingsForm.ComboBoxItem> chatDocLanguageComboBox;
    private final SettingsForm.ComboBoxItem[] languageItems = new SettingsForm.ComboBoxItem[]{new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.chat.language.zh"), Language.Chinese.getName()), new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.chat.language.en"), Language.English.getName())};

    public ChatSetting() {
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        TitledSeparator titledSeparator = new TitledSeparator(LocaleManager.get("chat"));
        this.add((Component)titledSeparator);
        this.funcTipsEnable = CopilotSettingsService.getInstance().isFuncTipsEnable();
        this.inlineChatEnable = CopilotSettingsService.getInstance().isInlineChatEnable();
        this.autoRunEnable = CopilotSettingsService.getInstance().getAutoRun();
        this.taskListEnable = CopilotSettingsService.getInstance().getTaskList();
        this.initFuncTipsComponent();
        this.initInlineChatComponent();
        this.initAutoRunComponent();
        this.initTaskListComponent();
        boolean isLogged = CopilotSettingsService.getInstance().isLogin();
        if (isLogged) {
            this.initInlinePopupComponent();
            this.initChatResponseLanguageComponent();
            this.inlinePopupEnable = CopilotSettingsService.getInstance().isInlinePopupEnable();
            this.chatOutputLanguage = CopilotSettingsService.getInstance().getChatModelOutputLanguage();
            this.chatDocLanguage = CopilotSettingsService.getInstance().getChatModelDocumentLanguage();
        }
    }

    private void initFuncTipsComponent() {
        JBPanel panelCompletion = new JBPanel((LayoutManager)new BorderLayout());
        this.funcTipsToggle = new JBCheckBox(LocaleManager.get("ui.settings.funcTips.toggle.text"), this.funcTipsEnable);
        this.funcTipsToggle.addChangeListener(e -> {
            this.funcTipsEnable = this.funcTipsToggle.isSelected();
        });
        panelCompletion.add((Component)this.funcTipsToggle, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.method.hint.tips"));
        textPane.setFont(UIUtil.getLabelFont());
        panelCompletion.add((Component)textPane, (Object)"Center");
        this.add((Component)panelCompletion);
    }

    private void initInlinePopupComponent() {
        JBPanel panelInlineChat = new JBPanel((LayoutManager)new BorderLayout());
        this.inlinePopupToggle = new JBCheckBox(LocaleManager.get("ui.settings.inlinePopup.toggle.text"), this.inlinePopupEnable);
        this.inlinePopupToggle.addChangeListener(e -> {
            this.inlinePopupEnable = this.inlinePopupToggle.isSelected();
        });
        panelInlineChat.add((Component)this.inlinePopupToggle, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.settings.inlinePopup.toggle.desc"));
        textPane.setFont(UIUtil.getLabelFont());
        panelInlineChat.add((Component)textPane, (Object)"Center");
        this.add((Component)panelInlineChat);
    }

    private void initInlineChatComponent() {
        JBPanel panelInlineChat = new JBPanel((LayoutManager)new BorderLayout());
        this.inlineChatToggle = new JBCheckBox(LocaleManager.get("ui.settings.inlineChat.toggle.text"), this.inlineChatEnable);
        this.inlineChatToggle.addChangeListener(e -> {
            this.inlineChatEnable = this.inlineChatToggle.isSelected();
        });
        panelInlineChat.add((Component)this.inlineChatToggle, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textPane.setLineWrap(true);
        String shortcut = ShortCutUtils.getShortcutText("codingcopilot.inlineChat.startalt+k", "");
        textPane.setText(LocaleManager.get("ui.settings.inlineChat.toggle.desc", shortcut));
        textPane.setFont(UIUtil.getLabelFont());
        panelInlineChat.add((Component)textPane, (Object)"Center");
        this.add((Component)panelInlineChat);
    }

    private void initAutoRunComponent() {
        JBPanel panelAutoRun = new JBPanel((LayoutManager)new BorderLayout());
        this.autoRunToggle = new JBCheckBox(LocaleManager.get("ui.settings.autoRun.toggle.text"), this.autoRunEnable);
        this.autoRunToggle.addChangeListener(e -> {
            this.autoRunEnable = this.autoRunToggle.isSelected();
        });
        panelAutoRun.add((Component)this.autoRunToggle, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.settings.autoRun.toggle.desc"));
        textPane.setFont(UIUtil.getLabelFont());
        panelAutoRun.add((Component)textPane, (Object)"Center");
        this.add((Component)panelAutoRun);
    }

    private void initTaskListComponent() {
        JBPanel panelTaskList = new JBPanel((LayoutManager)new BorderLayout());
        this.taskListToggle = new JBCheckBox(LocaleManager.get("ui.settings.taskList.toggle.text"), this.taskListEnable);
        this.taskListToggle.addChangeListener(e -> {
            this.taskListEnable = this.taskListToggle.isSelected();
        });
        panelTaskList.add((Component)this.taskListToggle, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.settings.taskList.toggle.desc"));
        textPane.setFont(UIUtil.getLabelFont());
        panelTaskList.add((Component)textPane, (Object)"Center");
        this.add((Component)panelTaskList);
    }

    private void initChatResponseLanguageComponent() {
        JBPanel commentPanel = new JBPanel((LayoutManager)new BorderLayout());
        JBLabel commentLabel = new JBLabel(LocaleManager.get("ui.settings.chat.model.document.language"));
        commentLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
        commentPanel.add((Component)commentLabel, (Object)"North");
        this.chatDocLanguageComboBox = this.createLanguageComboBox(this.languageItems, this.chatDocLanguage);
        this.chatDocLanguageComboBox.addActionListener(e -> {
            SettingsForm.ComboBoxItem selectedItem = (SettingsForm.ComboBoxItem)this.chatDocLanguageComboBox.getSelectedItem();
            if (selectedItem != null) {
                this.chatDocLanguage = selectedItem.getValue();
            }
        });
        commentPanel.add(this.chatDocLanguageComboBox, (Object)"West");
        this.add((Component)commentPanel);
    }

    @NotNull
    private ComboBox<SettingsForm.ComboBoxItem> createLanguageComboBox(SettingsForm.ComboBoxItem[] items, String selectedValue) {
        ComboBox comboBox = new ComboBox((Object[])items);
        comboBox.setPreferredSize(new Dimension(300, comboBox.getPreferredSize().height));
        comboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SettingsForm.ComboBoxItem) {
                    this.setText(((SettingsForm.ComboBoxItem)value).getText());
                }
                return this;
            }
        });
        IntStream.range(0, items.length).filter(i -> items[i].getValue().equals(selectedValue)).findFirst().ifPresent(arg_0 -> comboBox.setSelectedIndex(arg_0));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            ChatSetting.$$$reportNull$$$0(0);
        }
        return comboBox2;
    }

    @Override
    public void apply() throws ConfigurationException {
        CopilotSettingsService.getInstance().setFuncTipsEnable(this.funcTipsEnable);
        CopilotSettingsService.getInstance().setAutoRun(this.autoRunEnable);
        CopilotSettingsService.getInstance().setTaskList(this.taskListEnable);
        if (CopilotSettingsService.getInstance().isLogin()) {
            CopilotSettingsService.getInstance().setInlinePopupEnable(this.inlinePopupEnable);
            CopilotSettingsService.getInstance().setChatModelOutputLanguage(this.chatOutputLanguage);
            CopilotSettingsService.getInstance().setChatModelDocumentLanguage(this.chatDocLanguage);
        }
        CopilotSettingsService.getInstance().setInlineChatEnable(this.inlineChatEnable);
    }

    @Override
    public void reset() {
        this.funcTipsToggle.setSelected(this.funcTipsEnable);
        if (this.inlinePopupToggle != null) {
            this.inlinePopupToggle.setSelected(this.inlinePopupEnable);
        }
        if (this.inlineChatToggle != null) {
            this.inlineChatToggle.setSelected(this.inlineChatEnable);
        }
        if (this.autoRunToggle != null) {
            this.autoRunEnable = CopilotSettingsService.getInstance().getAutoRun();
            this.autoRunToggle.setSelected(this.autoRunEnable);
        }
        if (this.taskListToggle != null) {
            this.taskListEnable = CopilotSettingsService.getInstance().getTaskList();
            this.taskListToggle.setSelected(this.taskListEnable);
        }
        if (this.outputLanguageComboBox != null) {
            String outputLanguage = CopilotSettingsService.getInstance().getChatModelOutputLanguage();
            IntStream.range(0, this.languageItems.length).filter(i -> this.languageItems[i].getValue().equals(outputLanguage)).findFirst().ifPresent(arg_0 -> this.outputLanguageComboBox.setSelectedIndex(arg_0));
        }
        if (this.chatDocLanguageComboBox != null) {
            String docLanguage = CopilotSettingsService.getInstance().getChatModelDocumentLanguage();
            IntStream.range(0, this.languageItems.length).filter(i -> this.languageItems[i].getValue().equals(docLanguage)).findFirst().ifPresent(arg_0 -> this.chatDocLanguageComboBox.setSelectedIndex(arg_0));
        }
    }

    @Override
    public boolean isModified() {
        boolean isInlinePopupEnableModified = false;
        boolean isInlineChatEnableModified = false;
        boolean isChatOutputLanguageModified = false;
        boolean isChatDocumentLanguageModified = false;
        boolean isAutoRunEnableModified = false;
        boolean isTaskListEnableModified = false;
        boolean isLogged = CopilotSettingsService.getInstance().isLogin();
        if (isLogged) {
            isInlinePopupEnableModified = this.inlinePopupEnable != CopilotSettingsService.getInstance().isInlinePopupEnable();
            String currentOutputLanguage = null;
            if (this.outputLanguageComboBox != null && this.outputLanguageComboBox.getSelectedItem() != null) {
                currentOutputLanguage = ((SettingsForm.ComboBoxItem)this.outputLanguageComboBox.getSelectedItem()).getValue();
            }
            isChatOutputLanguageModified = currentOutputLanguage != null && !currentOutputLanguage.equals(CopilotSettingsService.getInstance().getChatModelOutputLanguage());
            String currentDocLanguage = null;
            if (this.chatDocLanguageComboBox != null && this.chatDocLanguageComboBox.getSelectedItem() != null) {
                currentDocLanguage = ((SettingsForm.ComboBoxItem)this.chatDocLanguageComboBox.getSelectedItem()).getValue();
            }
            isChatDocumentLanguageModified = currentDocLanguage != null && !currentDocLanguage.equals(CopilotSettingsService.getInstance().getChatModelDocumentLanguage());
        }
        isInlineChatEnableModified = this.inlineChatEnable != CopilotSettingsService.getInstance().isInlineChatEnable();
        isAutoRunEnableModified = this.autoRunEnable != CopilotSettingsService.getInstance().getAutoRun();
        isTaskListEnableModified = this.taskListEnable != CopilotSettingsService.getInstance().getTaskList();
        return this.funcTipsEnable != CopilotSettingsService.getInstance().isFuncTipsEnable() || isInlinePopupEnableModified || isInlineChatEnableModified || isChatOutputLanguageModified || isChatDocumentLanguageModified || isAutoRunEnableModified || isTaskListEnableModified;
    }

    public boolean isFuncTipsEnable() {
        return this.funcTipsEnable;
    }

    public boolean isInlinePopupEnable() {
        return this.inlinePopupEnable;
    }

    public boolean isInlineChatEnable() {
        return this.inlineChatEnable;
    }

    public String getChatOutputLanguage() {
        return this.chatOutputLanguage;
    }

    public String getChatDocLanguage() {
        return this.chatDocLanguage;
    }

    public boolean isAutoRunEnable() {
        return this.autoRunEnable;
    }

    public boolean isTaskListEnable() {
        return this.taskListEnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/tencent/code/intel/settings/ChatSetting", "createLanguageComboBox"));
    }
}

