/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.CopilotEditorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.border.Border;

public class CodeIndexSetting
extends JBPanel
implements IConfigurable {
    private boolean codeIndexEnable;
    private JBCheckBox codeIndexEnableToggle;

    public CodeIndexSetting() {
        this.initSetting();
        this.setLayout(new BorderLayout());
        this.createCodeStylePan();
    }

    private void initSetting() {
        this.codeIndexEnable = CopilotSettingsService.getInstance().isEnableCodeIndexingForCompletion();
    }

    private void createCodeStylePan() {
        TitledSeparator titledSeparator = new TitledSeparator(LocaleManager.get("ui.code.index.enable.title"));
        this.add((Component)titledSeparator, "North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.code.index.enable.tips"));
        this.add((Component)textPane, "Center");
        this.codeIndexEnableToggle = new JBCheckBox(LocaleManager.get("ui.code.index.enable.toggle"), this.codeIndexEnable);
        this.codeIndexEnableToggle.addChangeListener(e -> {
            this.codeIndexEnable = this.codeIndexEnableToggle.isSelected();
        });
        this.add((Component)this.codeIndexEnableToggle, "South");
    }

    @Override
    public void apply() throws ConfigurationException {
        String content;
        Project project;
        int resultValue;
        boolean codeIndexOld = CopilotSettingsService.getInstance().isEnableCodeIndexingForCompletion();
        CopilotSettingsService.getInstance().setEnableCodeIndexingForCompletion(this.codeIndexEnable);
        if (codeIndexOld == this.codeIndexEnable || (resultValue = Messages.showDialog((Project)(project = CopilotEditorUtils.getFirstProject()), (String)(content = this.codeIndexEnable ? LocaleManager.get("ui.code.index.enable.and.reboot") : LocaleManager.get("ui.code.index.disable.and.reboot")), (String)LocaleManager.get("ui.code.index.enable.title"), (String[])new String[]{LocaleManager.get("restart_now"), LocaleManager.get("cancel")}, (int)0, (Icon)Messages.getInformationIcon())) == 0) {
            // empty if block
        }
    }

    @Override
    public void reset() {
        boolean codeIndexOld = CopilotSettingsService.getInstance().isEnableCodeIndexingForCompletion();
        this.codeIndexEnableToggle.setSelected(codeIndexOld);
    }

    @Override
    public boolean isModified() {
        boolean codeIndexOld = CopilotSettingsService.getInstance().isEnableCodeIndexingForCompletion();
        this.codeIndexEnable = this.codeIndexEnableToggle.isSelected();
        return codeIndexOld != this.codeIndexEnable;
    }
}

