/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.common.CodeStyle;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.settings.SettingsForm;
import com.tencent.code.intel.util.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.stream.IntStream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSetting
extends JBPanel
implements IConfigurable {
    private ComboBox<SettingsForm.ComboBoxItem> codeStyleComboBox;
    private String codeStyle;
    private final SettingsForm.ComboBoxItem[] codeStyleItems = new SettingsForm.ComboBoxItem[]{new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.codestyle.eager"), CodeStyle.EAGER.getName()), new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.codestyle.line"), CodeStyle.LINE.getName())};

    public CodeStyleSetting() {
        this.initSetting();
        this.setLayout(new BorderLayout());
        this.createCodeStylePan();
    }

    private void initSetting() {
        this.codeStyle = CopilotSettingsService.getInstance().getCodeStyle();
        if (TextUtils.isBlank((CharSequence)this.codeStyle)) {
            this.codeStyle = CodeStyle.MODERATE.getName();
            CopilotSettingsService.getInstance().setCodeStyle(this.codeStyle);
        }
    }

    private void createCodeStylePan() {
        TitledSeparator titledSeparator = new TitledSeparator(LocaleManager.get("ui.settings.codestyle.title"));
        this.add((Component)titledSeparator, "North");
        JBPanel panelCodeStyle = new JBPanel((LayoutManager)new BorderLayout());
        JBPanel panCBProxyType = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        JComboBox<SettingsForm.ComboBoxItem> cbCodeStyle = this.createCodeStyleComboBox(this.codeStyleItems);
        panCBProxyType.add(cbCodeStyle);
        panelCodeStyle.add((Component)panCBProxyType, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground((Color)JBColor.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)0));
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.settings.codestyle.toggle.desc"));
        textPane.setFont(UIUtil.getLabelFont());
        panelCodeStyle.add((Component)textPane, (Object)"Center");
        this.add((Component)panelCodeStyle, "Center");
    }

    @NotNull
    private JComboBox<SettingsForm.ComboBoxItem> createCodeStyleComboBox(SettingsForm.ComboBoxItem[] items) {
        this.codeStyleComboBox = new ComboBox((Object[])items);
        this.codeStyleComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SettingsForm.ComboBoxItem) {
                    this.setText(((SettingsForm.ComboBoxItem)value).getText());
                }
                return this;
            }
        });
        this.codeStyleComboBox.addActionListener(e -> {
            SettingsForm.ComboBoxItem selectedItem = (SettingsForm.ComboBoxItem)this.codeStyleComboBox.getSelectedItem();
            if (selectedItem != null) {
                this.codeStyle = selectedItem.getValue();
            }
        });
        Dimension preferredSize = this.codeStyleComboBox.getPreferredSize();
        preferredSize.width = 360;
        this.codeStyleComboBox.setPreferredSize(preferredSize);
        this.codeStyleComboBox.setMaximumSize(preferredSize);
        IntStream.range(0, items.length).filter(i -> items[i].getValue().equals(this.codeStyle)).findFirst().ifPresent(arg_0 -> this.codeStyleComboBox.setSelectedIndex(arg_0));
        ComboBox<SettingsForm.ComboBoxItem> comboBox = this.codeStyleComboBox;
        if (comboBox == null) {
            CodeStyleSetting.$$$reportNull$$$0(0);
        }
        return comboBox;
    }

    @Override
    public void apply() throws ConfigurationException {
        CopilotSettingsService.getInstance().setCodeStyle(this.codeStyle);
    }

    @Override
    public void reset() {
        String codeStyleOld = CopilotSettingsService.getInstance().getCodeStyle();
        IntStream.range(0, this.codeStyleItems.length).filter(i -> this.codeStyleItems[i].getValue().equals(codeStyleOld)).findFirst().ifPresent(arg_0 -> this.codeStyleComboBox.setSelectedIndex(arg_0));
    }

    @Override
    public boolean isModified() {
        String codeStyleOld = CopilotSettingsService.getInstance().getCodeStyle();
        this.codeStyle = ((SettingsForm.ComboBoxItem)this.codeStyleComboBox.getSelectedItem()).getValue();
        return !codeStyleOld.equals(this.codeStyle);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/tencent/code/intel/settings/CodeStyleSetting", "createCodeStyleComboBox"));
    }
}

